<?php

namespace App\Modules\Natureza51\Entities;

class OrcLotacaoNaturezaEvento extends NaturezaEntity
{
    
    
    protected $fillable = [ 
        'orcamento_id', 'lotacao_id', 'ccontabil_id', 'evento_id', 'total', 'formula'
    ];
    protected $attributes=['orcamento_id'=>'', 'lotacao_id'=>'', 'ccontabil_id'=>'', 'evento_id'=>'', 'total'=>'', 'formula'=>''];
    
    
    protected $table = 'tbl_orc_lotacao_natureza_evento';
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
   
   public function getOrcamento(){
       return $this->belongsTo('App\Modules\Natureza51\Entities\Orcamento', 'orcamento_id');
   }
   public function getEventos(){
       return $this->hasOne('App\Modules\Natureza51\Entities\Eventos', 'evento_id');
   }
   public function getLotacao(){
       return $this->hasOne('App\Modules\Natureza51\Entities\Lotacao', 'lotacao_id');
   }
   public function getCContabil(){
       return $this->hasOne('App\Modules\Natureza51\Entities\ContaContabil', 'ccontabil_id');
   }
}
