<?php

namespace App\Modules\Natureza51\Entities;

class Orcamento extends NaturezaEntity
{
    
   
    
    protected $fillable = [         
        'empresa_id', 'cod_orcamento', 'ano', 'descricao_orc', 'status_aprovacao',
        'responsavel_id', 'status_orc', 'versao', 'revisao', 'responsavel_tec_id',
        'created_at', 'user_id', 'updated_at','versao_desc', 'revisao_desc', 'data_inicio','data_fim','mes_ini_frc'
    ];
    protected $attributes=[
        'empresa_id' =>'2', 'cod_orcamento' =>'', 'ano' =>'', 'descricao_orc' =>'', 
        'status_aprovacao' =>'1', 'responsavel_id' =>'', 'status_orc' =>'1', 'versao' =>'', 
        'revisao' =>'', 'responsavel_tec_id' =>'','created_at' =>'', 'user_id' =>'', 'updated_at' =>'',
'versao_desc'=>'', 'revisao_desc'=>'', 'data_inicio'=>'','data_fim'=>'','mes_ini_frc'=>''        
        ];
    // protected $guarded = ['id'];
    protected $table = 'tbl_orcamento';
    
   const UPDATED_AT = null;
   const CREATED_AT = null;
   
   public function getLotacaoNaturezaEventos(){
       return $this->hasMany('App\Modules\Natureza51\Entities\OrcLotacaoNaturezaEvento','orcamento_id');
   }
   public function getLotacaoOrcMovDespesas(){
    return $this->hasMany('App\Modules\Natureza51\Entities\OrcMovDespesas','orc_id');
   }
   public function getCargoAreaSalario(){
       return $this->hasMany('App\Modules\Natureza51\Entities\OrcCargosAreaSal','orcamento_id');
   }

   public function getOrcPremissas(){
       return $this->hasOne('App\Modules\Natureza51\Entities\OrcPremissas','orcamento_id');
   }

   public function getCronograma(){
       //return $this->hasMany('App\Modules\Natureza51\Entities\OrcCargosAreaSal','orcamento_id');
   }

   
   
}
