<?php
namespace App\Modules\Natureza51\Entities;

class PlanoLotacUnid extends NaturezaEntity{
    protected $fillable=[
        'empresa_id', 'plano_lotac_tipo_id', 'lotacao_id', 'limite', 'seq_ud', 'origem', 'ativo'
    ];
    protected $attributes=[
        'empresa_id'=>'1', 'plano_lotac_tipo_id'=>'', 'lotacao_id'=>'', 'limite'=>'', 'seq_ud'=>'', 'origem'=>'1', 'ativo'=>''
    ];
    protected $table='tbl_plano_lotac_unid';

    const UPDATED_AT=null;
    const CREATED_AT=null;

    public function getPlanoLotacTp(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\PlanoLotacaoTipo','plano_lotac_tipo_id','id');
    }
    public function getLotacao(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Lotacao','lotacao_id','id');
    }
}