<?php
namespace App\Modules\Natureza51\Entities;

use Illuminate\Database\Eloquent\Model;

class OrcTurma extends NaturezaEntity
{
    protected $fillable = [
        'orc_id'
      ,'turma_id'
      ,'turno_id'
      ,'evento_adc_id'
      ,'evento_ext_id'
      ,'user_id'
      ,'cdn_turma_trab'
      ,'des_turma_trab'
      ,'adic_noturno'
      ,'extra_noturno'
      ,'ativo'
      ,'origem'
      ,'created_at'
      ,'updated_at'
    ];

    protected $attributes = [
        'orc_id' => ''
        ,'turma_id' => ''
        ,'turno_id' => ''
        ,'evento_adc_id' => ''
        ,'evento_ext_id' => ''
        ,'user_id' => '1'
        ,'cdn_turma_trab' => ''
        ,'des_turma_trab' => '' 
        ,'adic_noturno' => ''
        ,'extra_noturno' => ''
        ,'ativo' => ''
        ,'origem' => ''
        ,'updated_at' => ''
        ,'created_at' => ''
        
    ];

    public function getTurno(){
        return $this->belongsTo('App\Modules\Natureza51\Entities\Turno','turno_id','id');
    }

    public function getEvento(){
    return $this->belongsTo('App\Modules\Natureza51\Entities\Eventos','evento_adc_id','id');
    }
    
    protected $table = 'tbl_orc_turma';

    
    
}