<?php

namespace App\Modules\Natureza51\Http\Controllers;

use Illuminate\Http\Response;
use App\Modules\Natureza51\Repositories\RepoGrupoTreeTable as RepoGrupoTreeTable;
use Illuminate\Support\Arr;
use Illuminate\Support\Collection;

class GrupoTreeTableControllerTeste extends Natureza51Ctrl
{
     public function __construct(){
        $this->repository=new RepoGrupoTreeTable();
        parent::__construct();
    }

    function appendChildren($rows, $colunas){
        $retorno=[];
        $row_collection=$rows;
        
       
        $parent = $row_collection->where('parent_id', 0);
        foreach($parent as $data){
            $colunas_parse = $this->parseToColumn($colunas);

            $atual=[];
            
            $atual['data']=array_merge($data->only(['nome_item']), $colunas_parse); 
            
            
            $childrens = $row_collection->where('parent_id' , '=' , $data->id);

            if($childrens->count() > 0){                   
               $atual['children']=[];                    
            }
       
            foreach($childrens as $children_atual){            
                $child=$children_atual;
                $child_valores = $child->getValores(); 
                
                $a=$child->only(['nome_item']);
                $b= $this->extractValuesToColumns($colunas, $child_valores->get()->toArray());
                $c=array_merge($a, $b);
                $atual['children'][]= ['data' => $c];

            }
            $retorno[]=$atual;
        }
        
        return $retorno;        
       
        foreach($rows as $atual){
            
            $child=$atual;
            
            if(isset($child['get_valores'])){
                if(count($child['get_valores'])>0){
                    $child['children']='';
                }
            }
            $retorno[]= ['data' => $this->extractValuesToColumns($colunas, $child['get_valores'])];
        }
        return $retorno;
    }

    private function parseToColumn($colunas){
            /**
             * Parse to cols
             */       
            $prepared_row=[];

            array_map(function($curr) use(&$prepared_row) {
                $prepared_row[$curr['nome_coluna']]=$curr['valor_padrao'];
            }, $colunas );

            return $prepared_row;
    }

    private function parseToColumnItem($first){
        /**
         * Parse to cols
         */

        $prepared_row = [];
        array_map(function($curr) use(&$prepared_row) {
            $prepared_row['nome_item'][]=$curr['nome_item'];
        }, $first['get_grupo_tree_table_item']);

        return $prepared_row;
    }

    private function extractValuesToColumns($colunas, $data){
        
        $retorno=[];
        array_map(function($curr) use(&$retorno, $data) {
               
                $tem=array_filter($data, function($data_atual) use($curr) {                      
                       return  $data_atual['grupo_tree_coluna_id'] ==$curr['id'] ;
                });
                
                if(count($tem)>0){
                    $a=reset($tem);
                    $retorno[$curr['nome_coluna']] =$a['valor'];  
                }
        }, $colunas);
        
        return $retorno;
    }

    public function listar(){

    $result = $this->getRepositoryOrModel()
                    ->allWith(['getGrupoTreeTableItem'=>function($query)
                    {
                        $query->with('getValores');    
                    },
                    'getColunas'
                    ]);                    
                   
    $retorno = ['data' => []];    
    
    $first = $result->first();
    
    $colunas = $first->getColunas()->get()->toArray();
     
    $prepared_row = $this->parseToColumn($first->getColunas()->get()->toArray());
    
    foreach($result as $key => $data){
        
        $row_top=array_merge( $data->only(['nome']), $prepared_row);
        
        $retorno['data'][] = ['data' =>  $row_top,
                'children' => $this->appendChildren($data->getGrupoTreeTableItem()->get(), $colunas)  
        ];        
    }
    return $retorno;
    }
}