<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoAjustesSalariais as RepoAjustesSalariais;
// use App\Modules\Natureza51\Entities\CalcIndice;
use App\Modules\Natureza51\Entities\CargosArea;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\Lotacao;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;

class AjustesSalariaisController extends Natureza51Ctrl
{
     public function __construct(){
        $this->repository=new RepoAjustesSalariais();
        parent::__construct();
    }

    public function listar(){
        $tb_cargo_area = new CargosArea();
        $tb_cargo = new Cargo();
        $tb_lotacao = new Lotacao();

        $data = $tb_cargo_area->join($tb_cargo->getTable(),$tb_cargo_area->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))
                                ->join($tb_lotacao->getTable(),$tb_cargo_area->getColunaAlias('lotacao_id'), $tb_lotacao->getColunaAlias('id'))
                                ->select(  $tb_cargo_area->getColunaAlias('id'),   
                                            DB::raw("{$tb_lotacao->getColunaAlias('id')} as lotacao_id"),                          
                                            DB::raw("CONCAT({$tb_lotacao->getColunaAlias('unid_lotac')}, ' - ', 
                                                {$tb_lotacao->getColunaAlias('des_unid_lotac')}) AS unid_lotac"),
                                            DB::raw("CONCAT({$tb_cargo->getColunaAlias('cod_cargo_basic')}, ' - ', 
                                                {$tb_cargo->getColunaAlias('des_cargo_basic')}) AS cargo")
                                     )
                                     ->orderBy($tb_lotacao->getColunaAlias('unid_lotac'))
                                     ->get();
         
        return new Response(json_encode($data) , 200);
    }

    public function listarCargosLotacaoSeleted($unid_lotac){
        
        $tb_cargo_area = new CargosArea();
        $tb_cargo = new Cargo();
        $tb_lotacao = new Lotacao();

        $data = $tb_cargo_area->join($tb_cargo->getTable(),$tb_cargo_area->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))
                                ->join($tb_lotacao->getTable(),$tb_cargo_area->getColunaAlias('lotacao_id'), $tb_lotacao->getColunaAlias('id'))
                                ->where($tb_lotacao->getColunaAlias('unid_lotac'), $unid_lotac)
                                ->select($tb_cargo->getColunaAlias('id'), $tb_cargo->getColunaAlias('cod_cargo_basic'), $tb_cargo->getColunaAlias('des_cargo_basic'))
                                     ->get();
         
        return new Response(json_encode($data) , 200);
    }

    public function insert(Request $request){
        $retorno=$this->getArrayRetornoDefault();
        $tb_cargo_area = new CargosArea();

        $data = $request->all();
        $id_lotacao = $this->getLotacaoID($data[1]['lotacao']); 

        if(is_null($id_lotacao)){
            $retorno['msg']='Selecione uma lotação. Erro: 31102192021';
            goto saida;
        }  

        $id_cargo = [];
        $data_insert = [];

        foreach($data[0]['cargos'] as $key => $value){
            $id_cargo[$key] = $value['id'];
        }

        foreach($id_cargo as $key => $value){
            $data_insert[$key]= [
                'cargo_id' => $value,
                'lotacao_id' => $id_lotacao
            ];
           
        }        
       
        $tb_cargo_area->where('lotacao_id', $id_lotacao)->delete();

        if(! $tb_cargo_area->insert($data_insert)){
            $retorno['msg']=$tb_cargo_area->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro: 31102192010';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);      

    }

    public function getLotacaoID($data){       
        $lotacao = explode(" - ", $data);

        return Lotacao::where('unid_lotac', $lotacao)->value('id');
    }

    public function getCargoID($data){        
        
        return Cargo::select('id')->whereIn('cod_cargo_basic', $data)->get();
    }
    
}