<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoEventos as RepoEventos;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Repositories\RepoHoraExtra;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class EventosController extends Natureza51Ctrl
{
    
   public function __construct(){
        $this->repository=new RepoEventos();
        parent::__construct();
    }
    public function listar(){
        return $this->getRepository()->listarEventos();
    }
    public function colunaEventosHE($orc_id){
        $tb_eventos = new Eventos();

        $hra_extra = new RepoHoraExtra();

        
        $hra = $hra_extra->getModelEntity()->select('evento_id')->where('orcamento_id',$orc_id)->get()->toArray();        
        $a = [];

        for ($i=0; $i <count($hra) ; $i++) { 
            $a[$i]=$hra[$i]['evento_id'];
        }

        $data = $tb_eventos->select('id', 'des_event', 'cdn_event')->whereIn('id',$a)
        ->get()->toArray();
        $dados = [];
        for($i=0;$i<count($data);$i++){
            $dados[$i]=array_merge($data[$i],array("description"=>$data[$i]['cdn_event'].' - '.$data[$i]['des_event']));
        }
        return new Response(json_encode($dados) , 200);
    }
    public function update(Request $request){
        $array=$request->all();
        $enviar=array('multiplica'=>$array['multiplica']);
        //dd("sxasx",$enviar);
        //$array_repo=array_merge($array,convertDecimalEn($enviar));
        return $this->getRepository()->update($array,$array['id']);//$array_repo
    }
    public function listarTipo($tipo_evento){
        $dados=$this->getRepository()->listarEventos();
        $i=0;
        $y=0;
        //dd($tipo_evento);
        $data=null;
        for($i=0;$i<count($dados);$i++){
            if($dados[$i]['tipo_evento_id']==$tipo_evento){
               $data[$y]=$dados[$i];
               $y=$y+1;
            }
        }
        return $data;
    }
}
