<?php

namespace App\Modules\Natureza51\Http\Controllers;

// use App\Modules\Natureza51\Repositories\RepoHeadcount as RepoHeadcount;
use App\Modules\Natureza51\Entities\OrcamLotCargoEvento;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\Turma; 
use App\Modules\Natureza51\Entities\OrcTurma; 
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;
use App\Modules\Natureza51\Entities\OrcDemissoesDetalhes;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcHeadcountContratacoes;
use App\Modules\Natureza51\Repositories\RepoOrcContratacoes as RepoOrcContratacoes;
use App\Modules\Natureza51\Http\Controllers\OrcamentoController;
use App\Modules\Natureza51\Entities\OrcCargo;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento as RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoHeadcount as RepoHeadcount;
use App\Support\TreeTable\AtmTreeTable;
use \App\Core\Traits\ErrorTrait;
use App\Modules\Natureza51\Entities\OrcLotacao;

class HeadcountController extends OrcamentoController
{
    private $colum_meses=['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado',
    'jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];

    private $meses_total_eventos=['t_event_jan','t_event_fev','t_event_mar','t_event_abr','t_event_mai',
                                    't_event_jun','t_event_jul','t_event_ago','t_event_set','t_event_out','t_event_nov','t_event_dez'];
    private $eventos_list=[34,35,36];

    public function __construct(){
            $this->repository=new RepoHeadcount();
            parent::__construct();
    }
        
    public function listarHeadcount($orc_id,$lotacao_id, $tipo_table){
        // dd('aaa');
        // $data = $this->listajson();
        // dd($orc_id,$lotacao_id); 
        // return new Response($data , 200);        
        $tb_orcamLot_cargo_headcount = new OrcamLotCargoHeadcount();        
        $tb_calc_orcamento = new CalcOrcamento();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tb_lotacao = new OrcLotacao();
        $tb_orc_cargo = new OrcCargo(); 
        
        $data = $tb_lotacao->join($tb_orcamLot_cargo_headcount->getTable(),
        $tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'), $tb_lotacao->getColunaAlias('id'))                            
                            ->join($tb_calc_orcamento->getTable(), $tb_orcamLot_cargo_headcount->getColunaAlias('id'), '=', 
                                DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and 
                                {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orcamLot_cargo_headcount->getTable()}'"))
                            ->join($tb_orc_cargo->getTable(),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
                            ->join($tb_cargo->getTable(),
                                $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))    
                            ->join($tb_centro_custo->getTable(),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id')) 
                            ->join($tb_turma->getTable(),
                                $tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id'), $tb_turma->getColunaAlias('id'))  
                            ->join($tb_turno->getTable(),
                                    $tb_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('id'))  
                                ->select(
                                    DB::raw($tb_calc_orcamento->getColunaAlias('id')),
                                    DB::raw($tb_orcamLot_cargo_headcount->getColunaAlias('id').' as id_princ'), 
                                    $tb_orcamLot_cargo_headcount->getColunaAlias('orc_id'), 
                                    $tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'),
                                    $tb_orc_cargo->getColunaAlias('cargo_id'), 
                                    $tb_cargo->getColunaAlias('cod_cargo_basic'), 
                                    $tb_cargo->getColunaAlias('des_cargo_basic'),
                                    $tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id'), 
                                    $tb_centro_custo->getColunaAlias('cod_ccusto'), 
                                    $tb_turma->getColunaAlias('cdn_turma_trab'), 
                                    $tb_turma->getColunaAlias('des_turma_trab'), 
                                    $tb_turno->getColunaAlias('des_turno_trab'),
                                    $tb_orcamLot_cargo_headcount->getColunaAlias('orc_turma_id'),

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jan_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_jan"),
                                    $tb_calc_orcamento->getColunaAlias('jan_orcado'),

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('fev_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_fev"),
                                    $tb_calc_orcamento->getColunaAlias('fev_orcado'), 

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mar_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_mar, 
                                    {$tb_calc_orcamento->getColunaAlias('mar_orcado')}"), 

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('abr_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_abr, 
                                    {$tb_calc_orcamento->getColunaAlias('abr_orcado')}"), 

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mai_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_mai, 
                                    {$tb_calc_orcamento->getColunaAlias('mai_orcado')}"), 

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jun_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_jun, 
                                    {$tb_calc_orcamento->getColunaAlias('jun_orcado')}"), 

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jul_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_jul, 
                                    {$tb_calc_orcamento->getColunaAlias('jul_orcado')}"), 

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('ago_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_ago, 
                                    {$tb_calc_orcamento->getColunaAlias('ago_orcado')}"), 

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('set_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_set, 
                                    {$tb_calc_orcamento->getColunaAlias('set_orcado')}"), 

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('out_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_out, 
                                    {$tb_calc_orcamento->getColunaAlias('out_orcado')}"),

                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('nov_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_nov, 
                                    {$tb_calc_orcamento->getColunaAlias('nov_orcado')}"), 
                                    
                                    DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('dez_orcado')}) OVER(partition by 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('ccusto_id')}, 
                                    {$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id')},
                                    {$tb_orc_cargo->getColunaAlias('cargo_id')}) t_headcount_dez, 
                                    {$tb_calc_orcamento->getColunaAlias('dez_orcado')}")
                                )
                                ->orderByRaw("{$tb_centro_custo->getColunaAlias('cod_ccusto')}, {$tb_cargo->getColunaAlias('cod_cargo_basic')}, 
                                                {$tb_turma->getColunaAlias('cdn_turma_trab')}")   
                                    ->where([
                                        [$tb_orcamLot_cargo_headcount->getColunaAlias('orc_id'),$orc_id],
                                        [$tb_orcamLot_cargo_headcount->getColunaAlias('lotacao_id'),$lotacao_id],
                                        [$tb_orcamLot_cargo_headcount->getColunaAlias('tipo_table'),$tipo_table],
                                    ])
                                    ->get()
                                    ->toArray();

                                    // dd("testeee",$data);
                                    //  dd("pivooooo",$this->pivo($data));
                                     return new Response(json_encode($this->montaTreetable($this->pivo($data))) , 200);
    } 

    public function listarHeadcountHE($orc_id,$lotacao_id, $tipo_table){
      
        // $data = $this->listajson();
        // return new Response($data , 200);
        // return ($this->getEventOfHour());
        $tb_orcam_lot_cargo_evento = new OrcamLotCargoEvento();
        // $tb_orcamLot_cargo_headcount = new OrcamLotCargoHeadcount();
        $tb_eventos = new Eventos();
        $tb_calc_orcamento = new CalcOrcamento();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tb_lotacao = new OrcLotacao();
        $tb_orc_cargo = new OrcCargo();
        $alias_calc_orcamento = 'coh';
        $tb_alias = $tb_calc_orcamento->getTable();       
        $tb_alias = $tb_alias . " AS {$alias_calc_orcamento}";
        
        $data = $tb_lotacao->join($tb_orcam_lot_cargo_evento->getTable(),
        $tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id'), $tb_lotacao->getColunaAlias('id'))
                            ->join($tb_eventos->getTable(),$tb_eventos->getColunaAlias('id'), $tb_orcam_lot_cargo_evento->getColunaAlias('evento_id'))
                            ->leftJoin($tb_calc_orcamento->getTable(), $tb_orcam_lot_cargo_evento->getColunaAlias('id'), '=',                            
                            DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and 
                            {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orcam_lot_cargo_evento->getTable()}'"))                           
                            ->join($tb_orc_cargo->getTable(),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
                            ->join($tb_cargo->getTable(),
                                $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))    
                            ->join($tb_centro_custo->getTable(),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id')) 
                            ->join($tb_turma->getTable(),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('orc_turma_id'), $tb_turma->getColunaAlias('id'))
                            ->join($tb_turno->getTable(),
                                $tb_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('id'))  
                            ->select(
                                $tb_orcam_lot_cargo_evento->getColunaAlias('id'),
                                DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} as calc_orc_id"),
                                DB::raw("{$tb_eventos->getColunaAlias('id')} as evento_id"),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('orc_id'),$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id'),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('evento_id'), $tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id'), 
                                $tb_cargo->getColunaAlias('cod_cargo_basic'), $tb_cargo->getColunaAlias('des_cargo_basic'),
                                $tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('cod_ccusto'),
                                $tb_turma->getColunaAlias('cdn_turma_trab'), 
                                $tb_orcam_lot_cargo_evento->getColunaAlias('orc_turma_id'),  
                                $tb_turno->getColunaAlias('des_turno_trab'),
                              
                                $tb_turma->getColunaAlias('des_turma_trab'), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jan_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_jan, 
                                {$tb_calc_orcamento->getColunaAlias('jan_orcado')}") ,
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('fev_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_fev, 
                                {$tb_calc_orcamento->getColunaAlias('fev_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mar_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')},  
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_mar, 
                                {$tb_calc_orcamento->getColunaAlias('mar_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('abr_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_abr, 
                                {$tb_calc_orcamento->getColunaAlias('abr_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('mai_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_mai, 
                                {$tb_calc_orcamento->getColunaAlias('mai_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jun_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_jun, 
                                {$tb_calc_orcamento->getColunaAlias('jun_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('jul_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_jul, 
                                {$tb_calc_orcamento->getColunaAlias('jul_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('ago_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_ago, 
                                {$tb_calc_orcamento->getColunaAlias('ago_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('set_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_set, 
                                {$tb_calc_orcamento->getColunaAlias('set_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('out_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_out, 
                                {$tb_calc_orcamento->getColunaAlias('out_orcado')}"),
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('nov_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_nov, 
                                {$tb_calc_orcamento->getColunaAlias('nov_orcado')}"), 
                                DB::raw("SUM({$tb_calc_orcamento->getColunaAlias('dez_orcado')}) OVER(partition by {$tb_orcam_lot_cargo_evento->getColunaAlias('ccusto_id')}, 
                                {$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id')},{$tb_orcam_lot_cargo_evento->getColunaAlias('orc_cargo_id')}, 
                                {$tb_eventos->getColunaAlias('id')}) t_event_dez, 
                                {$tb_calc_orcamento->getColunaAlias('dez_orcado')}")
                            )
                            ->orderByRaw("{$tb_centro_custo->getColunaAlias('cod_ccusto')}, {$tb_cargo->getColunaAlias('cod_cargo_basic')}, {$tb_turma->getColunaAlias('cdn_turma_trab')}")
                            ->where(
                                [
                                    [$tb_orcam_lot_cargo_evento->getColunaAlias('orc_id'),$orc_id],
                                    [$tb_orcam_lot_cargo_evento->getColunaAlias('lotacao_id'),$lotacao_id],
                                    [$tb_orcam_lot_cargo_evento->getColunaAlias('tipo_table'),$tipo_table]                                    
                                ]
                            )
                            ->get()
                            ->toArray();
                            // dd($data);
                                    // dd("testeee",$data);
                                    //  dd("testeee",$this->ex($this->pivo($data)));
        return new Response(json_encode($this->montaTreetableHE($this->pivoHE($data))) , 200);
    }

    public function listarDemissoes($orc_id,$lotacao_id,$ccusto_id, $tipo_table){
        // dd('sikdnsinsidns',$orc_id,$lotacao_id,$ccusto_id);
               
        $tb_orc_headcount_demissoes = new OrcHeadcountDemissoes();
        $tb_funcionario = new Funcionario();
        $tb_turma = new OrcTurma();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_orc_cargo = new OrcCargo();
        $tb_calc_orcamento = new CalcOrcamento();
        
        $data = $tb_orc_headcount_demissoes->leftJoin($tb_funcionario->getTable(),
                                $tb_funcionario->getColunaAlias('id'), $tb_orc_headcount_demissoes->getColunaAlias('func_id')) 
                            ->leftJoin($tb_turma->getTable(),
                                $tb_orc_headcount_demissoes->getColunaAlias('orc_turma_id'), $tb_turma->getColunaAlias('id')) 
                            ->leftJoin($tb_orc_cargo->getTable(),
                                $tb_orc_headcount_demissoes->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
                            ->leftJoin($tb_cargo->getTable(),
                                $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))    
                            ->leftJoin($tb_centro_custo->getTable(),
                                $tb_orc_headcount_demissoes->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id')) 
                            ->leftJoin($tb_calc_orcamento->getTable(), $tb_orc_headcount_demissoes->getColunaAlias('id'), '=',                            
                                DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} 
                                and {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orc_headcount_demissoes->getTable()}' 
                                and {$tb_orc_headcount_demissoes->getColunaAlias('tipo')} = 1
                            "))
                            ->select(                                
                                DB::raw("{$tb_orc_headcount_demissoes->getColunaAlias('id')} as headcount_demissoes_id"),
                                    $tb_calc_orcamento->getColunaAlias('origem_id'),
                                    $tb_orc_headcount_demissoes->getColunaAlias('orcamento_id'),
                                    $tb_centro_custo->getColunaAlias('cod_ccusto'),
                                    $tb_cargo->getColunaAlias('cod_cargo_basic'),
                                    $tb_turma->getColunaAlias('cdn_turma_trab'), 
                                    $tb_orc_headcount_demissoes->getColunaAlias('ccusto_id'),                                    
                                    $tb_orc_cargo->getColunaAlias('cargo_id'),                                    
                                    $tb_cargo->getColunaAlias('des_cargo_basic'),
                                    $tb_orc_headcount_demissoes->getColunaAlias('lotacao_id'),
                                    $tb_orc_headcount_demissoes->getColunaAlias('orc_turma_id'),
                                    $tb_orc_headcount_demissoes->getColunaAlias('func_id'), 
                                    $tb_orc_headcount_demissoes->getColunaAlias('orc_cargo_id'), 
                                    $tb_orc_headcount_demissoes->getColunaAlias('qtde_pessoas'), 
                                    $tb_orc_headcount_demissoes->getColunaAlias('tempo_casa'),                                    
                                    $tb_funcionario->getColunaAlias('cdn_funcionario'), 
                                    $tb_funcionario->getColunaAlias('nome_funcionario'), 
                                    $tb_orc_headcount_demissoes->getColunaAlias('tipo'),                                   
                                    $tb_orc_headcount_demissoes->getColunaAlias('mes'),
                                    $tb_calc_orcamento->getColunaAlias('jan_orcado'),
                                    $tb_calc_orcamento->getColunaAlias('fev_orcado'),
                                    $tb_calc_orcamento->getColunaAlias('mar_orcado'),
                                    $tb_calc_orcamento->getColunaAlias('abr_orcado'),
                                    $tb_calc_orcamento->getColunaAlias('mai_orcado'),
                                    $tb_calc_orcamento->getColunaAlias('jun_orcado'),
                                    $tb_calc_orcamento->getColunaAlias('jul_orcado'),
                                    $tb_calc_orcamento->getColunaAlias('ago_orcado'),
                                    $tb_calc_orcamento->getColunaAlias('set_orcado'),
                                    $tb_calc_orcamento->getColunaAlias('out_orcado'),
                                    $tb_calc_orcamento->getColunaAlias('nov_orcado'),
                                    $tb_calc_orcamento->getColunaAlias('dez_orcado')

                                ) 
                                ->where([
                                    [ $tb_orc_headcount_demissoes->getColunaAlias('orcamento_id'),$orc_id],
                                    [$tb_orc_headcount_demissoes->getColunaAlias('lotacao_id'),$lotacao_id],
                                    [$tb_orc_headcount_demissoes->getColunaAlias('tipo_table'),$tipo_table]
                                ])
                                ->get()
                                ->toArray();
                                    // dd("testeee",$data);
                                    //  dd("pivooooo",$this->pivoDemissoes($data));     
                                     return new Response(json_encode($this->montaTreetableDemissoes($this->pivoDemissoes($data))) , 200);
    }

    public function listarContratacoes($orcamento_id , $lotacao_id , $ccusto_id, $tipo_table){

        
        // $data = $this->listajson();
        // return new Response($data , 200);        
        $tb_orcam_headcount_contratacoes = new OrcHeadcountContratacoes();        
        $tb_calc_orcamento = new CalcOrcamento();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_turma = new OrcTurma();
        $tb_turno = new Turno();
        $tb_lotacao = new OrcLotacao();
        $tb_orc_cargo = new OrcCargo();
        
        $query = $tb_lotacao->join($tb_orcam_headcount_contratacoes->getTable(),
        $tb_orcam_headcount_contratacoes->getColunaAlias('lotacao_id'), $tb_lotacao->getColunaAlias('id'))                            
                            ->leftJoin($tb_calc_orcamento->getTable(), $tb_orcam_headcount_contratacoes->getColunaAlias('id'), '=', 
                                DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and 
                                {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orcam_headcount_contratacoes->getTable()}'"))
                            ->join($tb_orc_cargo->getTable(),
                                $tb_orcam_headcount_contratacoes->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
                            ->join($tb_cargo->getTable(),
                                $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))    
                            ->join($tb_centro_custo->getTable(),
                                $tb_orcam_headcount_contratacoes->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id')) 
                            ->join($tb_turma->getTable(),
                                $tb_orcam_headcount_contratacoes->getColunaAlias('orc_turma_id'), $tb_turma->getColunaAlias('id'))  
                            ->join($tb_turno->getTable(),
                                $tb_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('id'))  
                            ->select(
                                $tb_calc_orcamento->getColunaAlias('id'),
                                $tb_orcam_headcount_contratacoes->getColunaAlias('orcamento_id'), $tb_orcam_headcount_contratacoes->getColunaAlias('lotacao_id'),
                                $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('cod_cargo_basic'), 
                                $tb_cargo->getColunaAlias('des_cargo_basic'),$tb_orcam_headcount_contratacoes->getColunaAlias('ccusto_id'), 
                                $tb_centro_custo->getColunaAlias('cod_ccusto'), $tb_turma->getColunaAlias('cdn_turma_trab'), 
                                
                                $tb_calc_orcamento->getColunaAlias('jan_orcado'),                                    
                                $tb_calc_orcamento->getColunaAlias('fev_orcado'), 
                                $tb_calc_orcamento->getColunaAlias('mar_orcado'),                                    
                                $tb_calc_orcamento->getColunaAlias('abr_orcado'),                                    
                                $tb_calc_orcamento->getColunaAlias('mai_orcado'), 
                                $tb_calc_orcamento->getColunaAlias('jun_orcado'),                                    
                                $tb_calc_orcamento->getColunaAlias('jul_orcado'), 
                                $tb_calc_orcamento->getColunaAlias('ago_orcado'), 
                                $tb_calc_orcamento->getColunaAlias('set_orcado'),                                   
                                $tb_calc_orcamento->getColunaAlias('out_orcado'),                                   
                                $tb_calc_orcamento->getColunaAlias('nov_orcado'), 
                                $tb_calc_orcamento->getColunaAlias('dez_orcado')
                            )
                            ->orderByRaw("{$tb_centro_custo->getColunaAlias('cod_ccusto')}, {$tb_cargo->getColunaAlias('cod_cargo_basic')}, 
                                            {$tb_turma->getColunaAlias('cdn_turma_trab')}");

    
        if(!is_null($orcamento_id)){
            $query->where($tb_orcam_headcount_contratacoes->getTable().'.orcamento_id', $orcamento_id);
        }

        if(!is_null($lotacao_id)){
            $query->where($tb_orcam_headcount_contratacoes->getTable().'.lotacao_id', $lotacao_id);
        }

        if(!is_null($ccusto_id)){
            $query->where($tb_orcam_headcount_contratacoes->getTable().'.ccusto_id', $ccusto_id);
        }

        if(!is_null($tipo_table)){
            $query->where($tb_orcam_headcount_contratacoes->getColunaAlias('tipo_table'), $tipo_table);
        }

        $data = $query->get()
        ->toArray();
                                    // dd("bancvo",($data));
                                    //  dd("pivooooo",$this->montaTreetableContratacoes($this->pivoContratacoes($data)));
        return new Response(json_encode($this->montaTreetableContratacoes($this->pivoContratacoes($data))) , 200);
    }

    public function pivo($dados){
        $meses_orcado=$this->getColumMeses();        
        // $eventos_meses = [13,14,15,16];
        $retorno=[];
        $primary_key=['ccusto_id','cargo_id','orc_turma_id', 'lotacao_id'];
       
        $merge_meses_evento=[];
        $meses_orcados_clear=[];        
        
        $dados_rest = [];
        foreach($dados as $key => $value){
            
            $value=(array)$value;
            $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
            $ja_foi=array_keys($retorno);
            
            if(in_array($keys_values, $ja_foi)===false){                
                $aux=Arr::except($value,$meses_orcado);   
                $retorno[$keys_values]=$aux;

            }
            foreach($meses_orcado as $j=>$w){                     
                $retorno[$keys_values][$w]=$value[$w];
            }
        }
        // dd("pivooo", $retorno);
        return $retorno;
    }

    public function pivoContratacoes($dados){
        $meses_orcado=$this->getColumMeses();        
        // $eventos_meses = [13,14,15,16];
        $retorno=[];
        $primary_key=['ccusto_id','cargo_id','orc_turma_id', 'lotacao_id'];
       
        $merge_meses_evento=[];
        $meses_orcados_clear=[];        
        
        $dados_rest = [];
        foreach($dados as $key => $value){
            
            $value=(array)$value;
            $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
            $ja_foi=array_keys($retorno);
            
            if(in_array($keys_values, $ja_foi)===false){                
                $aux=Arr::except($value,$meses_orcado);   
                $retorno[$keys_values]=$aux;

            }
            foreach($meses_orcado as $j=>$w){                     
                $retorno[$keys_values][$w]=$value[$w];
            }
        }
        return $retorno;
    }

    function getIdByTIpo($dados){
       return $dados['headcount_demissoes_id'];
        
    }

    public function pivoDemissoes($dados){
        // dd("pivooo",$dados);
        $pivot_meses=$this->pivotColumns();
        $pivot_meses = $pivot_meses->mes_abreviado; 
        $retorno=[];
        // $primary_key=['cod_ccusto','cod_cargo_basic','cdn_turma_trab'];
        $primary_key=['ccusto_id','cargo_id','orc_turma_id', 'lotacao_id'];
        $except=['funcionario_id', 'qtde_pessoas', 'tempo_casa', 'cdn_funcionario', 'mes', 'cdn_funcionario', 'nome_funcionario', 'tipo'];        
     
        $merge_meses_evento=[];
        $meses_orcados_clear=[];        
        
        $dados_rest = [];
        $meses = [];
        $i=0;
        foreach($dados as $key => $value){
            // dd("tipo 1",  $retorno[$keys_values][$w.'_orcado']);
             $value=(array)$value;
             $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
             $ja_foi=array_keys($retorno);
             
             if(in_array($keys_values, $ja_foi)===false){ 
                              
                $aux=Arr::except($value,$except);   
                $retorno[$keys_values]=$aux;

             }
            
            foreach($pivot_meses as $j=>$w){                            
                
                if($value['tipo'] == '1'){
                    if(is_array($retorno[$keys_values][$w.'_orcado'])==false){
                        $retorno[$keys_values][$w.'_orcado']=[];
                    }   
                    if($value[$w.'_orcado'] == 0){
                        $value[$w.'_orcado'] = null;
                    }
                    $retorno[$keys_values][$w.'_orcado'][]= ['value'=>intval($value[$w.'_orcado']), 'tipo'=>$value['tipo'], 'id'=>$this->getIdByTIpo($value), 'mes'=>$w.'_orcado'];
                  
                    continue;
                }
              

                if(($value['mes']-1) == $j){                      

                    if($value['tipo'] == 2){
                        $retorno[$keys_values][$w.'_orcado'][]= ['value'=>$value['nome_funcionario'], 'tipo'=>$value['tipo'], 'id'=>$this->getIdByTIpo($value), 'mes'=>$w.'_orcado'];
                        continue;
                    }

                    if($value['tipo'] == 3){
                        $retorno[$keys_values][$w.'_orcado'][]= ['value'=>"Qtd. Pessoas: ".$value['qtde_pessoas'] ." - Tempo Casa: ". $value['tempo_casa'], 'tipo'=>$value['tipo'], 'id'=>$this->getIdByTIpo($value), 'mes'=>$w.'_orcado'];
                        continue;
                    }
                    
                    // if($value['nome_funcionario'] == 0 
                    //     && $value['qtde_pessoas'] > 0 && $value['tempo_casa'] > 0 ){

                    //     $retorno[$keys_values][$w.'_orcado'][]= ['value'=>$value['qtde_pessoas'] ."-". $value['tempo_casa'], 'tipo'=>$value['tipo'], 'id'=>$this->getIdByTIpo($value)];
                    // }else{                        
                    //     $retorno[$keys_values][$w.'_orcado'][]= $value['nome_funcionario'];// array_merge($retorno[$keys_values],$meses);                                                                         
                    // }
                    
                                       
                }
                 
            }
            
            
        }        
        
        // dd("021220191714",$retorno);
        return $retorno;
    }

    public function updated(Request $request,$tipo_table){  
        DB::enableQueryLog();
        // dd($tipo_table);
        $repo_calc_orcamento=new RepoCalcOrcamento();
        $retorno=$this->getArrayRetornoDefault();
        // $this->getRepository()->clearError();

        $form_data = $request->all();        
        // dd("headcount", $form_data);
        if($form_data['tb'] == "headcount"){
            $retorno = $this->getRepository()->updateHeadcount($form_data,$tipo_table);
            goto saida;
        }   
        if($form_data['tb'] == "contratacoes"){
            $this->setRepository(new RepoOrcContratacoes);
            $retorno = $this->getRepository()->updateContratacoes($form_data);
            goto saida;   
        }
        
        if($form_data['tb'] == "demissoes"){
            $tb_orc_headcount_demissoes = new OrcHeadcountDemissoes();
            $tb_calc_orcamento = new CalcOrcamento();
           
            $where = [
                'origem_id' => $form_data['demissoes_id'],
                'tbl_origem' => $tb_orc_headcount_demissoes->getTable()
            ];
                        
            if($form_data['tipo_demissoes'] == 1){                
               
                if(! $tb_calc_orcamento->where($where)
                ->update([$form_data['mes_orcado'] => null])){  
                    $retorno['msg'] = $this->getErrosFlatted();
                    $retorno['submsg']='Falha ao atualizar registro. Erro: 051220192050';
                    goto saida;               
                }               
            }else{
                
                if(! $tb_orc_headcount_demissoes->where('id', '=', $form_data['demissoes_id'])->delete()){  
                    $retorno['msg'] = $this->getErrosFlatted();
                    $retorno['submsg']='Falha ao atualizar do registro. Erro: 051220192051';
                    goto saida;               
                }               
            }         
                    
        } 
         
        if($form_data['tb'] == "horaExtra"){
            // dd('aaaaaaaaaaaaa',$form_data);
            $data = $this->dataUpdateHoraExtra($form_data);
            dd("asdfasdfasdfasdfasdf", $data);
            foreach($data['result_calc'] as $val){
                dd($val);
                    if(($event_id=array_search($val->origem_id, $data['combine']))===false){
                    continue;
                    }
            // dd('sssssssssssssss');
            if(! $val->update($data['eventos_r'][$event_id])){
                    $retorno['msg']=$val->getErrosFlatted();
                    $retorno['submsg']='Falha ao fazer update do registro. Erro: 181120191158';
                    goto saida;
                }         
            }  
        }        
        // dd($val); 
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        saida:       
        
        return $this->retornoJsonDefault($retorno); 
    } 
    
    // public function getUpdate($data, $id){  
    //     $retorno=$this->getArrayRetornoDefault();
    //     $this->clearError();
    //     $repo_calc_orcamento=new RepoCalcOrcamento();  
       
    //     if(! $repo_calc_orcamento->update($data, $id)){  
    //             $this->setError($repo_calc_orcamento->getErrosFlatted());                
    //             return false;               
    //         }
            
    //     return true;       
    // }

    public function dataUpdateHoraExtra($form_data){
   
        $tb_orcam_lot_cargo_evento = new OrcamLotCargoEvento();
        $model_tbl_calc_orcamento=new CalcOrcamento();
        
        $array_orcamento=['cod_ccusto','cod_cargo_basic', 'des_cargo_basic', 'atual', 'turno', 'turma', 'tb', 'id', 'orc_turma_id', 'orc_id'];
        $meses=['jan', 'fev', 'mar', 'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez'];
        $filtered = Arr::except($form_data, array_merge($array_orcamento,$meses, ['_token'] ));
        $moth_keys=[];
        $evento_keys=[];
        $mes_atual="";
        $evento_atual=0;
        $meses_r=[];
        $eventos_r=[];
        $orc_turma_id=$form_data['orc_turma_id'];
        $orc_id=$form_data['orc_id'];
        foreach($filtered as $chave=>$valor){
            $mes_evento_id=explode('-', $chave);
            $mes_atual=$mes_evento_id[0]."_orcado"; 
            // dd('nem qlq outra criatura',$mes_evento_id);
            // $evento_atual=$mes_evento_id[1]; 
            
            if(!in_array($evento_atual, $evento_keys)){
                $evento_keys[]=$evento_atual;
                $eventos_r[$evento_atual]=[];
            }

            $eventos_r[$evento_atual][$mes_atual]=$valor;
        }
        
        $resultado=$tb_orcam_lot_cargo_evento
        ->where('orc_id','=',$orc_id)
        ->where('orc_turma_id','=', $orc_turma_id) 
            ->whereIn('evento_id',array_keys($eventos_r))
            ->get()->toArray();
        
        $combine=array_combine(array_column($resultado, 'evento_id'), array_column($resultado, 'id'));
        
        $result_calc=$model_tbl_calc_orcamento
                    ->where('tbl_origem', '=', $tb_orcam_lot_cargo_evento->getTable())
                    ->whereIn('origem_id', $combine)
                    ->get();

        $mergeResult = [];
        $mergeResult['combine'] = $combine;
        $mergeResult['result_calc']= $result_calc;
        $mergeResult['eventos_r'] = $eventos_r;
        //  dd("combine", $mergeResult);           
        return $mergeResult;
    }

    public function dataUpdateHeadcount($data){
        $array_orcamento=['cod_ccusto','cod_cargo_basic', 'des_cargo_basic', 'atual', 'turno', 'turma', 'id' ,'tb'];
        $meses=['jan', 'fev', 'mar', 'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez'];
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
        $mes_atual="";
        $meses_headcount=[];
        
        foreach($filtered as $chave=>$valor){            
            $mes_atual=$chave."_orcado";                 
            $meses_headcount[$mes_atual]=$valor;   
        }

        return $meses_headcount;
    }

    public function montaTreetable($data){
        
        $pivot_colunas=$this->pivotColumns();
        $col_meses=$pivot_colunas->merged;
        $col_set_meses=[];
        $col_meses_parent=[];
        // $row_data: Valores da linha atual
        // * $value: valor da coluna atual ou um valor informado pelo usuario, 
        // * matrix: matriz com todas as linhas(Nao processadas ainda)
        foreach($col_meses as $j=>$mes){
            $col_set_meses[]= ["field_out"=>$j,"from"=>$j, "render_value"=>null,];
            $col_meses_parent[]=["field_out"=>$j,  "from"=>'t_event-'.$j, 
            "field_out_render_func"=>function($row_data,$value, $matrix){

            }];
        }
        
        $column_fixeds=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"atual", "render_value"=>function(){ return "266";},],
            ["field_out"=>"turno", "render_value"=>function(){ return "-";},],
            ["field_out"=>"turma", "render_value"=>function(){ return "-";},],
            ["field_out"=>"jan", "from"=>"t_headcount_jan", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"fev", "from"=>"t_headcount_fev", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"mar", "from"=>"t_headcount_mar","render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"abr", "from"=>"t_headcount_abr", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"mai", "from"=>"t_headcount_mai", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"jun", "from"=>"t_headcount_jun","render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"jul", "from"=>"t_headcount_jul", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"ago", "from"=>"t_headcount_ago", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"set", "from"=>"t_headcount_set", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"out", "from"=>"t_headcount_out", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"nov", "from"=>"t_headcount_nov", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"dez", "from"=>"t_headcount_dez","render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,]
            
        ];

        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "render_value"=>function(){ return "";},],
            ["field_out"=>"cod_cargo_basic","render_value"=>function(){ return "";},],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "render_value"=>function(){ return "";},],
            ["field_out"=>"atual", "render_value"=>function(){ return "";},],
            ["field_out"=>"turno", "from"=>"des_turno_trab", "render_value"=>null,],
            ["field_out"=>"turma", "from"=>"des_turma_trab", "render_value"=>null,],
            ["field_out"=>"jan", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"fev", "from"=>"fev_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"mar", "from"=>"mar_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"abr", "from"=>"abr_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"mai", "from"=>"mai_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"jun", "from"=>"jun_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"jul", "from"=>"jul_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"ago", "from"=>"ago_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"set", "from"=>"set_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"out", "from"=>"out_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"nov", "from"=>"nov_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"dez", "from"=>"dez_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,]
        ];

        // $columns_base=array_merge($column_fixeds, $col_meses_parent); 
        // $columns_children=array_merge($column_fixeds_children, $col_set_meses); 
        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
            "keys"=>['ccusto_id', 'cargo_id', 'lotacao_id'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children"=>["columns"=>$columns_children,
                    "keys"=>['ccusto_id', 'cargo_id','orc_turma_id', 'lotacao_id'],
                    "filter_data"=>['cod_ccusto'=>function($value){
                        return !is_null($value);
                    }],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result=($value['ccusto_id']== $parent_data['ccusto_id'] && 
                            $value['cargo_id']== $parent_data['cargo_id']&&
                            // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                            $value['lotacao_id']== $parent_data['lotacao_id']);
                        
                            return $result;
                    },
                    // "children"=>["is_recursive"=>true]

                ]
            ];
                 
        $controller=new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
        
    }

    public function montaTreetableContratacoes($data){
        
        $pivot_colunas=$this->pivotColumns();
        $col_meses=$pivot_colunas->merged;
        $col_set_meses=[];
        $col_meses_parent=[];
        // $row_data: Valores da linha atual
        // * $value: valor da coluna atual ou um valor informado pelo usuario, 
        // * matrix: matriz com todas as linhas(Nao processadas ainda)
        foreach($col_meses as $j=>$mes){
            $col_set_meses[]= ["field_out"=>$j,"from"=>$j, "render_value"=>null,];
            $col_meses_parent[]=["field_out"=>$j,  "from"=>'t_event-'.$j, 
            "field_out_render_func"=>function($row_data,$value, $matrix){

            }];
        }
        
        $column_fixeds=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"atual", "render_value"=>function(){ return "266";},],
            ["field_out"=>"turno", "render_value"=>function(){ return "-";},],
            ["field_out"=>"turma", "render_value"=>function(){ return "-";},],
            ["field_out"=>"jan", "from"=>"t_headcount_jan", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"fev", "from"=>"t_headcount_fev", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"mar", "from"=>"t_headcount_mar","render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"abr", "from"=>"t_headcount_abr", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"mai", "from"=>"t_headcount_mai", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"jun", "from"=>"t_headcount_jun","render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"jul", "from"=>"t_headcount_jul", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"ago", "from"=>"t_headcount_ago", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"set", "from"=>"t_headcount_set", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"out", "from"=>"t_headcount_out", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"nov", "from"=>"t_headcount_nov", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"dez", "from"=>"t_headcount_dez","render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,]
            
        ];

        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"id_princ", "from"=>"id_princ", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "render_value"=>function(){ return "";},],
            ["field_out"=>"cod_cargo_basic","render_value"=>function(){ return "";},],
            ["field_out"=>"des_cargo_basic", "render_value"=>function(){ return "";},],
            ["field_out"=>"atual", "render_value"=>function(){ return "";},],
            ["field_out"=>"turno", "from"=>"des_turno_trab", "render_value"=>null,],
            ["field_out"=>"turma", "from"=>"des_turma_trab", "render_value"=>null,],
            ["field_out"=>"jan", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"fev", "from"=>"fev_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"mar", "from"=>"mar_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"abr", "from"=>"abr_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"mai", "from"=>"mai_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"jun", "from"=>"jun_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"jul", "from"=>"jul_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"ago", "from"=>"ago_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"set", "from"=>"set_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"out", "from"=>"out_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"nov", "from"=>"nov_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"dez", "from"=>"dez_orcado", "render_value"=>function($row_data, $value){
                return intval($value);
            },],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,]
        ];

        // $columns_base=array_merge($column_fixeds, $col_meses_parent); 
        // $columns_children=array_merge($column_fixeds_children, $col_set_meses); 
        $columns_base=$column_fixeds; 
        $columns_children=$column_fixeds_children; 
        
        $settings=["columns"=>$columns_base,
            "keys"=>['ccusto_id', 'cargo_id', 'lotacao_id'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children"=>["columns"=>$columns_children,
                    "keys"=>['ccusto_id', 'cargo_id','orc_turma_id', 'lotacao_id'],
                    "filter_data"=>['cod_ccusto'=>function($value){
                        return !is_null($value);
                    }],
                    'parent_filter'=> function($value, $parent_data){ 
                            $result=($value['ccusto_id']== $parent_data['ccusto_id'] && 
                            $value['cargo_id']== $parent_data['cargo_id']&&
                            // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                            $value['lotacao_id']== $parent_data['lotacao_id']);
                        
                            return $result;
                    },
                    // "children"=>["is_recursive"=>true]

                ]
            ];
                 
        $controller=new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
        
    }
    
    public function mergeMesAcaoBTN($value){
        return $value;
        $mes_value = "";
                    if(!is_array($value)){
                      return   $value;
                    }
                   
                    foreach($value as $key => $data){
                        
                        if(is_null($data)){
                            continue;
                        }                           
                       
                         $mes_value .= '<button type="button" class="btnexcluidd" >'. $data['value'].'</button><br><br>';  
                        // $mes_value .= '<button pButton type="button" class="ui-button-info" (click)="excluirROWWW('.$data['id'].','.$data['tipo'].') "value="'. $data['value'].'"></button>.<br>';                       
                        
                    }
                  return $mes_value;
    }

    public function montaTreetableDemissoes($data){
          
        $pivot_colunas=$this->pivotColumns();
        $col_meses=$pivot_colunas->merged;
        $col_set_meses=[];
        $col_meses_parent=[];
        // $row_data: Valores da linha atual
        // * $value: valor da coluna atual ou um valor informado pelo usuario, 
        // * matrix: matriz com todas as linhas(Nao processadas ainda)
        // foreach($col_meses as $j=>$mes){
        //     $col_set_meses[]= ["field_out"=>$j,"from"=>$j, "render_value"=>null,];
        //     $col_meses_parent[]=["field_out"=>$j,  "from"=>'t_event-'.$j, 
        //     "field_out_render_func"=>function($row_data,$value, $matrix){

        //     }];
        // }        
            
            $column_fixeds=[                 
                ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
                ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
                ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
                ["field_out"=>"atual", "render_value"=>function(){ return "266";},],
                ["field_out"=>"turno", "render_value"=>function(){ return "-";},],
                ["field_out"=>"turma", "render_value"=>function(){ return "-";},],
                ["field_out"=>"jan_orcado", "render_value"=>function(){ return "";},],
                ["field_out"=>"fev_orcado", "render_value"=>function(){ return "";},],
                ["field_out"=>"mar_orcado", "render_value"=>function(){ return "";},],
                ["field_out"=>"abr_orcado", "render_value"=>function(){ return "";},],
                ["field_out"=>"mai_orcado", "render_value"=>function(){ return "";},],
                ["field_out"=>"jun_orcado", "render_value"=>function(){ return "";},],
                ["field_out"=>"jul_orcado", "render_value"=>function(){ return "";},],
                ["field_out"=>"ago_orcado", "render_value"=>function(){ return "";},],
                ["field_out"=>"set_orcado", "render_value"=>function(){ return "";},],
                ["field_out"=>"out_orcado", "render_value"=>function(){ return "";},],
                ["field_out"=>"nov_orcado", "render_value"=>function(){ return "";},],
                ["field_out"=>"dez_orcado", "render_value"=>function(){ return "";},],
                ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
                ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
                ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
                ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,]
                
                
            ];
    
            $column_fixeds_children=[                 
                ["field_out"=>"cod_ccusto", "render_value"=>function(){ return "";},],
                ["field_out"=>"cod_cargo_basic","render_value"=>function(){ return "";},],
                ["field_out"=>"des_cargo_basic", "render_value"=>function(){ return "";},],
                ["field_out"=>"atual", "render_value"=>function(){ return "";},],
                ["field_out"=>"turno", "from"=>"des_turno_trab", "render_value"=>null,],
                ["field_out"=>"turma", "from"=>"des_turma_trab", "render_value"=>null,],
                ["field_out"=>"jan_orcado", "render_value"=>function($row_data, $value, $matrix){ 
                    return $this->mergeMesAcaoBTN($value);                     
                },],
                ["field_out"=>"fev_orcado", "from"=>"fev_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"mar_orcado", "from"=>"mar_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"abr_orcado", "from"=>"abr_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"mai_orcado", "from"=>"mai_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"jun_orcado", "from"=>"jun_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"jul_orcado", "from"=>"jul_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"ago_orcado", "from"=>"ago_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"set_orcado", "from"=>"set_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"out_orcado", "from"=>"out_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"nov_orcado", "from"=>"nov_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"dez_orcado", "from"=>"dez_orcado", "render_value"=>function($row_data, $value, $matrix){  
                    return $this->mergeMesAcaoBTN($value);
                },],
                ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
                ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
                ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
                ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,]
                ];
    
            // $columns_base=array_merge($column_fixeds, $col_meses_parent); 
            // $columns_children=array_merge($column_fixeds_children, $col_set_meses); 
            $columns_base=$column_fixeds; 
            $columns_children=$column_fixeds_children; 
            //  dd($columns_base);
            $settings=["columns"=>$columns_base,
                // "keys"=>['cod_ccusto', 'cod_cargo_basic'],
                "keys"=>['ccusto_id', 'cargo_id', 'lotacao_id'],
                // "filter_data"=>['parent_id'=>function($value){
                //         return is_null($value);
                //     }    
                // ],            
                "children"=>["columns"=>$columns_children,
                        // "keys"=>['cod_ccusto', 'cod_cargo_basic','cdn_turma_trab','headcount_demissoes_id'],
                        
                        "keys"=>['ccusto_id', 'cargo_id','orc_turma_id', 'lotacao_id'],
                        "filter_data"=>['cod_ccusto'=>function($value){
                            return !is_null($value);
                        }],
                        'parent_filter'=> function($value, $parent_data){ 
                                $result=($value['ccusto_id']== $parent_data['ccusto_id'] && 
                                $value['cargo_id']== $parent_data['cargo_id']&&
                                // $value['orc_turma_id']== $parent_data['orc_turma_id'] &&
                                $value['lotacao_id']== $parent_data['lotacao_id']);
                            
                                return $result;
                        },
                    ]
                ];
               
            $controller=new AtmTreeTable($settings, $data);
            // dd("treetable", ['data'=>$controller->render()]);
            return ['data'=>$controller->render()]; 
            
        $controller=new AtmTreeTable($settings, $data);
        return ['data'=>$controller->render()]; 
        
    }    
    
    private function setEventosList($value){
        $this->eventos_list=$value;
        return $this;
    }

    function getColumMesesTotal(){ return $this->meses_total_eventos; }

    function getColumMeses(){ return $this->colum_meses; }
    function getEventosList(){ return /*[34,35,36];*/ $this->getEventOfHour(); }
    function pivotColumns(){
        $meses_orcado =$this->getColumMeses() ;
        $eventos_meses = $this->getEventosList();
        $retorno=[];
        
        $merge_meses_evento=[];
        $meses_orcados_clear=[];
        foreach($meses_orcado as $key => $value){
            
            $var = explode("_",$value);
            $meses_orcados_clear[]=$var[0];

            foreach($eventos_meses as $key_ev =>$value_ev){
                $merge_meses_evento[$var[0]."-".$value_ev->id] = "";
            }
        }
        return  (object)['merged'=>$merge_meses_evento, 'mes_abreviado'=>$meses_orcados_clear];
    }

    public function pivoHE($dados){
       
        $retorno=[];
        $primary_key=['cod_ccusto','cod_cargo_basic','cdn_turma_trab'];
        $pivot_meses=$this->pivotColumns();
        $meses_orcado=$this->getColumMeses();
        $meses_total_eventos=$this->getColumMesesTotal();
        $merge_meses_evento=$pivot_meses->merged;
        $t_eventos=array_combine(array_map(function($current){
           return 't_event-'.$current;
        }, array_keys($merge_meses_evento)), $merge_meses_evento);
       
        $meses_orcados_clear=$pivot_meses->mes_abreviado;
        $dados_rest = [];
        foreach($dados as $key => $value){
            $value=(array)$value;
            $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
            $ja_foi=array_keys($retorno);
            if(in_array($keys_values, $ja_foi)===false){
                   $aux=Arr::except($value,array_merge($meses_orcado, $meses_total_eventos));
                   $retorno[$keys_values]=array_merge($aux,$merge_meses_evento, $t_eventos);                  

            }
            foreach($meses_orcado as $j=>$w){               
                $retorno[$keys_values][$meses_orcados_clear[$j]."-".$value['evento_id']]=$value[$w];
                $retorno[$keys_values]['t_event-'.$meses_orcados_clear[$j]."-".$value['evento_id']]=$value['t_event_'.$meses_orcados_clear[$j]];
            }
        }
  
        return $retorno;
    }  

    public function montaTreetableHE($data){      
        // dd("treeeeeeeee",$data);
        $pivot_colunas=$this->pivotColumns();
        $col_meses=$pivot_colunas->merged;
        $col_set_meses=[];
        $col_meses_parent=[];
         
        foreach($col_meses as $j=>$mes){
            $col_set_meses[]= ["field_out"=>$j,"from"=>$j, "render_value"=>function($row_data,$value){
                return intval($value);
            }]; 
            $col_meses_parent[]=["field_out"=>$j,  "from"=>'t_event-'.$j,"render_value"=>function($row_data,$value){
                return intval($value);
            }]; 
        }
        
        $column_fixeds=[ 
            // ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null,],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],

            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"calc_orc_id", "from"=>"calc_orc_id", "render_value"=>null,],
            ["field_out"=>"atual", "render_value"=>function(){ return "266";},],
            // ["field_out"=>"turno","from"=>"des_turno_trab", "render_value"=>null,],
            // ["field_out"=>"turma","from"=>"des_turma_trab", "render_value"=>function(){ return "-";},],
            ["field_out"=>"jan", "from"=>"t_headcount_jan", "render_value"=>null,],
            ["field_out"=>"fev", "from"=>"t_headcount_fev", "render_value"=>null,],
            ["field_out"=>"mar", "from"=>"t_headcount_mar", "render_value"=>null,],
            ["field_out"=>"abr", "from"=>"t_headcount_abr", "render_value"=>null,],
            ["field_out"=>"mai", "from"=>"t_headcount_mai", "render_value"=>null,],
            ["field_out"=>"jun", "from"=>"t_headcount_jun", "render_value"=>null,],
            ["field_out"=>"jul", "from"=>"t_headcount_jul", "render_value"=>null,],
            ["field_out"=>"ago", "from"=>"t_headcount_ago", "render_value"=>null,],
            ["field_out"=>"set", "from"=>"t_headcount_set", "render_value"=>null,],
            ["field_out"=>"out", "from"=>"t_headcount_out", "render_value"=>null,],
            ["field_out"=>"nov", "from"=>"t_headcount_nov", "render_value"=>null,],
            ["field_out"=>"dez", "from"=>"t_headcount_dez", "render_value"=>null,],
           
            
        ];

        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null,],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
            ["field_out"=>"calc_orc_id", "from"=>"calc_orc_id", "render_value"=>null,],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "render_value"=>function(){ return "";},],
            ["field_out"=>"atual", "render_value"=>function(){ return "266";},],
            ["field_out"=>"turno",  "from"=>"des_turno_trab", "render_value"=>null,],
            ["field_out"=>"turma", "from"=>"des_turma_trab", "render_value"=>null,],
            ["field_out"=>"jan", "from"=>"jan_orcado_headcount", "render_value"=>function($row_data,$value){
                return intval($value);
            }],
            ["field_out"=>"fev", "from"=>"fev_orcado_headcount", "render_value"=>function($row_data,$value){
                return intval($value);
            }],
            ["field_out"=>"mar", "from"=>"mar_orcado_headcount", "render_value"=>function($row_data,$value){
                return intval($value);
            }],
            ["field_out"=>"abr", "from"=>"abr_orcado_headcount", "render_value"=>function($row_data,$value){
                return intval($value);
            }],
            ["field_out"=>"mai", "from"=>"mai_orcado_headcount", "render_value"=>function($row_data,$value){
                return intval($value);
            }],
            ["field_out"=>"jun", "from"=>"jun_orcado_headcount", "render_value"=>function($row_data,$value){
                return intval($value);
            }],
            ["field_out"=>"jul", "from"=>"jul_orcado_headcount", "render_value"=>function($row_data,$value){
                return intval($value);
            }],
            ["field_out"=>"ago", "from"=>"ago_orcado_headcount", "render_value"=>function($row_data,$value){
                return intval($value);
            }],
            ["field_out"=>"set", "from"=>"set_orcado_headcount", "render_value"=>function($row_data,$value){
                return intval($value);
            }],
            ["field_out"=>"out", "from"=>"out_orcado_headcount", "render_value"=>function($row_data,$value){
                return intval($value);
            }],
            ["field_out"=>"nov", "from"=>"nov_orcado_headcount", "render_value"=>function($row_data,$value){
                return intval($value);
            }],
            ["field_out"=>"dez", "from"=>"dez_orcado_headcount", "render_value"=>function($row_data,$value){
                return intval($value);
            }],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null,],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,]
        ];

        $columns_base=array_merge($column_fixeds, $col_meses_parent); 
        $columns_children=array_merge($column_fixeds_children, $col_set_meses); 
        //  dd($columns_base);
        $settings=["columns"=>$columns_base,
            "keys"=>['cod_cargo_basic'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children"=>["columns"=>$columns_children,
                    "keys"=>['id'],
                    "filter_data"=>['calc_orc_id'=>function($value){
                        return !is_null($value);
                        }],
                    'parent_filter'=> function($value, $parent_data){  
                        // dd($parent_data['id']);                          
                            return /*$value['cod_ccusto']== $parent_data['cod_ccusto'] && */
                            $value['cod_cargo_basic']== $parent_data['cod_cargo_basic']/* &&
                            $value['cdn_turma_trab']== $parent_data['cdn_turma_trab'] && $value['id']==$parent_data['calc_orc_id'] */;
                    }
                ]
            ];
             
        $controller=new AtmTreeTable($settings, $data);
        // dd("treeeeeeeeeTTTTTTTTTTTTTTTTTTTTTTTTTTTTT",['data'=>$controller->render()]);
       return ['data'=>$controller->render()]; 
    }  

    public function insert(Request $request){
        $data_request = $request->all();
      
        return $this->retornoJsonDefault($this->getRepository()->createHeadcount($data_request));
    }
 

    public function deleteHe(Request $request){
        $repo_calc_orcamento = new RepoCalcOrcamento();
        // dd($request->all());
        DB::beginTransaction();
        try {
    
            $deletou = $event->where('id',$request->all()[0])->delete();
            
            if(!$deletou){
                return false;
            }
             
            // $deletou_calc = $repo_calc_orcamento->getModelInstance()->where(['origem_id'=>$request->all()[0],'tbl_origem'=>'tbl_orc_lot_carg_event'])->delete();
        
            // if($deletou_calc==false){
            //     $this->setError([$repo_calc_orcamento->getErrosFlatted(),'Erro: 021220191908']);
            //     DB::rollBack();
            //     return false;        
            // }
            DB::commit();

        } catch (\Exception $e) {
             DB::rollBack();
             abort(500,'Falha ao deletar registro. Erro: 021220181942.'.$e);        
        }

        $retorno['status'] = 'success';
        $retorno['msg'] = 'Registro deletado com sucesso!';
        return $retorno;
    
    }

    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['funcionario_id', 'orc_id', 'lotacao_ancestral_id','lotacao_corrente_id','cargo_ancestral_id', 'cargo_corrente_id','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','evento_id','origem_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }
    public function dataFilterHeadCount($data){
        $array_orcamento=['jan_orcado', 'fev_orcado', 'mar_orcado','abr_orcado','mai_orcado', 'jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado','tbl_origem','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','origem_id','id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

    public function deleteHeadForm(Request $request){
        $retorno = $this->getRepository()->deleteHeadcount(array('id'=>$request->all()['id'],'id_princ'=>$request->all()['id_princ']));
        return $retorno;
    }


    public function finishedForecast(Request $request){
        dd($request->all());
    }
     
}
