<?php
namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoHoraExtra as RepoHoraExtra;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\EventosTipo;
use Illuminate\Http\Request as Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;

class HoraExtraController extends OrcamentoController {

    public function __construct(){
		$this->setRepository(new RepoHoraExtra());
        parent::__construct();
    }
	
	/** ESTE HORA EXTRA É DO HORA EXTRA DO ORÇAMENTO NÃO DO HEADCOUNT */
    public function listarHe($orc_id){
		
        return $this->getRepository()->listarHe($orc_id);
    }  

    public function inserirHraExtra(Request $request,$orcId){
		$r=$request->all();
		// dd("Aquiiiii", $r);
		// $retorno=$this->getArrayRetornoDefault();
		$orcamento=$this->getRepositoryOrModel()->getOrcInstanceNew()->find($orcId);
		
		if($this->getRepositoryOrModel()->setOrcamento($orcamento)->canEdit()==false){//Se o usuario não tiver a pemissão
			$retorno["status"]="error";
			$retorno["msg"]='Não é possível cadastrar esta Hora Extra pois o mesmo não permite.';
			$retorno['submsg']='Falha ao inserir. Erro 131220191114';
			goto saida;
		}

		foreach($r['items'] as $item){
			$form_data=$this->getRepositoryOrModel()->putOrcamentoIdOnData($item, $orcId);
			
			$evento_id= isset($form_data['id']) ? intval($form_data['id']) : 0;
			
			$ja_existe=$this->getRepositoryOrModel()->getModelEntity()->where(['orcamento_id'=>$orcId,'evento_id'=>$evento_id])
				->first();
	
			if(!empty($ja_existe)){
				// $retorno["status"]="error";
				$retorno["msg"]='A opção selecionada já existe.';
				$retorno['submsg']='Falha ao inserir. Erro 131220190814';
				goto saida;
			}

			$orc_event=array(
				'orcamento_id'=>$form_data['orcamento_id'],
				'evento_id'=>$form_data['id']
			);
	
			if(!$this->getRepositoryOrModel()->create($orc_event)){
				$retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
				$retorno['submsg']='Falha ao inserir o registro. Erro:111220191024';
				goto saida;
			}
		}
		


        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);  
         //dd($retorno);
        
    } 

	public function deletar(Request $request, $orcId){
    	/*AjustesSalariaisController- 
    	$tb_cargo_area->where('lotacao_id', $id_lotacao)->delete();*/
    	//$tbl_evento=new Eventos();
		
		$r=$request->all();
		
		foreach($r['items'] as $item){
			
			$evento_id = $item['id'];

			$delete=$this->getRepository()->getModelEntity()->where('orcamento_id',$orcId)->where('evento_id',$evento_id)->delete();

			if(!$delete){
				$retorno['status']='error';
				$retorno['msg']='Falha ao deletar o registro. Erro: 170220200946.';
				goto saida;
			}
		}

		  $retorno['status']='success';
		  $retorno['msg']='Registro deletado com sucesso!';

		saida:  
    	return $retorno;
	}
	
	public function listaEventosHoraExtra(){
		$eventos_tipo = new EventosTipo();
		$eventos = new Eventos();

		$data = $eventos			
            ->join($eventos_tipo->getTable(), $eventos->getColunaAlias('tipo_evento_id'), '=',                            
			DB::raw("{$eventos_tipo->getColunaAlias('id')} AND 
				{$eventos->getColunaAlias('tipo_evento_id')} = 3 AND 
				{$eventos->getColunaAlias('ativo')} = 1")) 
				->select(
					DB::raw("{$eventos->getColunaAlias('id')}, 
					{$eventos->getColunaAlias('cdn_event')},
					{$eventos->getColunaAlias('des_event')},
					{$eventos->getColunaAlias('inc_liquido')},
					{$eventos->getColunaAlias('impr_envel')},
					{$eventos->getColunaAlias('multiplica')},
					{$eventos->getColunaAlias('ativo')},
					{$eventos->getColunaAlias('origem')},
					{$eventos->getColunaAlias('tipo_evento_id')}
					" )
				)
				->get()
			->toArray();
			
			for($i=0;$i<count($data);$i++){				
				$dados[$i]=array_merge($data[$i],array("description"=>$data[$i]['cdn_event'].' - '.$data[$i]['des_event']));				
		   }

		   return $dados;
    }
}


