<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcBeneficio as RepoOrcBeneficio;
use App\Modules\Natureza51\Entities\Beneficio;
use Illuminate\Http\Request as Request;
use Illuminate\Http\Response;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Facades\DB;

class OrcBeneficiosController extends OrcamentoController
{
    public function __construct(){
        $this->setRepository(new RepoOrcBeneficio());
        parent::__construct();
    } 

    public function inserir(Request $request, $id=null) {
        // dd("evento", $request->all());
        $form_data=$this->getRepositoryOrModel()->putOrcamentoIdOnData($request->all(),$id);
       
        $beneficio = new Beneficio();
      
        $beneficio_id = $beneficio->select(DB::raw('id as beneficio_id'))->where([
            ['evento_id','=', $form_data['evento_id']],
            ['empresa_id','=', 1]
        ])
        ->first();  
        
        if(!$beneficio_id){
            $retorno['msg']="Evento não cadastrado para este Benefício!";
            $retorno['submsg']='Falha ao inserir o registro. Erro:131220191907';
            $retorno['status']='error';
            goto saida;
        }
        
        $form_data['beneficio_id'] = $beneficio_id->beneficio_id;
  
        if(! $this->getRepositoryOrModel()->createOrcBeneficio($form_data)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro:301120191630';
            $retorno['status']='error';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);        
    }    

    public function list($id){ 
       $dados=$this->getRepositoryOrModel()->listar($id);
       return $this->renderTreeTableList($dados);
    } 

    public function listEvent($orc_id){
       
        $dados=$this->getRepositoryOrModel()->listaEventos($orc_id);
        return $dados;
    }
    
    public function deletar(Request $request, $id) {
        
        $form_data=$request->all();
        
        if(! $this->getRepositoryOrModel()->deleteOrcBeneficio($form_data)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao deletar o registro. Erro:141220191400';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);      
        
    }

    public function updateBeneficio(Request $request, $id) {
        
        $form_data=$request->all();
        
        if(! $this->getRepositoryOrModel()->updateOrcBeneficio($form_data)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao deletar o registro. Erro:161220191635';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);      
        
    }

   function renderTreeTableList($dados){
    //dd($dados);
    $columns_base=[ 
        ["field_out"=>"id", "from"=>"id"],
        ["field_out"=>"orcamento_id", "from"=>"orcamento_id"],
        ["field_out"=>"beneficio_id", "from"=>"beneficio_id"],
        ["field_out"=>"evento_id", "from"=>"evento_id"], 
        ["field_out"=>"description", "from"=>"description"], 
        ["field_out"=>"tipo_calc", "from"=>"tipo_calc"], 
        ["field_out"=>"vlr_movto", "from"=>"vlr_movto"], 
        ["field_out"=>"vlr_depend", "from"=>"vlr_depend"], 
        ["field_out"=>"des_event", "from"=>"des_event"], 
        ["field_out"=>"formula", "from"=>"formula"], 
        ["field_out"=>"empresa_id", "from"=>"empresa_id"], 
        ["field_out"=>"calc_orcamento_id", "from"=>"calc_orcamento_id"], 
        ["field_out"=>"origem_id", "from"=>"origem_id"], 
        ["field_out"=>"tbl_origem", "from"=>"tbl_origem"], 

       ["field_out"=>"jan_orcado", "from"=>"jan_orcado","render_value"=>null],
       ["field_out"=>"fev_orcado", "from"=>"fev_orcado","render_value"=>null],
       ["field_out"=>"mar_orcado", "from"=>"mar_orcado","render_value"=>null],     
       ["field_out"=>"abr_orcado", "from"=>"abr_orcado","render_value"=>null], 
       ["field_out"=>"mai_orcado", "from"=>"mai_orcado","render_value"=>null],     
       ["field_out"=>"jun_orcado", "from"=>"jun_orcado","render_value"=>null],     
       ["field_out"=>"jul_orcado", "from"=>"jul_orcado","render_value"=>null],     
       ["field_out"=>"ago_orcado", "from"=>"ago_orcado","render_value"=>null],     
       ["field_out"=>"set_orcado", "from"=>"set_orcado","render_value"=>null],    
       ["field_out"=>"out_orcado", "from"=>"out_orcado","render_value"=>null],    
       ["field_out"=>"nov_orcado", "from"=>"nov_orcado","render_value"=>null],    
       ["field_out"=>"dez_orcado", "from"=>"dez_orcado","render_value"=>null]
   ];
    
    
   $settings=["columns"=>$columns_base,
           "keys"=>['id'] 
       ];    
       
   $controller=new AtmTreeTable($settings, $dados);
   
 return $controller->render();
}
}