<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoOrcBonus as RepoOrcBonus;
use App\Modules\Natureza51\Entities\OrcBonus;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use App\Support\TreeTable\AtmTreeTable;

class OrcBonusController extends Natureza51Ctrl
{
     public function __construct(){
        $this->repository=new RepoOrcBonus();
        parent::__construct();
    }
    public function listAll($id){
        // dd($id);
        $data = $this->getRepository()->listar($id);
        $cont = count($data);
        for ($i=0; $i < $cont ; $i++) { 
            // var_dump($data[$i]);
            array_push($data,array('parent'=>$data[$i]['grade_salarial'],'grade_salarial'=>null));
        }
        // dd($data);
        return $this->montarTreetable($data);
    }

    public function getCargoByGrade(Request $request){
        $all = $request->all();
        unset($all['_token']);

        $data = $this->repository->getCargoByGrade($all);
       

        for ($i=0; $i < count($all); $i++) { 
            $data[(count($data))+$i] = array('parent'=>$all[$i],'grade_salarial'=>null); 
        }
        return $this->montarTreetable($data);
    }
        
    public function montarTreetable($data){
        // dd ($data);
        $column_fixeds=[ 
            ["field_out"=>"parent", "from"=>"parent","render_value"=>null],
            ["field_out"=>"orc_id", "from"=>"orc_id","render_value"=>null],

            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"parent", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
        ];
        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"porcentagem", "from"=>"porcentagem", "render_value"=>null,],

            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"num_sal","from"=>"num_sal", "render_value"=>null,],
            ["field_out"=>"grade_salarial","from"=>"grade_salarial", "render_value"=>null,],
            ["field_out"=>"cargo_id","from"=>"cargo_id", "render_value"=>null,],

            ["field_out"=>"ccusto_id","from"=>"ccusto_id", "render_value"=>null,],
        ];
        $settings=["columns"=>$column_fixeds,
        "keys"=>['parent'],
        "filter_data"=>['grade_salarial'=>function($value){
            return is_null($value);
        }],                        
        "children"=>["columns"=>$column_fixeds_children,
                "keys"=>['grade_salarial','id'],
                "filter_data"=>['parent'=>function($value){
                    return is_null($value);
                 }],
                'parent_filter'=> function($value, $parent_data){                            
                        return $value['grade_salarial']== $parent_data['parent'] ;
                },
            ] 
        ];
        $controller=new AtmTreeTable($settings, $data);
        return $controller->render();
    }

    public function insertBonus(Request $request,$orc_id){   
        
        $data = $request->all();
    //    $data = $this->getRepository()->insert($request->all());

        if(!$this->getRepository()->insert($orc_id,$data)){                  
            $retorno["status"]="error";
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir do registro. Erro: 080120202005';
            goto saida;               
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        saida:       
     
        return $this->retornoJsonDefault($retorno); 
    } 

    public function updateBonus(Request $request,$orc_id){  
        
        $data = $request->all();
        unset($data['_token']);
        
        if(!$this->getRepository()->updateBonus($orc_id,$data)){                  
            $retorno["status"]="error";
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer update do registro. Erro: 271120191600';
            goto saida;               
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        saida:       
     
        return $this->retornoJsonDefault($retorno); 
    } 

    public function deleteBonus(Request $request,$orc_id){  
        
        $data = $request->all();

        if(!$this->getRepository()->deleteBonus($orc_id,$data)){                  
            $retorno["status"]="error";
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer delete do registro. Erro: 271120191600';
            goto saida;               
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        saida:       
      
        return $this->retornoJsonDefault($retorno); 
    } 

    public function dataFilterBonus($data){
        $array_orcamento=['des_cargo_basic', 'cod_cargo_basic', '_token','grade_salarial','mai_orcado', 'jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado','tbl_origem','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','origem_id','id'];
        
        $filtered = Arr::except($data, $array_orcamento);  
               
        return $filtered;
    }
    
}
