<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcCargo as RepoOrcCargo;
// use Symfony\Component\HttpFoundation\Request;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Http\Response;
use App\Support\TreeTable\AtmTreeTable;

class OrcCargoSalController extends OrcamentoController
{
    
    public function __construct(){
        $this->setRepository(new RepoOrcCargo());
        parent::__construct();
    }
    public function listarAll($orc_id){
        $result=$this->getRepository()->listAll($orc_id);
 
        if($result===false){
            $retorno=$this->getArrayRetornoDefault();
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro: 051220190952.';
            
            return $this->retornoJsonDefault($retorno);
        }
        return new Response(json_encode($this->renderTreeTable($result->toArray() )));
    }
    public function inserir(Request $request,$id=null) {
        
        $form_data=$this->getRepositoryOrModel()->putOrcamentoIdOnData($request->all(),$id);
        //;dd($form_data);
        if(! $this->getRepositoryOrModel()->createOrc($form_data)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['status']='error';
            $retorno['submsg']='Falha ao inserir o registro. Erro:301120191630';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Sucesso";
        $retorno["submsg"]="Cadastro realizado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);
        
    }

    public function updateOrcCargo(\Illuminate\Http\Request $request, $id) {
        $form_data=$request->all();
        
        if(! $this->getRepositoryOrModel()->updateOrc($form_data)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao deletar o registro. Erro:060120201744';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno['msg']="Sucesso";
        $retorno["submsg"]="Registro atualizado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);      
        
    }    

    public function deleteOrcCargo(\Illuminate\Http\Request $request, $id) {
        $form_data=$request->all();
               
        if(! $this->getRepositoryOrModel()->deleteOrcCargo($form_data)){
            
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao deletar o registro. Erro:060120201744';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);      
        
    }    
    
    private function renderTreeTable($dados){
         $columns_base=[ 
            ["field_out"=>"id"],
            ["field_out"=>"id_calc", "from"=>"id_calc"],            

            ["field_out"=>"cargo_id"],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic"],            
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic"],
            ["field_out"=>"orcamento_id"],
            ["field_out"=>"sal_base", "from"=>"sal_base", "render_value"=>null,],
            ["field_out"=>"sal_max", "from"=>"sal_max", "render_value"=>null,],
            ["field_out"=>"sal_med", "from"=>"sal_med"],
            ["field_out"=>"sal_min", "from"=>"sal_min" ],      
            ["field_out"=>"data_calc", "from"=>"data_calc",],
            ['field_out'=>'jan_orcado',"from"=>'jan_orcado'],
            ['field_out'=>'fev_orcado',"from"=>'fev_orcado'],
            ['field_out'=>'mar_orcado',"from"=>'mar_orcado'],
            ['field_out'=>'abr_orcado',"from"=>'abr_orcado'],
            ['field_out'=>'mai_orcado',"from"=>'mai_orcado'],
            ['field_out'=>'jun_orcado',"from"=>'jun_orcado'],
            ['field_out'=>'jul_orcado',"from"=>'jul_orcado'],
            ['field_out'=>'ago_orcado',"from"=>'ago_orcado'],
            ['field_out'=>'set_orcado',"from"=>'set_orcado'],
            ['field_out'=>'out_orcado',"from"=>'out_orcado'],
            ['field_out'=>'nov_orcado',"from"=>'nov_orcado'],
            ['field_out'=>'dez_orcado',"from"=>'dez_orcado'],

        ];
        $settings=["columns"=>$columns_base,
                "keys"=>['id' ] 
            ];    
         
        $controller=new AtmTreeTable($settings, $dados);
        
      return $controller->render();
    }

    public function listarCargo($orc_id){
        $result = $this->getRepository()->listarCargo($orc_id);
        // dd("controller",  $result);
        if($result==false){
            $retorno=$this->getArrayRetornoDefault();
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao listar os cargos. Erro: 051220190952.';
            return $this->retornoJsonDefault($retorno);
        }
        return $result;
    }

    public function cargoExistenteOrc(){
        $cargo = 12;
        $orc_id = 1;

        $result = $this->getRepository()->cargoExistenteOrc($cargo, $orc_id);

        return $result;
    }
}
