<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcContratacoes as RepoOrcContratacoes;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento as RepoCalcOrcamento;
use App\Modules\Natureza51\Entities\OrcFerias;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcContratacoes;
use Illuminate\Http\Request as Request;
use Illuminate\Http\Response;
use Illuminate\Support\Arr;
use App\Support\TreeTable\AtmTreeTable;
use DB;

class OrcContratacoesController extends OrcamentoController
{

    use \App\Core\Traits\ErrorTrait;
    
    public function __construct(){
        parent::__construct();
        $this->repository=new RepoOrcContratacoes();
    }

    public function insert(Request $request){

         $a = $this->getRepository()->createContratacoes($request->all());
         return $this->retornoJsonDefault($a);
    }

    public function update(Request $request){  
        
        $repo_calc_orcamento = new RepoCalcOrcamento();
        $form_data = $request->all();        
        $id=$form_data['id'];
        $meses = $this->dataFilterMesesCalcOrcamento($form_data); 
        $data = $this->dataFilterPromocao($form_data);
        // dd($data);

        if(!$repo_calc_orcamento->update($meses,['id'=>$id,'tbl_origem'=>'tbl_orc_ferias'])){                  
                $retorno["status"]="error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer update do registro. Erro: 271120191600';
                goto saida;               
        } 

        if(!$this->getRepository()->update($data, ['id'=>$id])){                  
            $retorno["status"]="error";
            $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer update do registro. Erro: 271120191600';
            goto saida;               
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        saida:       
     
        return $this->retornoJsonDefault($retorno); 
    } 
    public function delete(Request $request){  

        $repo_calc_orcamento = new RepoCalcOrcamento();
        $form_data = $request->all();        
        $id=$form_data['id'];
        // dd($id);

        // dd();

        $calcOrcamento = $repo_calc_orcamento->getModelInstance()->where('id',$id)->first();

        if(!$calcOrcamento->delete()){                  
                $retorno["status"]="error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer delete do registro. Erro: 271120191601';
                goto saida;               
        } 

        if(!$this->getRepository()->delete($calcOrcamento['origem_id'])){                  
            $retorno["status"]="error";
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer delete do registro. Erro: 271120191602';
            goto saida;               
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        saida:       
      
        return $this->retornoJsonDefault($retorno); 
    } 
    public function pivo($dados){
        $meses_orcado = ['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado',
        'jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];
        $eventos_meses = [13,14,15,16];
        $retorno=[];
        $primary_key=['id','lotacao_id','orc_turma_id',];
       
        $merge_meses_evento=[];
        $meses_orcados_clear=[];        
        
        $dados_rest = [];
        foreach($dados as $key => $value){
            
            $value=(array)$value;
            $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
            $ja_foi=array_keys($retorno);
            
            if(in_array($keys_values, $ja_foi)===false){                
                $aux=Arr::except($value,$meses_orcado);   
                $retorno[$keys_values]=$aux;

            }
            foreach($meses_orcado as $j=>$w){                     
                $retorno[$keys_values][$w]=$value[$w];
            }
        }
        return $retorno;
    }
    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['meses', 'funcionario_id', 'orc_id', 'lotacao_id','cargo_id','orc_turma_id', 'lotacao_responsavel','orcamento_id','type', 'orc_cargo_id', 'ccusto_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }
    public function dataFilterContratacoes($data){
        $array_orcamento=['meses','tbl_origem','cargo_id','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','origem_id','id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

   

}
