<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcCronograma;
use Illuminate\Http\Request as Request;
use Illuminate\Support\Facades\DB;

class OrcCronogramaController extends OrcamentoController
{
    public function __construct(){
        $this->setRepository(new RepoOrcCronograma());
        parent::__construct();
    }

    public function list(Request $request){
        $orc_id = $request->all()[0];
       return $this->getRepository()->listar($orc_id);
    }

    public function verify(){
        return $this->getRepository()->verifyBudget();
    }

    public function insertAll(Request $request){
        $all = $request->all();
        $retorno = $this->getRepository()->insertCronograma($all);
        
        if(!$retorno){
            $r['status']='error';
            $r['msg']=$this->getRepository()->getErrosFlatted();
            goto saida;
        }
        $r['status']='success';
        $r['msg']='Registro inserido com sucesso!';
        saida:
        return $r;
    }

    public function updateAll(Request $request){
        $all = $request->all();
        $retorno = $this->getRepository()->updateCronograma($all);
        
        if(!$retorno){
            $r['status']='error';
            $r['msg']=$this->getRepository()->getErrosFlatted();
            goto saida;
        }
        $r['status']='success';
        $r['msg']='Registro atualizado com sucesso!';
        saida:
        return $r;
    }

    public function deleteAll(Request $request){
       
        $all = $request->all();
        $retorno = $this->getRepository()->deleteCronograma($all);
        
        if(!$retorno){
            $r['status']='error';
            $r['msg']=$this->getRepository()->getErrosFlatted();
            goto saida;
        }
        $r['status']='success';
        $r['msg']='Registro deletado com sucesso!';
        saida:
        return $r;
    }


} 