<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Entities\Despesas;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Repositories\RepoLotacao;
use App\Modules\Natureza51\Repositories\RepoOrcDespesas as RepoOrcDespesas;
use App\Modules\Natureza51\Repositories\RepoOrcLotacao;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class OrcDespesasController extends Natureza51Ctrl{
    public function __construct()
    {
        $this->repository=new RepoOrcDespesas();
        return parent::__construct();
    }
    public function listarDesp($orc_id){
       
        // $all=$this->getRepository()->getModelEntity()->get()->toArray();
        $all=$this->getRepository()->listar($orc_id);
        //$dados=$this->getRepository()->getDescricao($orc_id,$all);

        $tree=$this->renderTreeTableList($all);
        return new Response(json_encode($tree), 200);
    }
    function renderTreeTableList($dados){
        //dd($dados);
        $columns_base=[ 
            ["field_out"=>"id", "from"=>"id"],
            ["field_out"=>"orc_id", "from"=>"orc_id"],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id"],
            ["field_out"=>"despesa_id", "from"=>"despesa_id"],
            ["field_out"=>"centro_custo_id", "from"=>"centro_custo_id"],
            ["field_out"=>"valor_referencia", "from"=>"valor_referencia"],
            ["field_out"=>"des_unid_lotac", "from"=>"des_unid_lotac"],
            ["field_out"=>"descricao", "from"=>"descricao"],
            ["field_out"=>"origem_id", "from"=>"origem_id"], 
            ["field_out"=>"tbl_origem", "from"=>"tbl_origem"],


    
           ["field_out"=>"jan_orcado", "from"=>"jan_orcado","render_value"=>null],
           ["field_out"=>"fev_orcado", "from"=>"fev_orcado","render_value"=>null],
           ["field_out"=>"mar_orcado", "from"=>"mar_orcado","render_value"=>null],     
           ["field_out"=>"abr_orcado", "from"=>"abr_orcado","render_value"=>null], 
           ["field_out"=>"mai_orcado", "from"=>"mai_orcado","render_value"=>null],     
           ["field_out"=>"jun_orcado", "from"=>"jun_orcado","render_value"=>null],     
           ["field_out"=>"jul_orcado", "from"=>"jul_orcado","render_value"=>null],     
           ["field_out"=>"ago_orcado", "from"=>"ago_orcado","render_value"=>null],     
           ["field_out"=>"set_orcado", "from"=>"set_orcado","render_value"=>null],    
           ["field_out"=>"out_orcado", "from"=>"out_orcado","render_value"=>null],    
           ["field_out"=>"nov_orcado", "from"=>"nov_orcado","render_value"=>null],    
           ["field_out"=>"dez_orcado", "from"=>"dez_orcado","render_value"=>null]
       ];
        
        
       $settings=["columns"=>$columns_base,
               "keys"=>['id'] 
           ];    
           
       $controller=new AtmTreeTable($settings, $dados);
       
     return $controller->render();
    }

    public function insert(Request $request){
        $dados=$request->all();
        $retorno=$this->getArrayRetornoDefault();
        $obj=$this->getRepository()->insertWithMeses($dados);
        

        if(!$obj){
            $retorno['status']='error';
            $retorno['submsg']='Erro';
            $retorno['msg']='Falha ao inserir registro!';
            goto saida;
        }
        $retorno['status']='success';
        $retorno['submsg']='Registro inserido com sucesso!';
        $retorno['msg']='Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function delete(Request $request){
        $data=$request->all();
        $retorno=$this->getArrayRetornoDefault();
        
        $obj=$this->getRepository()->deleteDespesa($data);
        
        if(!$obj){
            $retorno['status']='error';
            $retorno['submsg']='Erro';
            $retorno['msg']='Falha ao excluir registro! erro:110220201625';
            goto saida;
        }
        $retorno['status']='success';
        $retorno['submsg']='Registro excluido com sucesso!';
        $retorno['msg']='Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    public function updateDespCalc(Request $request){
        $data=$request->all();
        $retorno=$this->getArrayRetornoDefault();
        $obj=$this->getRepository()->updateDespCalc($data,$data['id'],"id");
        if(!$obj){
            $retorno['status']='error';
            $retorno['msg']='Erro';
            $retorno['submsg']='Falha ao atualizar registro. erro: 110220201550!';
            goto saida;
        }
        $retorno['status']='success';
        $retorno['submsg']='Registro atualizado com sucesso!';
        $retorno['msg']='Sucesso';

        saida:
        return $this->retornoJsonDefault($retorno);
    }
}