<?php
namespace App\Modules\Natureza51\Http\Controllers;
use App\Modules\Natureza51\Repositories\RepoOrcDissidio;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Http\Request;

class OrcDissidioController extends OrcamentoController{
    
    public function __construct(){
        parent::__construct();
        $this->repository=new RepoOrcDissidio();
    } 

    public function listarAll($orc_id){
         $list = $this->getRepository()->listar($orc_id);
         //dd("Lista",$list);
         return $this->montarTreetable($list);

    }

    public function inserirDissidio(Request $request){
        $all = $request->all();
        //dd("dados",$all);
        $retorno = $this->getRepository()->inserir($all['grades'],$all['orc_id'],$all['meses']);
        return $retorno['status']=='error'?$this->retornoJsonDefault($retorno,500):$retorno;
    }

    public function editarDissidio(Request $request){
        $all = $request->all();
        $retorno = $this->getRepository()->editar($all);
        return $retorno['status']=='error'?$this->retornoJsonDefault($retorno,500):$retorno;    
    }

    public function deleteDissidio(Request $request){
        $all = $request->all();
        $retorno = $this->getRepository()->deletar($all);
        return $retorno['status']=='error'?$this->retornoJsonDefault($retorno,500):$retorno;    

    }
    public function montarTreetable($data){
        // dd ($data);
        $column_fixeds=[ 
            ["field_out"=>"grade_salarial", "from"=>"grade_salarial","render_value"=>null],
        ];
        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id", "render_value"=>null,],
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id", "render_value"=>null,],
            ["field_out"=>"id_calc_orc", "from"=>"id_calc_orc", "render_value"=>null,],

            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null,],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic", "render_value"=>null,],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null,],
            ["field_out"=>"grade_salarial", "from"=>"grade_salarial","render_value"=>null],
            ["field_out"=>"description", "from"=>"description","render_value"=>null],
            ["field_out"=>"jan_orcado", "from"=>"jan_orcado", "render_value"=>null,function($rowData,$value){
                return repDecimal($value);
            }],
            ["field_out"=>"fev_orcado", "from"=>"fev_orcado", "render_value"=>null,function($rowData,$value){
                return repDecimal($value);
            }],
            ["field_out"=>"mar_orcado", "from"=>"mar_orcado", "render_value"=>null,function($rowData,$value){
                return repDecimal($value);
            }],
            ["field_out"=>"abr_orcado", "from"=>"abr_orcado", "render_value"=>null,function($rowData,$value){
                return repDecimal($value);
            }],
            ["field_out"=>"mai_orcado", "from"=>"mai_orcado", "render_value"=>null,function($rowData,$value){
                return repDecimal($value);
            }],
            ["field_out"=>"jun_orcado", "from"=>"jun_orcado", "render_value"=>null,function($rowData,$value){
                return repDecimal($value);
            }],
            ["field_out"=>"jul_orcado", "from"=>"jul_orcado", "render_value"=>null,function($rowData,$value){
                return repDecimal($value);
            }],
            ["field_out"=>"ago_orcado", "from"=>"ago_orcado", "render_value"=>null,function($rowData,$value){
                return repDecimal($value);
            }],
            ["field_out"=>"set_orcado", "from"=>"set_orcado", "render_value"=>null,function($rowData,$value){
                return repDecimal($value);
            }],
            ["field_out"=>"out_orcado", "from"=>"out_orcado", "render_value"=>null,function($rowData,$value){
                return repDecimal($value);
            }],
            ["field_out"=>"nov_orcado", "from"=>"nov_orcado", "render_value"=>null,function($rowData,$value){
                return repDecimal($value);
            }],
            ["field_out"=>"dez_orcado", "from"=>"dez_orcado", "render_value"=>null,function($rowData,$value){
                return repDecimal($value);
            }]
        ];
        $settings=["columns"=>$column_fixeds,
        "keys"=>['grade_salarial'],
        "filter_data"=>['grade_salarial'=>function($value){
            return !is_null($value);
        }],                        
        "children"=>["columns"=>$column_fixeds_children,
                "keys"=>['id'],
                "filter_data"=>['id'=>function($value){
                    return !is_null($value);
                 }],
                'parent_filter'=> function($value, $parent_data){
                        return $value['grade_salarial'] == $parent_data['grade_salarial'] ;
                },
            ] 
        ];
        $controller=new AtmTreeTable($settings, $data);
        return $controller->render();
    }


}





