<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcEventos;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class OrcEventosController extends OrcamentoController
{
    
   public function __construct(){
        $this->repository=new RepoOrcEventos();
        parent::__construct();
    }
    public function listarAll($orc_id){
        
        $result=$this->getRepository()->listarAll($orc_id);
        if($result===false){
            $retorno=$this->getArrayRetornoDefault();
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao carregar registros. Erro: 211220190944.';
            
            return $this->retornoJsonDefault($retorno);
        }
        
        return new Response(json_encode($this->renderTreeTable($result)));
    }



    public function updateAll(Request $request){
        $all = $request->all();
        
        $a = $this->getRepository()->updateAll($all);
        if(!$a){
            $retorno['status']='error';
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            goto saida;
        }
 
        $retorno['status']='success';
        $retorno['msg']='Registro inserido com sucesso!';

        saida:
        return $retorno;


    }

    public function deleteAll(Request $request){
        $all = $request->all();
        
        $a = $this->getRepository()->deleteAll($all);
        if(!$a){
            $retorno['status']='error';
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            goto saida;
        }
 
        $retorno['status']='success';
        $retorno['msg']='Registro deletado com sucesso!';

        saida:
        return $retorno;
    }

    public function insertAll(Request $request){


        $all = $request->all();
        
        $a = $this->getRepository()->insertAll($all);
        if(!$a){
            $retorno['status']='error';
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            goto saida;
        }
 
        $retorno['status']='success';
        $retorno['msg']='Registro inserido com sucesso!';

        saida:
        return $retorno;



    }


    protected function renderTreeTable($dados){
        
        $columns_base=[ 
            ["field_out"=>"id", "from"=>"id"],
            ["field_out"=>"evento_id", "from"=>"evento_id"],
            ["field_out"=>"cdn_event", "from"=>"cdn_event"],
            ["field_out"=>"des_event", "from"=>"des_event"],
            ["field_out"=>"multiplica", "from"=>"multiplica","render_value"=>function($row_data, $value){
                return ($value * 100) - 100;
            }],

            ["field_out"=>"orcamento_id", "from"=>"orcamento_id"],
            ["field_out"=>"inc_liquido", "from"=>"inc_liquido", "render_value"=>null,],
            ["field_out"=>"impr_envel", "from"=>"impr_envel", "render_value"=>null,],
            ["field_out"=>"jan_orcado", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,'.', '');
            }],
            ["field_out"=>"fev_orcado", "from"=>"fev_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,'.', '');
            }],
            ["field_out"=>"mar_orcado", "from"=>"mar_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,'.', '');
            }],     
            ["field_out"=>"abr_orcado", "from"=>"abr_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,'.', '');
            }], 
            ["field_out"=>"mai_orcado", "from"=>"mai_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,'.', '');
            }],     
            ["field_out"=>"jun_orcado", "from"=>"jun_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,'.', '');
            }],     
            ["field_out"=>"jul_orcado", "from"=>"jul_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,'.', '');
            }],     
            ["field_out"=>"ago_orcado", "from"=>"ago_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,'.', '');
            }],     
            ["field_out"=>"set_orcado", "from"=>"set_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,'.', '');
            }],    
            ["field_out"=>"out_orcado", "from"=>"out_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,'.', '');
            }],    
            ["field_out"=>"nov_orcado", "from"=>"nov_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,'.', '');
            }],    
            ["field_out"=>"dez_orcado", "from"=>"dez_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,'.', '');
            }]
        ];

         
         
        $settings=["columns"=>$columns_base,
                "keys"=>['id' ] 
            ];    
            
        $controller=new AtmTreeTable($settings, $dados);
        
      return $controller->render();
        
    }
}
