<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcFerias as RepoOrcFerias;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento as RepoCalcOrcamento;
use App\Modules\Natureza51\Entities\OrcFerias;
use Illuminate\Http\Request as Request;
use Illuminate\Http\Response;
use Illuminate\Support\Arr;
use App\Support\TreeTable\AtmTreeTable;

class OrcFeriasController extends OrcamentoController
{
    
    public function __construct(){
        parent::__construct();
        $this->repository=new RepoOrcFerias();
    }
    public function listarAll($orc_id){
        // DB::enableQueryLog();
        $dd=$this->getRepository()->listAll($orc_id);
    } 
    public function listarByTurma($orc_id,$lotacao, $tipo_table){

        $data = $this->repository->listarByTurma($orc_id,$lotacao, $tipo_table);
        $columns_base= $this->getColumnsBase();
        $columns_children= $this->getColumnsChildren();

        $settings=["columns"=>$columns_base,
            "keys"=>['cargo_id','lotacao_id'],
            "filter_data"=>['parent'=>function($value){
                    return is_null($value);
            }    
            ],                                  
            "children"=>["columns"=>$columns_children,
                "keys"=>['id'], 
                "filter_data"=>['parent'=>function($value){
                    return is_null($value);
                }],
                'parent_filter'=> function($value, $parent_data){                            
                        return $value['cargo_id']== $parent_data['cargo_id'] ;
                },
            ] 
        ]; 
        $controller=new AtmTreeTable($settings,  $data);
        return new Response(json_encode($controller->render(),200));

    } 

    public function listarByFuncionario($orc_id,$lotacao, $tipo_table){
        $data = $this->repository->listarByFuncionario($orc_id,$lotacao, $tipo_table);        
        
        $settings=["columns"=>$this->getColumnsBase(),
            "keys"=>['cargo_id','lotacao_id'],
            "filter_data"=>['parent'=>function($value){
                    return is_null($value);
            }    
            ],                                  
            "children"=>["columns"=>$this->getColumnsChildren(),
                "keys"=>['id'], 
                "filter_data"=>['parent'=>function($value){
                    return is_null($value);
                }],
                'parent_filter'=> function($value, $parent_data){                            
                        return $value['cargo_id']== $parent_data['cargo_id'] ;
                },
            ] 
        ]; 

        $controller=new AtmTreeTable($settings,  $data);
        return new Response(json_encode($controller->render(),200));

    }

    public function insert(Request $request){

        $meses = $this->dataFilterMesesCalcOrcamento($request->all());
        // dd($meses);
        $data = $this->dataFilterFerias($request->all());
        // dd('aaaaaa',$data);
       
        return $this->retornoJsonDefault($this->getRepository()->insertFerias($data,$meses));
    } 

    public function update(Request $request){        
        $meses = $this->dataFilterMesesCalcOrcamento($request->all()); 
        $data = $this->dataFilterFerias($request->all());
        $retorno = $this->getRepository()->editarFerias($request->all()['id'],$data,$meses);

        return $this->retornoJsonDefault($retorno); 
    } 
    public function delete(Request $request){  
        $form_data = $request->all();        
        $retorno = $this->getRepository()->deleteFerias($form_data);
        return  $this->retornoJsonDefault($retorno);
    } 
    public function pivo($dados){
        $meses_orcado = ['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado',
        'jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];
        $eventos_meses = [13,14,15,16];
        $retorno=[];
        $primary_key=['id','lotacao_id','orc_turma_id',];
       
        $merge_meses_evento=[];
        $meses_orcados_clear=[];        
        
        $dados_rest = [];
        foreach($dados as $key => $value){
            
            $value=(array)$value;
            $keys_values=implode("-", array_values(Arr::only($value, $primary_key)));
            $ja_foi=array_keys($retorno);
            
            if(in_array($keys_values, $ja_foi)===false){                
                $aux=Arr::except($value,$meses_orcado);   
                $retorno[$keys_values]=$aux;

            }
            foreach($meses_orcado as $j=>$w){                     
                $retorno[$keys_values][$w]=$value[$w];
            }
        }
        return $retorno;
    }

    public function getColumnsBase(){
        return $columns_base=[
            ["field_out"=>"parent", "from"=>"turma_id", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic", "render_value"=>null],
        ];     
    }
    public function getColumnsChildren(){
        return $columns_children=[
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id", "render_value"=>null],
            ["field_out"=>"cargo_id", "from"=>"cargo_id", "render_value"=>null],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null],
            ["field_out"=>"type", "from"=>"type", "render_value"=>null],
            ["field_out"=>"des_turma_basic", "from"=>"des_turma_trab", "render_value"=>function($row_data,$value,$matrix){
                return (is_null($value))? $row_data['nome_funcionario'] : $row_data['des_turma_trab'];
            }],
            ["field_out"=>"nome_funcionario", "from"=>"nome_funcionario", "render_value"=>null],

            ["field_out"=>"des_turno_basic", "from"=>"des_turno_trab", "render_value"=>null],
            ["field_out"=>"lotacao_responsavel", "from"=>"lotacao_responsavel", "render_value"=>null],
            ["field_out"=>"orc_turma_id", "from"=>"orc_turma_id", "render_value"=>null],
            ["field_out"=>"func_id", "from"=>"func_id", "render_value"=>null],
            ["field_out"=>"parent","from"=>"parent","render_value"=>null],
            ["field_out"=>"jan_orcado", "from"=>"jan_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):null;
            },],
            ["field_out"=>"fev_orcado", "from"=>"fev_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):null;
            },],
            ["field_out"=>"mar_orcado", "from"=>"mar_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):null;
            },],
            ["field_out"=>"abr_orcado", "from"=>"abr_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):null;
            },],
            ["field_out"=>"mai_orcado", "from"=>"mai_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):null;
            },],
            ["field_out"=>"jun_orcado", "from"=>"jun_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):null;
            },],
            ["field_out"=>"jul_orcado", "from"=>"jul_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):null;
            },],
            ["field_out"=>"ago_orcado", "from"=>"ago_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):null;
            },],
            ["field_out"=>"set_orcado", "from"=>"set_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):null;
            },],
            ["field_out"=>"out_orcado", "from"=>"out_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):null;
            },],
            ["field_out"=>"nov_orcado", "from"=>"nov_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):null;
            },],
            ["field_out"=>"dez_orcado", "from"=>"dez_orcado", "render_value"=>function($matriz,$value){
                return (!is_null($value))? intval($value):null;
            },]
        ];
    }

    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['funcionario_id', 'orc_id','orc_turma_id','func_id' ,'lotacao_id','cargo_id','parent','id' ,'lotacao_responsavel','orcamento_id','type','des_cargo_basic','des_turma_basic','des_turno_basic','nome_funcionario','turma_or_func','ccusto_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }
    public function dataFilterFerias($data){
        $array_orcamento=['jan_orcado', 'fev_orcado', 'mar_orcado','abr_orcado','mai_orcado', 'jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado','tbl_origem','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','origem_id','id','parent','des_cargo_basic','des_cargo_basic','des_turma_basic','des_turno_basic','nome_funcionario'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

   

}
