<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcLotFuncionarioBeneficio as RepoOrcLotFuncionarioBeneficio;
use App\Modules\Natureza51\Entities\OrcLotFuncionatioBeneficio;
use Illuminate\Http\Request as Request;
use Illuminate\Http\Response;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Facades\DB;

class OrcLotFuncionarioBeneficioController extends OrcamentoController
{
    public function __construct(){
        $this->setRepository(new RepoOrcLotFuncionarioBeneficio());
        parent::__construct();
    }

    public function inserirr(Request $request, $id) {
        
        $form_data=$this->getRepositoryOrModel()->putOrcamentoIdOnData($request->all(),$id);
        //dd("scdsdc",$form_data);
        if(! $this->getRepositoryOrModel()->createOrcLotFuncionarioBeneficio($form_data)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro:301120191630';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);        
    }    

    public function list($orcamento_id){
        $form_data = [
            'orcamento_id'=> $orcamento_id
           ];
           $dados=$this->getRepositoryOrModel()->listar($form_data);
        return $this->renderTreeTableList($dados);
    } 

    public function listEvent(){
        return $this->getRepositoryOrModel()->listaEventos();
    }
    
    public function deletar(Request $request, $id) {
        
        $form_data=$request->all();
        
        if(! $this->getRepositoryOrModel()->deleteOrcLotFuncionarioBeneficio($form_data)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao deletar o registro. Erro:141220191400';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);      
        
    }

    public function updateOrcLotFuncionarioBenef(Request $request, $id) {
        
        $form_data=$request->all();
        
        if(! $this->getRepositoryOrModel()->updateOrcLotFuncionarioBeneficio($form_data)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao deletar o registro. Erro:161220191635';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);      
        
    }


    function renderTreeTableList($dados){
        
        $columns_base=[ 
            ["field_out"=>"id", "from"=>"id"],
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id"],
            ["field_out"=>"des_unid_lotac", "from"=>"des_unid_lotac"],
            ["field_out"=>"description", "from"=>"description"],
            ["field_out"=>"funcionario_id", "from"=>"funcionario_id"],
            ["field_out"=>"orc_lotacao_id", "from"=>"orc_lotacao_id"], 
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id"], 
            ["field_out"=>"orc_beneficio_id", "from"=>"orc_beneficio_id"], 
            ["field_out"=>"tipo_calc", "from"=>"tipo_calc"], 
            ["field_out"=>"vlr_movto", "from"=>"vlr_movto"], 
            ["field_out"=>"vlr_depend", "from"=>"vlr_depend"], 
            ["field_out"=>"empresa_id", "from"=>"empresa_id"], 
            ["field_out"=>"formula", "from"=>"formula"], 
            ["field_out"=>"origem_id", "from"=>"origem_id"], 
            ["field_out"=>"tbl_origem", "from"=>"tbl_origem"], 

            ["field_out"=>"event_id", "from"=>"event_id"], 
            ["field_out"=>"cdn_event", "from"=>"cdn_event"], 
            ["field_out"=>"des_event", "from"=>"des_event"], 
            ["field_out"=>"cdn_funcionario", "from"=>"cdn_funcionario"], 
            ["field_out"=>"nome_funcionario", "from"=>"nome_funcionario"], 
            ["field_out"=>"num_reg_func", "from"=>"num_reg_func"], 
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto"], 
            ["field_out"=>"des_ccusto", "from"=>"des_ccusto"], 
    
           ["field_out"=>"jan_orcado", "from"=>"jan_orcado","render_value"=>null],
           ["field_out"=>"fev_orcado", "from"=>"fev_orcado","render_value"=>null],
           ["field_out"=>"mar_orcado", "from"=>"mar_orcado","render_value"=>null],     
           ["field_out"=>"abr_orcado", "from"=>"abr_orcado","render_value"=>null], 
           ["field_out"=>"mai_orcado", "from"=>"mai_orcado","render_value"=>null],     
           ["field_out"=>"jun_orcado", "from"=>"jun_orcado","render_value"=>null],     
           ["field_out"=>"jul_orcado", "from"=>"jul_orcado","render_value"=>null],     
           ["field_out"=>"ago_orcado", "from"=>"ago_orcado","render_value"=>null],     
           ["field_out"=>"set_orcado", "from"=>"set_orcado","render_value"=>null],    
           ["field_out"=>"out_orcado", "from"=>"out_orcado","render_value"=>null],    
           ["field_out"=>"nov_orcado", "from"=>"nov_orcado","render_value"=>null],    
           ["field_out"=>"dez_orcado", "from"=>"dez_orcado","render_value"=>null]
       ];
        
        
       $settings=["columns"=>$columns_base,
               "keys"=>['id'] 
           ];    
           
       $controller=new AtmTreeTable($settings, $dados);
       
     return $controller->render();
    }
}