<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcLotacaoCargoSal as RepoOrcLotacaoCargoSal;
use Symfony\Component\HttpFoundation\Request;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Arr;

class OrcLotacaoCargoSalController extends OrcamentoController
{
     
    public function __construct(){
        $this->setRepository(new RepoOrcLotacaoCargoSal());
        parent::__construct();
    }
    public function listarAll($orc_id, $lotac_id = null){
        $result=$this->getRepository()->listAll($orc_id, $lotac_id);
      
 
        if($result===false){
            $retorno=$this->getArrayRetornoDefault();
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro: 051220191552.';
            
            return $this->retornoJsonDefault($retorno);
        }
         return new \Illuminate\Http\Response(json_encode($this->renderTreeTableList($result->toArray() )));        
    }
    public function inserirCargo(\Illuminate\Http\Request $request, $orc_id) {
 
        $form_data=$this->getRepositoryOrModel()->putOrcamentoIdOnData($request->all(),$orc_id);

        //$retorno=$this->getArrayRetornoDefault();

        if(!$this->getRepositoryOrModel()->createOrcLotCargo($form_data)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro:301120191630';
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
        
    }
    public function editar(\Illuminate\Http\Request $request, $orc_id){
        $id = $request->all()['origem_id'];
        $form_data = Arr::except($request->all(),['origem_id','_token']);
        if(!$this->getRepository()->updateOrc($form_data,$id)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao atualizar o registro. Erro:301120191630';
            goto saida;
        }
 
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";

        saida:
        return $this->retornoJsonDefault($retorno);
    } 
    public function deletar(\Illuminate\Http\Request $request, $orc_id){
        // dd("delete", $orc_id);
        $id = $request->all()['origem_id'];
        $form_data = Arr::except($request->all(),['origem_id','_token']);
        
        if(!$this->getRepository()->deleteOrc($form_data,$id)){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao deletar o registro. Erro:301120191630';
            goto saida;
        }
 
        $retorno["status"]="success";
        $retorno["msg"]="Registro deletado com sucesso!";

        saida:
        return $this->retornoJsonDefault($retorno);
    }
    

    function renderTreeTableList($dados){

         $columns_base=[ 
            ["field_out"=>"id", "from"=>"id"],
            ["field_out"=>"origem_id", "from"=>"origem_id"],
            ["field_out"=>"cargo_id", "from"=>"cargo_id"],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id"],
            ["field_out"=>"orcamento_id", "from"=>"orcamento_id"],
            ["field_out"=>"sal_base", "from"=>"sal_base", "render_value"=>function($row_data, $value){
                return number_format($value,2,',','.');
            },],
            ["field_out"=>"sal_max", "from"=>"sal_max", "render_value"=>null,],
            ["field_out"=>"sal_med", "from"=>"sal_med"],
            ["field_out"=>"sal_min", "from"=>"sal_min" ],
            ["field_out"=>"sal_menor", "from"=>"sal_menor" ],
            ["field_out"=>"sal_maior", "from"=>"sal_maior" ],
            ["field_out"=>"data_calc", "from"=>"data_calc",],     
            ["field_out"=>"des_unid_lotac", "from"=>"des_unid_lotac",],     
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic",],     

            ["field_out"=>"jan_orcado", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            }],
            ["field_out"=>"fev_orcado", "from"=>"fev_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            }],
            ["field_out"=>"mar_orcado", "from"=>"mar_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            }],     
            ["field_out"=>"abr_orcado", "from"=>"abr_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            }], 
            ["field_out"=>"mai_orcado", "from"=>"mai_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            }],     
            ["field_out"=>"jun_orcado", "from"=>"jun_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            }],     
            ["field_out"=>"jul_orcado", "from"=>"jul_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            }],     
            ["field_out"=>"ago_orcado", "from"=>"ago_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            }],     
            ["field_out"=>"set_orcado", "from"=>"set_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            }],    
            ["field_out"=>"out_orcado", "from"=>"out_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            }],    
            ["field_out"=>"nov_orcado", "from"=>"nov_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            }],    
            ["field_out"=>"dez_orcado", "from"=>"dez_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
            }]
        ];
         
         
        $settings=["columns"=>$columns_base,
                "keys"=>['id' ] 
            ];    
            
        $controller=new AtmTreeTable($settings, $dados);
        
      return $controller->render();
    }
}
 