<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcLotacao as RepoOrcLotacao;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcLotacaoNaturezaEvento;
use Illuminate\Http\Request as Request;
use Illuminate\Http\Response;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Support\Facades\DB;

class OrcLotacaoController extends OrcamentoController
{
    public function __construct(){
        $this->setRepository(new RepoOrcLotacao());
        parent::__construct();
    }

    public function listarLot($orc_id){
        return $this->getRepositoryOrModel()->listar($orc_id);
    } 
    // public function listarLot($orc_id){
    //     return $this->getRepositoryOrModel()->listarLotAtiva($orc_id);
    // }
    /**
     * Enviar para o RH aprovar  
     */
    public function sendRh($orc_id,Request $request){
        $a = $this->getRepository()->sendRh($request->all()[0]);
        if($a['status']=='error'){
            return $this->retornoJsonDefault($a,500);
        }
        return $a;
    }

    /**
     * 
     */
    

}