<?php
namespace App\Modules\Natureza51\Http\Controllers;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoOrcPromocao as RepoOrcPromocao;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento as RepoCalcOrcamento;
use App\Support\TreeTable\AtmTreeTable;
use DB;
use Illuminate\Http\Request as Request;

class OrcPromocaoController extends OrcamentoController
{
    
   public function __construct(){
        parent::__construct();
        $this->repository=new RepoOrcPromocao();
    }  
    public function listar(){
        return $this->getRepository()->listar();
    }
    public function listarByLotacao($orc_id,$lotacao_id,$tipo_table){
        //dd($this->montaTreetable($this->getRepository()->listarByLotacao($orc_id,$lotacao_id,$tipo_table)));
        //dd("asdda",$orc_id,$lotacao_id,$tipo_table);
        return $this->montaTreetable($this->getRepository()->listarByLotacao($orc_id,$lotacao_id,$tipo_table));
    }
    public function insert(Request $request){

        $form_data = $request->all();
        // dd("aquiiiiiiiii", $form_data);
        $meses = $this->dataFilterMesesCalcOrcamento($form_data);
        $data = $this->dataFilterPromocao($form_data);
        
       
 

        $retorno = $this->getRepository()->insertPromocao($data,$meses);
        
        return $this->retornoJsonDefault($retorno);
    }
    public function update(Request $request){  

        $form_data = $request->all();        
        $id=$form_data['id'];
        $meses = $this->dataFilterMesesCalcOrcamento($form_data); 
        $data = $this->dataFilterPromocao($form_data);
        $meses = convertDecimalEn($meses);
        //dd($data);
        DB::beginTransaction();
        try {
        
        if($form_data['mes_promocao']>12 or $form_data['mes_promocao']<1){
            $retorno["status"]="warning";
            $retorno['submsg'] = 'Erro';
            $retorno['msg']='Digite números de 1 a 12(Janeiro a Dezembro)';
            goto saida;  
        }

        if(!$this->getRepository()->update($data, ['id'=>$id])){                  
            $retorno["status"]="error";
            $retorno['msg'] = $this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer update do registro. Erro: 271120191601';
            goto saida;               
        }
    } catch (\Exception $e) {
        DB::rollBack();
        abort(500,'Falha ao deletar registro no orçamento. Erro: 021220181942.'.$e);
     }
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        saida:       
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();    

        return $this->retornoJsonDefault($retorno); 

    } 
    public function delete(Request $request){  
        $form_data = $request->all();        
        $retorno = $this->getRepository()->deletePromocao($form_data['id']);
        return $this->retornoJsonDefault($retorno); 
    } 
    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['ccusto_id','cargo_promovido_id','turma_promovida_id','turma_atual_id','cargo_atual_id','cargo_id','lotacao_id','des_cargo_basic','field','funcionario_id', 'orc_id', 'lotacao_ancestral_id','lotacao_corrente_id','cargo_ancestral_id', 'cargo_corrente_id','table','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','id','origem_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }
    public function dataFilterPromocao($data){
        $array_orcamento=['field','table','des_cargo_basic','jan_orcado','cargo_id', 'fev_orcado', 'mar_orcado','abr_orcado','mai_orcado', 'jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado','tbl_origem','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','origem_id','id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

    public function montaTreetable($data){
       // dd("cvxcv",$data);
        $column_fixeds=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_promovido_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            
           

        ];

        $column_fixeds_children=[ 
            ["field_out"=>"id", "from"=>"id", "render_value"=>null,],
            ["field_out"=>"orc_id", "from"=>"orc_id", "render_value"=>null,],
            ["field_out"=>"lotacao_id", "from"=>"lotacao_id", "render_value"=>null,],
            ["field_out"=>"cargo_id", "from"=>"cargo_promovido_id", "render_value"=>null,],
            ["field_out"=>"cargo_promovido_id", "from"=>"cargo_promovido_id", "render_value"=>null,],
            ["field_out"=>"cargo_atual_id", "from"=>"cargo_atual_id", "render_value"=>null,],  
            ["field_out"=>"turma_atual_id", "from"=>"turma_atual_id", "render_value"=>null,],
            ["field_out"=>"turma_promovida_id", "from"=>"turma_promovida_id", "render_value"=>null,],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id", "render_value"=>null,],
           
            ["field_out"=>"funcionario_id", "from"=>"funcionario_id", "render_value"=>null,],
            ["field_out"=>"nome_funcionario","from"=>'nome_funcionario',"render_value"=>null],    
            ["field_out"=>"mes_promocao", "from"=>"mes_promocao", "render_value"=>null,]
            
        ];

        // $columns_base=array_merge($column_fixeds, $col_meses_parent); 
        // $columns_children=array_merge($column_fixeds_children, $col_set_meses); 

        
        $settings=["columns"=>$column_fixeds,
            "keys"=>['cargo_promovido_id'],
            // "filter_data"=>['parent_id'=>function($value){
            //         return is_null($value);
            //     }    
            // ],            
            "children"=>["columns"=>$column_fixeds_children,
                    "keys"=>['id', 'cargo_promovido_id'],
                    "filter_data"=>['cargo_promovido_id'=>function($value){
                        return !is_null($value);
                    }],
                    'parent_filter'=> function($value, $parent_data){ 
                        
                            $result=($value['cargo_promovido_id']== $parent_data['cargo_promovido_id']);
                            return $result;
                    },
                    // "children"=>["is_recursive"=>true]

                ]
            ];
                 
        $controller=new AtmTreeTable($settings, $data);
        // dd("treetable",['data'=>$controller->render()] );
        return ['data'=>$controller->render()]; 
        
    }





} 
