<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Entities\OrcSalarioFuncionario;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Support\TreeTable\AtmTreeTable;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento as RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcSalarioFuncionario as RepoOrcSalarioFuncionario;


class OrcSalarioFuncionarioController extends Natureza51Ctrl
{
    use \App\Core\Traits\ErrorTrait;

    public function __construct(){
        parent::__construct();
        $this->repository=new RepoOrcSalarioFuncionario();
    }  

    public function listarAll($orc_id){
        $tb_orc_salario_funcionario = new OrcSalarioFuncionario();        
        $tb_calc_orcamento = new CalcOrcamento();
        $tb_cargo = new Cargo();
        $tb_centro_custo = new CentroCusto();
        $tb_orc_cargo = new OrcCargo();
        $tb_funcionario = new Funcionario(); 

        $data = $tb_orc_salario_funcionario->Join($tb_calc_orcamento->getTable(), $tb_orc_salario_funcionario->getColunaAlias('id'), '=', 
                                DB::raw("{$tb_calc_orcamento->getColunaAlias('origem_id')} and 
                                {$tb_calc_orcamento->getColunaAlias('tbl_origem')} = '{$tb_orc_salario_funcionario->getTable()}'"))
                            ->join($tb_orc_cargo->getTable(),
                                $tb_orc_salario_funcionario->getColunaAlias('orc_cargo_id'), $tb_orc_cargo->getColunaAlias('id'))    
                            ->join($tb_funcionario->getTable(),
                                $tb_orc_salario_funcionario->getColunaAlias('funcionario_id'), $tb_funcionario->getColunaAlias('id')) 
                            ->join($tb_cargo->getTable(),
                                $tb_orc_cargo->getColunaAlias('cargo_id'), $tb_cargo->getColunaAlias('id'))  
                            ->join($tb_centro_custo->getTable(),
                                $tb_funcionario->getColunaAlias('ccusto_id'), $tb_centro_custo->getColunaAlias('id'))  
                                ->select(
                                    DB::raw("{$tb_orc_salario_funcionario->getColunaAlias('id')} 'orc_sal_func_id'"),
                                    DB::raw("{$tb_calc_orcamento->getColunaAlias('id')} 'calc_orcamento_id'"),
                                    $tb_orc_salario_funcionario->getColunaAlias('orc_id'),
                                    $tb_centro_custo->getColunaAlias('cod_ccusto'),
                                    $tb_centro_custo->getColunaAlias('des_ccusto'),
                                    $tb_funcionario->getColunaAlias('ccusto_id'),
                                    $tb_cargo->getColunaAlias('cod_cargo_basic'),
                                    $tb_cargo->getColunaAlias('des_cargo_basic'),
                                    $tb_orc_cargo->getColunaAlias('cargo_id'),
                                    $tb_funcionario->getColunaAlias('cdn_funcionario'),
                                    $tb_funcionario->getColunaAlias('nome_funcionario'),
                                    $tb_funcionario->getColunaAlias('salario'),
                                    $tb_funcionario->getColunaAlias('orc_cargo_id'),

                                    $tb_orc_salario_funcionario->getColunaAlias('funcionario_id'),
                                    $tb_calc_orcamento->getColunaAlias('jan_orcado'),                                    
                                    $tb_calc_orcamento->getColunaAlias('fev_orcado'),                                     
                                    $tb_calc_orcamento->getColunaAlias('mar_orcado'),                                    
                                    $tb_calc_orcamento->getColunaAlias('abr_orcado'),                                    
                                    $tb_calc_orcamento->getColunaAlias('mai_orcado'),
                                    $tb_calc_orcamento->getColunaAlias('jun_orcado'), 
                                    $tb_calc_orcamento->getColunaAlias('jul_orcado'), 
                                    $tb_calc_orcamento->getColunaAlias('ago_orcado'),
                                    $tb_calc_orcamento->getColunaAlias('set_orcado'), 
                                    $tb_calc_orcamento->getColunaAlias('out_orcado'),
                                    $tb_calc_orcamento->getColunaAlias('nov_orcado'), 
                                    $tb_calc_orcamento->getColunaAlias('dez_orcado')
                                )
                                ->where($tb_orc_salario_funcionario->getColunaAlias('orc_id'),$orc_id)
                                ->get()
                                ->toArray();
                                
                                return json_encode($this->renderTreeTableList($data));

    }

    function renderTreeTableList($dados){

        $columns_base=[ 
            ["field_out"=>"orc_sal_func_id", "from"=>"orc_sal_func_id"],
            ["field_out"=>"calc_orcamento_id", "from"=>"calc_orcamento_id"],
            ["field_out"=>"cod_ccusto", "from"=>"cod_ccusto"],
            ["field_out"=>"des_ccusto", "from"=>"des_ccusto"],
            ["field_out"=>"ccusto_id", "from"=>"ccusto_id"],
            ["field_out"=>"cod_cargo_basic", "from"=>"cod_cargo_basic"],
            ["field_out"=>"cargo_id", "from"=>"cargo_id"],
            ["field_out"=>"des_cargo_basic", "from"=>"des_cargo_basic"],
            ["field_out"=>"orc_id", "from"=>"orc_id"],
            ["field_out"=>"cdn_funcionario", "from"=>"cdn_funcionario"],
            ["field_out"=>"nome_funcionario", "from"=>"nome_funcionario"],
            ["field_out"=>"salario", "from"=>"salario","render_value"=>function($row_data, $value){
                return number_format($value,2,'.', '');
            }],
            ["field_out"=>"orc_cargo_id", "from"=>"orc_cargo_id"],

           ["field_out"=>"funcionario_id", "from"=>"funcionario_id"],
           ["field_out"=>"jan_orcado", "from"=>"jan_orcado","render_value"=>function($row_data, $value){
            return number_format($value,2,',', '.');
           }],
           ["field_out"=>"fev_orcado", "from"=>"fev_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],
           ["field_out"=>"mar_orcado", "from"=>"mar_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],     
           ["field_out"=>"abr_orcado", "from"=>"abr_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }], 
           ["field_out"=>"mai_orcado", "from"=>"mai_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],     
           ["field_out"=>"jun_orcado", "from"=>"jun_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],     
           ["field_out"=>"jul_orcado", "from"=>"jul_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],     
           ["field_out"=>"ago_orcado", "from"=>"ago_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],     
           ["field_out"=>"set_orcado", "from"=>"set_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],    
           ["field_out"=>"out_orcado", "from"=>"out_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],    
           ["field_out"=>"nov_orcado", "from"=>"nov_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }],    
           ["field_out"=>"dez_orcado", "from"=>"dez_orcado","render_value"=>function($row_data, $value){
                return number_format($value,2,',', '.');
           }]
       ];
        
        
       $settings=["columns"=>$columns_base,
               "keys"=>['orc_sal_func_id' ] 
           ];    
           
       $controller=new AtmTreeTable($settings, $dados);
       
        return $controller->render();
   }

    public function insert(Request $request){
        $repo_calc_orcamento=new RepoCalcOrcamento();
        $orc_sal_func = new OrcSalarioFuncionario();

        $form_data=$request->all();
        $where = [
            ['orc_id',$form_data['orc_id']],
            ['funcionario_id',$form_data['funcionario_id']],
            ['orc_cargo_id',$form_data['orc_cargo_id']]
        ];
        $select = $this->getRepository()->getModelEntity()->where($where)->get()->toArray();
        //dd($select);
        if(!empty($select)){
            $retorno['status']='error';
            $retorno['msg']='Registro já cadastrado. Erro: 260220201157.';
            goto saida;
        }

        $id_orc_sal_func = $this->getRepository()->create($form_data);
        if(! $id_orc_sal_func){
            $retorno['msg']=$this->getRepository()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro: 220820191723';
            goto saida;
        }

        $meses_calc_orcamento = $this->dataFilterMesesCalcOrcamento($form_data); 
        
        $merge_tb_calc = [
            'origem_id' => $id_orc_sal_func->id,
            'tbl_origem' => $orc_sal_func->getTable()
        ];
        //$meses_calc_orcamento=convertDecimalEn($meses_calc_orcamento);
        //dd($meses_calc_orcamento);
        if(! $repo_calc_orcamento->create(array_merge($merge_tb_calc, $meses_calc_orcamento))){
            $retorno['msg']='Falha ao inserir o registro. Erro: 220820191723';
            $retorno['submsg']=$repo_calc_orcamento->getErrosFlatted();
            goto saida;
        }
        
        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);
    }

    public function update(Request $request){  
        
        $repo_calc_orcamento=new RepoCalcOrcamento();
        $retorno=$this->getArrayRetornoDefault();
        $this->clearError();

        $form_data = $request->all();        
        
        $id=$form_data['calc_orcamento_id'];
        
        $meses_calc_orcamento = $this->dataFilterMesesCalcOrcamento($form_data); 
        $meses_calc_orcamento = convertDecimalEn($meses_calc_orcamento);
        
        if(! $repo_calc_orcamento->update($meses_calc_orcamento, $id)){                  
                $retorno["status"]="error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer update do registro. Erro: 271120191600';
                goto saida;               
        } 
        
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";
        saida:       
     
        return $this->retornoJsonDefault($retorno); 
    } 
    
    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['funcionario_id', 'orc_cargo_id', 'lotacao_responsavel_id','funcionario_id','salario', 'nome_funcionario', 'cdn_funcionario', 'cargo_id', 
        'des_cargo_basic', 'cod_cargo_basic' ,'ccusto_id', 'des_ccusto', 'cod_ccusto', 'orc_sal_func_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

    public function dataFilterSalarioFuncionario($data){
        $array_orcamento=['funcionario_id','salario', 'nome_funcionario', 'cdn_funcionario', 'cargo_id', 
        'des_cargo_basic', 'cod_cargo_basic' ,'ccusto_id', 'des_ccusto', 'cod_ccusto', 'orc_sal_func_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
        //fhjfghdfgdfgdf ddddddddd
        //dd("dataUpdate", $filtered);
        return $filtered;
    }

    public function deleteAll(Request $request){
        $data = $request->all(); 
        $repo_calc_orcamento = new RepoCalcOrcamento();
        $retorno=$this->getArrayRetornoDefault();
        DB::beginTransaction();

        try {
            $orc_sal = $this->getRepository()->findBy('id',$data['orc_sal_func_id']);
           
            if(!$orc_sal->delete()){
                $retorno['msg']='Falha ao deletar o registro. Erro: 260220201039.';
                $retorno['status']='error';
                goto saida;
            }

            $calc_orc = $repo_calc_orcamento->findBy('id',$data['calc_orcamento_id']);
            if(!$calc_orc->delete()){
                $retorno['msg']='Falha ao deletar o registro. Erro: 260220201041.';
                $retorno['status']='error';
                goto saida;
            }
            $retorno['status']='success';
            $retorno['msg']='Registro deletado com sucesso!';
            
            DB::commit();  
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Erro ao deletar registro. Erro: 260220201030.');
        }
        saida:
        return $retorno;

    }
}