<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcTurma as RepoOrcTurma;
use Illuminate\Http\Request;

class OrcTurmaController extends OrcamentoController {

     public function __construct(){
        $this->repository=new RepoOrcTurma();
        parent::__construct();
    }

    public function listOrcTurma($orc_id){        
        return $this->getRepository()->listOrcTurma($orc_id);
    }

    public function listOrcGroupTurma($orc_id){             
        return $this->getRepository()->listOrcGroupTurma($orc_id);
    }

    public function inserirOrcTurma(Request $request,$orc_id){
        $data_insert = [];
        $request_data=$request->all();
        // dd($request_data);
        foreach($request_data['items'] as $key => $data){
            $array_turma_id[$key]=$data['id'];
            $data_insert[$key]=[
                'turma_id'=>$data['id'],
                'orc_id'=>$orc_id,
                'des_turma_trab' =>$data['des_turma_trab'],
                'cdn_turma_trab' =>$data['cdn_turma_trab'],
                'turno_id' =>$data['turno_id'],
                'evento_adc_id' =>$data['evento_adc_id'],
                'evento_ext_id' =>$data['evento_ext_id'],
                // 'user_id' =>$data['user_id'],
                'adic_noturno' =>$data['adic_noturno'],
                'extra_noturno' =>$data['extra_noturno'],
                // 'ativo' =>$data['ativo'],
                // 'origem' =>$data['origem'],
                // 'des_turno_trab' =>$data['des_turno_trab']
            ];            
        }

        $array_data = collect($data_insert);
        
        $ja_existe=$this->getRepositoryOrModel()->getModelEntity()
        ->select("turma_id")
        ->where('orc_id',$orc_id)
        ->whereIn('turma_id', $array_turma_id)
        ->get()
        ->pluck("turma_id")->toArray();

        $insert_data = $array_data->filter( function ($item) use($ja_existe) {                       
            return !in_array($item['turma_id'], $ja_existe)  ;
        });
        
		if($insert_data->count() - count($ja_existe) == 0){
            
			$retorno["status"]="error";
			$retorno["msg"]='A opção selecionada já existe.';
			$retorno['submsg']='Falha ao inserir. Erro 240220202004';
			goto saida;
		} 
        
        $orcamento=$this->getRepositoryOrModel()->getOrcInstanceNew()->find($orc_id);
        
		if($this->getRepositoryOrModel()->setOrcamento($orcamento)->canEdit()==false){//Se o usuario não tiver a pemissão
			$retorno["status"]="error";
			$retorno["msg"]='Não é possível cadastrar esta Hora Extra pois o mesmo não permite.';
			$retorno['submsg']='Falha ao inserir. Erro 240220202006';
			goto saida;
        }
        // $array_orcamento=['id', 'display', 'value'];
        
        // $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] )); 
        
        foreach($insert_data as $data){
            // dd("insert orc", $data);
            if(!$this->getRepositoryOrModel()->create($data)){
                $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro:111220191024';
                goto saida;
            }
        }

        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $this->retornoJsonDefault($retorno);  
        
    } 

	public function deletar(Request $request, $orc_id){
    	
        $request_data=$request->all();

        foreach($request_data['items'] as $key => $data){
            $array_turma_id[$key]=$data['id'];                       
        }    	

  		$delete=$this->getRepository()->getModelEntity()->where('orc_id',$orc_id)->whereIn('turma_id',$array_turma_id)->delete();

		  if(!$delete){
			$retorno['status']='error';
			$retorno['msg']='Falha ao deletar o registro. Erro: 240220202028.';
			goto saida;
		  }

		  $retorno['status']='success';
		  $retorno['msg']='Registro deletado com sucesso!';

		saida:  
    	return $retorno;   

    }
    
}