<?php

namespace App\Modules\Natureza51\Http\Controllers;

use App\Modules\Natureza51\Repositories\RepoOrcamento as RepoOrcamento;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Modules\Natureza51\Repositories\RepoCargoAreaSal;
use App\Modules\Natureza51\Repositories\RepoHoraExtra;
use App\Modules\Natureza51\Repositories\RepoLotacao;
use App\Modules\Natureza51\Repositories\RepoOrcBeneficio;
use App\Modules\Natureza51\Repositories\RepoOrcBonus;
use App\Modules\Natureza51\Repositories\RepoOrcCargo;
use App\Modules\Natureza51\Repositories\RepoOrcLotacaoNaturezaEvento;
use App\Modules\Natureza51\Repositories\RepoOrcHoraExtra;
use App\Modules\Natureza51\Repositories\RepoOrcInsertForecast;
use App\Modules\Natureza51\Repositories\RepoOrcLotacao;

class OrcamentoController extends Natureza51Ctrl  
{
    protected $repository_orc;
    private function setRepositoryOrc(){
        $this->repository_orc=new RepoOrcamento();
        return $this;
    } 
    public function __construct(){
        $this->setRepositoryOrc();
        
        parent::__construct();
        
        if(!$this->hasRepository()){
            $this->setRepository($this->getRepositoryOrc());
        }
    }

    public function listar(){
        return $this->getRepository()->getModelEntity()
           ->where([
                ['status_orc', '!=', $this->getRepository()->getStatusExcluido()]
            ])
            ->get()->toArray();
    }

    public function listForHeadcount(){
       return $this->getRepository()->getModelEntity()
    //    ->where([
    //         ['status_aprovacao',$this->getRepository()->getStatusFinal()],
    //         ['status_orc',$this->getRepository()->getStatusLiberado()]
    //     ])
        ->get()->toArray();
    }
    public function getRepositoryOrc(){ return $this->repository_orc; }
    public function isValid(){
        return true;
    }
    public function canEdit(){
        return true;
    }
    public function canDelete(){
        return true;
    }

    public function getOrcamentoByID($orc_id){
        $orc = $this->getRepository()->getModelEntity()::with([
            'getOrcPremissas'=>function($query){
                
            } 
        ])->find($orc_id);
        if(!$orc){
            return "Registro não encontrado. 061220190943";
        }
        return $orc;
    }
    public function isOwn(){
        return true;
    }
    public function inserir(Request $request) {
      
       $retorno=$this->getArrayRetornoDefault();
        if(! $this->getRepositoryOrModel()->createOrc($request->all())){
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao inserir o registro. Erro:301120191345';
            goto saida;
        }
        
        $retorno["status"]="success"; 
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
         return $this->retornoJsonDefault($retorno);
         
    }

    /**
     * ======================= VERIFICAR AS VALIDAÇÕES DOS STATUS E O FLUXO ==================================
     * @author Samuel Domingos de Lima
     * @todo Function for to release budget. Check the commented validations in the future.
     */
    public function releaseOrc(Request $request){
        $id_orc = $request->all()[0];
       
        $cargo_sal = new RepoOrcCargo();
        $beneficio = new RepoOrcBeneficio();
        $bonus = new RepoOrcBonus();
        $lot_nat_event = new RepoOrcLotacaoNaturezaEvento();
        $hora_extra = new RepoHoraExtra();
        
        if(!$orc = $this->getRepository()->find($id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento inexistente. Tente novamente mais tarde. Erro: 280120201027'));
        }
        if($orc->status_orc != $this->getRepository()->getStatusPendente()){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Operação indisponível. Erro: 280120200930.'),500);
        }

        if($orc->status_aprovacao != $this->getRepository()->getStatusPendente()){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Operação indisponível. Erro: 280120200931.'),500);
        }

        if(!$cargo_sal->findBy('orcamento_id',$id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Preencha os parâmetros do orçamento, cargos e salários inexistentes. Erro: 280120200942.'),500);
        }
        
        if(!$beneficio->findBy('orcamento_id',$id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Preencha os parâmetros do orçamento. Benefícios inexistentes. Erro: 280120200947.'),500);
        }
        /*if(!$bonus->findBy('orc_id',$id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Preencha os parâmetros do orçamento. Bonus inexistentes. Erro: 103528012020.'),500);
        }*/
        /*if(!$lot_nat_event->findBy('orcamento_id',$id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Preencha os parâmetros do orçamento. Lotação x Natureza x Eventos inexistentes. Erro: 280120200948.'),500);
        }*/
        if(!$hora_extra->findBy('orcamento_id',$id_orc)){
            return $this->retornoJsonDefault(array('error','msg'=>'Preencha os parâmetros do orçamento. Horas extras inexistentes. Erro: 280120201037.'),500);
        }
        
        return $this->getRepository()->releasedStatus($id_orc,$this->getRepository()->getModelNameSpace(),'status_orc');

    }

    /**
     * MÉTODO INUTILIZAVÉL NO MOMENTO 19/02/2019
     */
    public function approveOrc(Request $request){
        $id_orc = $request->all()[0];
        
        
        if(!$orc = $this->getRepository()->find($id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento inexistente. Tente novamente mais tarde. Erro: 280120201840'));
        }
        // if($orc->status_orc != $this->getRepository()->getStatusEmAndamento()){
        //     return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Operação indisponível. Erro: 280120201841.'),500);
        // }
        if(!$this->headcountIsFinished($id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Para aprovar o orçamento, todas as lotações devem estar finalizadas. Erro: 290120200853.'));
        }

        return $this->getRepository()->completedStatus($id_orc,$this->getRepository()->getModelNameSpace(),'status_orc');
    }

    public function reopenOrc(Request $request){
        $id_orc = $request->all()[0];
        
        if(!$orc = $this->getRepository()->find($id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento inexistente. Tente novamente mais tarde. Erro: 280120201840'));
        }

        if(!$this->headcountIsFinished($id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Para reabrir o orçamento, todas as lotações devem estar finalizadas. Erro: 2900120201625.'));
        }

        return $this->getRepository()->reopenedStatus($id_orc,$this->getRepository()->getModelNameSpace(),'status_orc');
    }
    /**
     * Quando o ALMER REJEITAR o ORÇAMENTO
     */
    public function rejectOrc(Request $request){
        $id_orc = $request->all()[0];

        if(!$orc = $this->getRepository()->find($id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento inexistente. Tente novamente mais tarde. Erro: 060220200928.'));
        }

        if($orc->status_orc != $this->getRepository()->getStatusFinalizado()){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Operação indísponivel. Erro: 060220200928.'));
        }
        
        $retorno = $this->getRepository()->completedStatus($id_orc,$this->getRepository()->getModelNameSpace(),'status_aprovacao');

        $retorno = $this->getRepository()->rejectStatus($id_orc,$this->getRepository()->getModelNameSpace(),'status_orc');

        return $retorno;
    }

    public function excluirOrc(Request $request){
        $all = $request->all();
        
        if(!$orc = $this->getRepository()->find($all)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento inexistente. Tente novamente mais tarde. Erro: 110320201046.'));
        }
        
        if($orc[0]->status_orc != $this->getRepository()->getStatusPendente()){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Operação indísponivel. Erro: 110320201047.'));
        }
        
        DB::beginTransaction();
        try {

            $data_request = [
                "status_orc" => $this->getRepository()->getStatusExcluido()
            ];
            
            $resp = $this->getRepository()->updateParent($data_request, $all[0]);
            if(!$resp){                                     
                abort(500,'Erro ao excluir o orçamento. Erro: 110320201103. '. $e);
            }

        DB::commit();

        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Erro ao excluir o orçamento. Erro: 110320201103. '. $e);
        }
       
        $retorno["status"]="success";
        $retorno["msg"]="Registro atualizado com sucesso!";

        return $retorno;        
    }

    /**
     * Quando o ALMER APROVAR O ORÇAMENTO
     */
    public function acceptOrc(Request $request){
        $id_orc = $request->all()[0];
        $insert_orc_forecast = new RepoOrcInsertForecast();

        if(!$orc = $this->getRepository()->find($id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Orçamento inexistente. Tente novamente mais tarde. Erro: 060220200928.'));
        }


        if(!$this->headcountIsFinished($id_orc)){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Para aprovar o orçamento, todas as lotações devem estar finalizadas. Erro: 180220201203.'));
        }

        if($orc->status_orc != $this->getRepository()->getStatusLiberado()){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Operação indísponivel. Erro: 180220201206.'));
        }

        DB::beginTransaction();
        try {
            $retorno = $this->getRepository()->approvedStatus($id_orc,$this->getRepository()->getModelNameSpace(),'status_orc');
            if($retorno['status']!='success'){
                return false;
            }

            $retorno2 = $this->getRepository()->completedStatus($id_orc,$this->getRepository()->getModelNameSpace(),'status_aprovacao');
            if($retorno2['status']!='success'){
                return false;
            } 
            
            $insrt_forecast = $insert_orc_forecast->createForecast($id_orc);
            
            if($insrt_forecast['status'] != 'success'){
                return false;
            }

            DB::commit();

        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Erro ao liberar o orçamento. Erro: 190220201749. '. $e);
        }
        

        return $retorno;
    }  
    public function headcountIsFinished($id_orc){
        $repo_lotacao = new RepoOrcLotacao();
        $lot_p = $repo_lotacao->getModelEntity();
        $lot = $lot_p->where('orcamento_id',$id_orc)->count();
        $lot2 = $lot_p->where([
            ['orcamento_id',$id_orc],
            ['status',$this->getRepository()->getStatusFinalizado()]
        ]
        )->count();

        if($lot != $lot2){
            return false;
        }
        return true;
    }

    public function suspendedOrc(Request $request){
        $all = $request->all();
        // dd($all);
        if(!$orc = $this->getRepository()->find($all['id'])){
            return $this->retornoJsonDefault(array('status'=>'error','msg'=>'Operação indisponível. Erro: 290120201020.'),500);
        }

        $orc->is_suspended = $all['is_suspended'];
        $orc->update();

        return $this->retornoJsonDefault(array('status'=>'success','msg'=>'Orçamento suspenso com sucesso.'),200);
        
    }

    public function getEventOfHour(){
        return $this->repository_orc->getEventsOfHour();
    }
    /*
     * @TODO ALUISIO FERREIRA DE SOUSA 16/12/2019
     * Tentativa de criar um metodo generico para listar os dados das abas do orcamento mas é necessario 
     * Mais estudo
     * 
    public function listarAll($orc_id){
        $result=$this->getRepository()->listAll($orc_id);
        if($result===false){
            $retorno=$this->getArrayRetornoDefault();
            $retorno['msg']=$this->getRepositoryOrModel()->getErrosFlatted();
            $retorno['submsg']='Falha ao carregar registros. Erro: 051220190952.';
            
            return $this->retornoJsonDefault($retorno);
        }
        return new Response(json_encode($this->renderTreeTable($result->toArray() )));
    }
    protected function renderTreeTable($dados){
        
        return ['data'=>$this->setTreeTableSetting(['columns'=>[
                    ["field_out"=>"id"],
                    ["field_out"=>"orcamento_id"],
                    ["field_out"=>"lotacao_id"],
                    ["field_out"=>"ccontabil_id"],
                    ["field_out"=>"evento_id"],
                    ["field_out"=>"total"],
                    ["field_out"=>"formula"],
                    ["field_out"=>"ccontabil"], //'C. Contabíl' 
                    ["field_out"=>"codigo"], //C. Custo'
                    ["field_out"=>"lotacao"], //Lotação'
                    ["field_out"=>"jan_orcado"],
                    ["field_out"=>"fev_orcado"],
                    ["field_out"=>"mar_orcado"],
                    ["field_out"=>"abr_orcado"],
                    ["field_out"=>"mai_orcado"],
                    ["field_out"=>"jun_orcado"],
                    ["field_out"=>"jul_orcado"],
                    ["field_out"=>"ago_orcado"],
                    ["field_out"=>"set_orcado"],
                    ["field_out"=>"out_orcado"],
                    ["field_out"=>"nov_orcado"],
                    ["field_out"=>"dez_orcado"],
                    ],
                'keys'=>'id',
                
            ])
              ->newTreeTable($dados)
              ->getTreeTable() 
              ->render()]; 
    }
    */
}
