<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;

class RepoBeneficio extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\Beneficio';

   protected $form_rules=[   
                           'evento_id'=>'required|unique:tbl_beneficio,evento_id',
                           'vlr_movto'=>'required',
                           'vlr_depend'=>'required',
                         ];

    protected $rules_msg=[
                          'evento_id.required'=>'O campo Evento é obrigatório',
                          'evento_id.unique'=>'Evento já foi cadastrado',
                          'vlr_movto.required'=>'O campo Valor Movimento é obrigatório',
                          'vlr_depend.required'=>'O campo Valor por Dependente. é obrigatório'
                        ];  

    public function update(array $data,$id,$attribute="id"){

        $this->form_rules['evento_id'].=','.$id;
        return parent::update($data,$id,$attribute);
                      
    }
    public function listar(){
      $a=$this->allWith([
        'getEvento'=>function($query){
        }
      ])->toArray();

      for($i=0;$i<count($a);$i++){
        $a[$i]['des_event']=$a[$i]['get_evento']['des_event'];
        $a[$i]['description']=$a[$i]['evento_id'].' - '.$a[$i]['get_evento']['des_event'];
        unset($a[$i]['get_evento']);
      }
      
      return $a;
      
    }
}

