<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\Cargo;
use DB;
class RepoCargo extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\Cargo'; 
    protected $form_rules=[
                           
                           'cod_cargo_basic'=>'required | unique:tbl_cargo,cod_cargo_basic',
                           'des_cargo_basic'=>'required|string|max:40|min:1',
                           'salario'=>'required',
                           'salario_medio'=>'required', 
                           'salario_min'=>'required', 
                           'salario_max'=>'required'

                         ];
    protected $rules_msg=[
                          'des_cargo_basic.required'=>'O campo Descrição Cargo é obrigatório',
                          'des_cargo_basic.max'=>'O campo nome aceita até 40 caracteres',
                          'cod_cargo_basic.required'=>'O campo Código Cargo é obrigatório',
                          'cod_cargo_basic.unique'=>'Cód. Cargo já cadastrado',
                          'salario.required'=>'O campo nome é obrigatório',
                          'salario_medio'=>'O campo salário médio é obrigatório',
                          'salario_min'=>'O campo salário médio é obrigatório', 
                          'salario_max'=>'O campo salário máximo é obrigatório'
                        ];  

  public function getCargoByGrade($grades){

    return Cargo::select(DB::raw('LEFT(cod_cargo_basic, 2) as grade_salarial, id+null as parent'),'cod_cargo_basic','des_cargo_basic','salario','id')->where(function ($query) use($grades) {
      for ($i = 0; $i < count($grades)-1; $i++){
         $query->orwhere('cod_cargo_basic', 'like',  $grades[$i].'%');
      }      
    })->get()->toArray();
  }
  public function listarCargos(){
    $data = $this->getModelEntity()->select()->get()->toArray();
    for($i=0;$i<count($data);$i++){
      
      $dados[$i]=array_merge($data[$i],array("description"=>$data[$i]['cod_cargo_basic'].' - '.$data[$i]['des_cargo_basic']));

    }
    return $dados;
  }
  public function update(array $data,$id,$attribute="id"){

    $this->form_rules['cod_cargo_basic'].=','.$id;
    return parent::update($data,$id,$attribute);

  }
  

}
