<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\CcustoLotacao;

class RepoCcustoLotacao extends RepositoryNat51{
    protected $model_name_space='App\Modules\Natureza51\Entities\CcustoLotacao';
    protected $form_rules=[
        'lotacao_id'=>'required',
        'ccusto_id'=>'required'
    ];
    protected $rules_msg=[
        'lotacao_id.required'=>'O campo Lotação é obrigatório',
        'ccusto_id.required'=>'O campo C. Custo é obrigatório'
    ];
    public function listar(){
        $a=$this->allWith([
            'getLotacao'=>function($query){},
            'getCcusto'=>function($query){}
        ])
        ->toArray();
        for($i=0;$i<count($a);$i++){
            $a[$i]['des_unid_lotac']=$a[$i]['get_lotacao']['des_unid_lotac'];
            $a[$i]['des_ccusto']=$a[$i]['get_ccusto']['des_ccusto'];
            unset($a[$i]['get_lotacao']);
            unset($a[$i]['get_ccusto']);
        }
        return $a;
    }
}