<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;

class RepoCentroCusto extends RepositoryNat51
{
    use \App\Core\Traits\ErrorTrait;

    protected $model_name_space='App\Modules\Natureza51\Entities\CentroCusto';

    protected $form_rules=['des_ccusto'=>'required|string|max:40|min:1',//!=bd
                           'cod_ccusto'=>'required|unique:tbl_ccusto,cod_ccusto',
                           'ativo'=>'required|int',                           
                           'dat_inic_valid' => 'required',      
                           'dat_fim_valid' => 'required'//!= bd                      
                         ];

    protected $rules_msg=['cod_ccusto.required'=>'O campo Cod. Centro Custo é obrigatório',
                          // 'cod_ccusto.max'=>'O campo cod_ccusto aceita até 40 caracteres',
                          'cod_ccusto.unique'=>'Cod. Centro Custo já cadastrado',
                          'des_ccusto.required'=>'O campo Desc. Centro Custo é obrigatório',
                          'des_ccusto.max'=>'O campo Desc. Centro Custo aceita até 40 caracteres',
                          'ativo.required'=>'O campo Ativo é obrigatório',                  
                          'dat_inic_valid.required'=>'O campo Data Inicial é obrigatório',
                          'dat_fim_valid.required'=>'O campo Data Final é obrigatório'                 
                        ]; 

    public function delete($id){
      $result =$this->getModelInstance()->find($id);
      
        if(empty($result)){
            $this->setError("Registro não localizado . error: 200920191200");
            return false;
        }

        // Validação comentada pois não há o campo na tabela de conta contabil, verificar. 10012020
        // if($result->getContaContabil()->count() > 0){
        //   $this->setError("Existe conta Contábil vinculada a este registro! Erro: 200920191200");
        //   return false;
        // }       

        return $result->delete();
    }      
    public function listarDescription(){
      $data=$this->getModelEntity()->select()->get()->toArray();
      for($i=0;$i<count($data);$i++){
        $dados[$i]=array_merge($data[$i],array("description"=>$data[$i]['cod_ccusto'].' - '.$data[$i]['des_ccusto']));
      }
  
      return $dados;
    }
    public function update(array $data,$id,$attribute="id"){

      $this->form_rules['cod_ccusto'].=','.$id;
      return parent::update($data,$id,$attribute);
  
    }              
    
}
