<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;

class RepoContaContabil extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\ContaContabil';
    protected $form_rules=[
              
              'cod_cta_ctbl'=>'required|unique:tbl_cta_contabil,cod_cta_ctbl',
              'desc_cta_ctbl'=>'required',
              'tipo_des'=>'required',
              'ccusto'=>'required',
              
    ];

     protected $rules_msg=[            
              
              'cod_cta_ctbl.required'=>'O campo código conta contábil é obrigatório',
              'cod_cta_ctbl.unique'=>'Cod. Conta já foi cadastrado',
              'desc_cta_ctbl.required'=>'O campo descrição conta contabil é obrigatório',
              'tipo_des.required'=>'O campo tipo descrição é obrigatório',
              'ccusto.required'=>'O campo centro de custo é obrigatório'
              
      ]; 
      
      public function update(array $data,$id,$attribute="id"){

        $this->form_rules['cod_cta_ctbl'].=','.$id;
        return parent::update($data,$id,$attribute);
                      
    }
}
