<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;

class RepoDepartamento extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\Departamento';
    
    protected $form_rules=['sigla_departamento'=>'required|string|max:250|min:1',
                           'descricao_departamento'=>'required|string|max:250|min:1',
                           'id_centro_custo' => 'required|exists:tbl_diretoria,id_centro_custo',
                           'id_area' => 'required|exists:tbl_area,id_area',
                           'id_diretoria' => 'required|exists:tbl_diretoria,id_diretoria',
                           'id_grupo' => 'required|exists:tbl_grupo,id_grupo',
                           'id_setor' => 'required|exists:tbl_setores,id_setor',
                           'id_empresa' => 'required|exists:tbl_empresa,cod_empresa',
                           'id_filial' => 'required|exists:tbl_filial,id_filial',
                         ];

    protected $rules_msg=['sigla_departamento.required'=>'O campo nome é obrigatório',
                          'sigla_departamento.max'=>'O campo nome aceita até 250 caracteres',
                          'descricao_departamento.required'=>'O campo nome é obrigatório',
                          'descricao_departamento.max'=>'O campo nome aceita até 250 caracteres',
                          'id_diretoria.required'=>'O campo nome é obrigatório',
                          'id_empresa.required'=>'O campo nome é obrigatório',
                          'id_filial.required'=>'O campo nome é obrigatório',
                          'id_grupo.required'=>'O campo nome é obrigatório',
                          'id_setor.required'=>'O campo nome é obrigatório',
                          'id_centro_custo.required'=>'O campo nome é obrigatório',
                          'id_area.required'=>'O campo nome é obrigatório',
                        ];  
}
