<?php
namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\Despesas;
use Illuminate\Validation\Rule;
use Illuminate\Contracts\Validation\Factory;
use Illuminate\Http\Request;
use Illuminate\Validation\Validator;

class RepoDespesas extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\Despesas';
    protected $form_rules=[
        'origem_despesa'=>'required',
        'descricao'=>'required',
        'valor_referencia'=>'required',
        // 'evento_id'=>'unique:tbl_despesas,evento_id',
        // 'cta_contabil_id'=>'unique:tbl_despesas,cta_contabil_id'
    ];
    protected $rules_msg=[
        'origem_despesa.required'=>'O campo Origem Despesa é obrigatório',
        'origem_despesa.unique'=>'Ja cadastrado',
        'descricao.required'=>'O campo Descrição é obrigatório',
        'valor_referencia'=>'O campo Valor de Referencia é obrigatório',

    ];
    public function listar(){
        $a=$this->allWith([
            'getContaContabil'=>function($query){

            },
            'getEvento'=>function($query){

            },
        ])->toArray();
            
        for($i=0; $i<count($a); $i++){
            $a[$i]['desc_cta_ctbl']=$a[$i]['get_conta_contabil']['desc_cta_ctbl'];
            $a[$i]['des_event']=$a[$i]['get_evento']['des_event'];
            unset($a[$i]['get_conta_contabil']);
            unset($a[$i]['get_evento']);
        }

        for($i=0;$i<count($a);$i++){
            if($a[$i]['origem_despesa']==1){
                $dados[$i]=array_merge($a[$i],array("description"=>$a[$i]['descricao'].' - '.$a[$i]['des_event']));
            }else{
                $dados[$i]=array_merge($a[$i],array("description"=>$a[$i]['descricao'].' - '.$a[$i]['desc_cta_ctbl']));
            }
          }
        return $dados;
    }
    public function insert(Request $request){
        $array=$request->all();
        $arrayValido=$this->validaUnique($array);

        if(!$arrayValido){
            $this->setError("Falha na retrição unique. erro: 070220201138");
            return false;
        }

        return parent::create($array);
    }
    public function update(array $data, $id, $attribute = "id")
    {
        $dadosValido=$this->validaUniqueUpdate($data);
        $referencia=array('valor_referencia'=>$data['valor_referencia']);
        $ult_array=array_merge($data,str_replace(",",".",$referencia));
        
        if(!$dadosValido){
            $this->setError("Falha na restrição unique(ja esta cadastrado). erro: 070220201131");
            return false;
        }
        
        return parent::update($ult_array,$id,$attribute);
        
    }

    protected function validaUniqueUpdate($data){
        $despesas=$this->getModelEntity();
        $dados_enviar=$despesas->select($despesas->getColunaAlias('id'),$despesas->getColunaALias('origem_despesa'),$despesas->getColunaAlias('evento_id'),$despesas->getColunaAlias('cta_contabil_id'))
        ->where([
            ['id','=',$data['id']],
            ['origem_despesa','=',$data['origem_despesa']],
            ['evento_id','=',$data['evento_id']],
            ['cta_contabil_id','=',$data['cta_contabil_id']]
            ])
        ->get();
        if($dados_enviar->count()==1 || $dados_enviar->count()==0){
            return true;
        }
        return false;
    }
    protected function validaUnique($data){
        $despesas=$this->getModelEntity();
        $dados_enviar=$despesas->select($despesas->getColunaALias('origem_despesa'),$despesas->getColunaAlias('evento_id'),$despesas->getColunaAlias('cta_contabil_id'))
        ->where([
            ['origem_despesa','=',$data['origem_despesa']],
            ['evento_id','=',$data['evento_id']],
            ['cta_contabil_id','=',$data['cta_contabil_id']]
            ])
        ->get();
        
        if($dados_enviar->count()==0){
            return true;
        }
        return false;
        
    }
}