<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;

class RepoEventos extends RepositoryNat51
{
     protected $model_name_space='App\Modules\Natureza51\Entities\Eventos';
     protected $form_rules=[
          'cdn_event'=>'required|unique:tbl_eventos,cdn_event'
     ];
     protected $rules_msg=[
          'cdn_event.required'=>'O campo Cód. Evento é obrigatório',
          'cdn_event.unique'=>'Cód. Evento já cadastrado'
     ]; 
     public function listarEventos(){
          $data=$this->getModelEntity()->select()->get()->toArray();
          for($i=0;$i<count($data);$i++){
               $dados[$i]=array_merge($data[$i],array("description"=>$data[$i]['cdn_event'].' - '.$data[$i]['des_event']));
          }
          
          return $dados;
     }
     public function update(array $data,$id,$attribute="id"){

          $this->form_rules['cdn_event'].=','.$id;
          return parent::update($data,$id,$attribute);
      
        }
}

