<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\Turno;
use Illuminate\Http\Request;

class RepoFuncionario extends RepositoryNat51
{
   protected $model_name_space='App\Modules\Natureza51\Entities\Funcionario';
   protected $form_rules=[

                      'nome_funcionario'=>'required',
                      'num_reg_func'=>'required',
                      'cdn_funcionario'=>'required|unique:tbl_funcionario,cdn_funcionario',
                      'dat_nascimento'=>'required',
                      'dat_admis_func'=>'required',
                      'cpf'=>'required',
                      'salario'=>'required'
                      
                         ];

    protected $rules_msg=[
                      'nome_funcionario.required'=>'O campo nome do funcionário é obrigatório',
                      'num_reg_func.required'=>'O campo número de registro funcionário é obrigatório',
                      'cdn_funcionario.required'=>'O campo código funcionário é obrigatório', 
                      'cdn_funcionario.unique'=>'Cód. Funcionário já foi cadastrado', 
                      'data de nascimento.required'=>'O campo data de nascimento é obrigatório',
                      'dat_admis_func.required'=>'O campo data de admissão funcionário é obrigatório',              
                      'cpf.required'=>'O campo CPF é obrigatório',                  
                      'salario.required'=>'O campo salário é obrigatório'
                                        
                        ]; 
   public function update(array $data,$id,$attribute="id"){

      $this->form_rules['cdn_funcionario'].=','.$id;

      if(!validaCPF($data['cpf'])){
         $this->setError("CPF inválido! erro:270120200956");
         return false;
      }
      
      return parent::update($data,$id,$attribute);
                                         
   } 
   public function listar(){
      
      $turno=new Turno();
      $a = $this->allWith([
         'getLotacao'=>function($query){
            // $query->select('des_unid_lotac');
         },
         'getCargo'=>function($query){
            // $query->select('id')->get()->toArray();
         },
         'getCcusto'=>function($query){},
         'getTpFunc'=>function($query){},
         'getTurma'=>function($query){
            return $query->with('getTurno');
         }

      ])
      ->toArray();
         

      for ($i=0; $i < count($a) ; $i++) { 
         
         $a[$i]['des_unid_lotac'] = $a[$i]['get_lotacao']['des_unid_lotac'];
         $a[$i]['des_cargo_basic']=$a[$i]['get_cargo']['des_cargo_basic'];
         $a[$i]['des_ccusto']=$a[$i]['get_ccusto']['des_ccusto'];
         $a[$i]['tipo']=$a[$i]['get_tp_func']['tipo'];
         $a[$i]['des_turno_trab']=$a[$i]['get_turma']['get_turno']['des_turno_trab'];
         
         $a[$i]['des_turma_trab']=$a[$i]['get_turma']['des_turma_trab'];
         unset($a[$i]['get_turma']);
         // $a[$i]['desc_reg_cargo_funcionario']=$a[$i]['num_reg_func']. ' - '.$a[$i]['des_cargo_basic']. ' - '.$a[$i]['nome_funcionario'];
         $a[$i]['desc_reg_funcionario']=$a[$i]['num_reg_func']. ' - '.$a[$i]['nome_funcionario'];

         // $a[$i]['tipo']=$a[$i]['get_tp_func']['tipo'];
         unset($a[$i]['get_lotacao']);
         unset($a[$i]['get_cargo']);
         unset($a[$i]['get_ccusto']);
         unset($a[$i]['get_tp_func']);
      }
      for($i=0;$i<count($a);$i++){
         $dados[$i]=array_merge($a[$i],array("description"=>$a[$i]['cdn_funcionario'].' - '.$a[$i]['nome_funcionario']));
     }
      
      return $a;
   }
   public function insert(Request $request){
      $form_data=$request->all();
      $cpf=$form_data['cpf'];
      // dd("form data",$form_data);
      if(!validaCPF($cpf)){
         $this->setError("CPF inválido! erro:270120200956");
         return false;
      }
      
      return parent::create($form_data);
      
   }
}
