<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use Illuminate\Support\Arr;

use Illuminate\Support\Facades\DB;

class RepoHeadcount extends RepoOrcamento
{
     protected $model_name_space='App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount';
     protected $form_rules=['lotacao_id' => 'required | min:1 | exists:tbl_orc_lotacao,id'];
     protected $rules_msg=[
         'lotacao_id.required'=>'O campo lotação é obrigatório',
         'lotacao_id.min'=>'Selecione uma lotação',
         'lotacao_id.exists'=> 'Lotação não cadastrada!'
    ];

   public function __construct(){
       parent::__construct();
   }
  
/**
 * @author Samuel Domingos de Lima 09/01/2020
 * @param array  Pass array with model fields and months
 */
    public function createHeadcount($data){
        $repo_orc = $this->getOrcInstanceNew();
        $repo_lot = new RepoOrcLotacao();

        if($repo_orc->getModelEntity()->where('id',$this->extractOrcamentoIdFromData($data,'orc_id'))->first() == false){
            $retorno = array('status'=>'error','msg'=>'Orçamento não encontrado. Erro 090120201640.');
            goto saida;
        }
      
        $lot = $repo_lot->find($data['lotacao_id']);

        if($lot->status == $this->getStatusPendente() || 
                $lot->status == $this->getStatusEmAndamento() || 
                $lot->status == $this->getStatusReaberto()){
            
            $clausule = array(
                'orc_id'=>$data['orc_id'], 
                'lotacao_id'=>$data['lotacao_id'],
                'ccusto_id'=>$data['ccusto_id'],
                'orc_cargo_id'=>$data['orc_cargo_id'],
                'orc_turma_id'=>$data['orc_turma_id']
            );
            
            if($this->hasDataOnDB($clausule)){               
                $retorno['status']='warning';
                $retorno['msg']='Falha ao inserir o Registro! Dados já cadastrados.';
                goto saida;
            }
          

            $repo_calc_orcamento = new RepoCalcOrcamento();   
            $meses = $data['meses_orcado'];
            $meses['tbl_origem'] = $this->getModelEntity()->getTable();
            DB::beginTransaction();
            try {

                if($lot->status == $this->getStatusPendente()){
                    $this->inProgressStatus($lot->id,$repo_lot->getModelNameSpace());
                }
                // dd("creat orc turma", $data);
                $head = $this->create($data);
                if(!$head){
                    $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted(),'submsg'=>'Erro ao inserir o registro. Erro: 090120201540');
                    goto saida;
                }
                $meses['origem_id']=$head->id;
                if(!$repo_calc_orcamento->create($meses)){
                    $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted(),'submsg'=>'Erro ao inserir o registro. Erro: 090120201540');
                    goto saida;
                }

                $retorno = array('status'=>'success','msg'=>'Registro inserido com sucesso!');
                goto saida;

            } catch (\Exception $e) {
                DB::rollBack();
                // dd("catch orc turma", $e);
                abort('Erro! Falha ao Inserir o Registro. Erro 030120201543');
            }

            $retorno = array('status'=>'success','msg'=>'Registro inserido com sucesso!');
            goto saida;

       
        
            saida:
            ($retorno['status']=='success')?DB::commit():DB::rollBack();
            return $retorno;
        }else{
            return array('status'=>'error','msg'=>'Operação indisponível. Tente novamente mais tarde. Erro: 010220201214.');
        }
    }

    public function updateHeadcount($form_data){
        $headcount_id=$form_data['id'];
        $repo_calc_orcamento=new RepoCalcOrcamento();
        $meses_headcount = $this->dataUpdateHeadcount($form_data); 
        // dd($meses_headcount);
        if(!$repo_calc_orcamento->update($meses_headcount, $headcount_id)){ 
                $retorno['status']='error';
                $retorno['msg'] = $this->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer update do registro. Erro: 211120191925';
                goto saida;               
        } 
        
        $retorno = array('msg'=>'Registro atualizado com sucesso!','status'=>'success');
        saida:
        return $retorno;
    }
    public function deleteHeadcount($form_data){
        $repo_calc_orc=new RepoCalcOrcamento();
        DB::beginTransaction();
        try {
            $delete = $this->getModelEntity()::where('id',$form_data['id_princ'])->delete();
            if(!$delete){
                $retorno = array('status'=>'error','msg'=>"Falha ao deletar o registro. Erro: 100120201003.");
                goto saida;
            }
            
            $delete_calc_orc = $repo_calc_orc->getModelEntity()::where('id',$form_data['id'])->delete();

            if($delete_calc_orc == false){
                $retorno = array('status'=>'error','msg'=>"Falha ao deletar o registro. Erro: 100120201004.");
                goto saida;          
            }

            DB::commit();

        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao deletar. Erro: 10012020005.');            
        }
        $retorno['msg']='Registro deletado com sucesso!';
        $retorno['status']='success';
        saida:
        ($retorno['status']=='error')?DB::rollBack():DB::commit();
        return $retorno;
    }


    public function dataUpdateHeadcount($data){
        $array_orcamento=['cod_ccusto','cod_cargo_basic', 'des_cargo_basic', 'atual', 'turno', 'turma', 'id' ,'tb'];
        $meses=['jan', 'fev', 'mar', 'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez'];
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
        $mes_atual="";
        $meses_headcount=[];
        
        foreach($filtered as $chave=>$valor){            
            $mes_atual=$chave."_orcado";                 
            $meses_headcount[$mes_atual]=$valor;   
        }

        return $meses_headcount;
    }
} 
