<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;

use Illuminate\Support\Facades\DB;
 
class RepoHeadcountDemissoes extends RepoOrcamento
{
     protected $model_name_space='App\Modules\Natureza51\Entities\OrcHeadcountDemissoes';

     public function create($data_request){     
        // $retorno=true;
        // $instance = $this;
        // dd("aquiiiiiii",$data_request);
        $clausule = array(
            'orcamento_id'=>$data_request['orcamento_id'],
            'ccusto_id'=>$data_request['ccusto_id'],
            'lotacao_id'=>$data_request['lotacao_id'],
            'orc_cargo_id'=>$data_request['orc_cargo_id'],
            'orc_turma_id'=>$data_request['orc_turma_id'],
            'tipo'=>$data_request['tipo'],

            // 'tipo_table'=>$data['tipo_table']
        );
        if($this->hasDataOnDB($clausule)){
            $retorno['status']='error';
            $retorno['msg']='Falha ao inserir registro. Dados já cadastrados!';
            goto saida;
        }

        $repo_calc_orcamento = new RepoCalcOrcamento();
        DB::beginTransaction();
        
        try {
            $id_orc_demissoes = $this->createParent($data_request);

            if(!$id_orc_demissoes){  
                // dd("nsjs30");

                $retorno = array('status'=>'error','msg'=>$this->getErrosFlatted());
                goto saida;
            }  

            if($data_request['tipo'] == 1){
                $merge_tb_calc = [
                    'origem_id' => $id_orc_demissoes->id,
                    'tbl_origem' => $this->getModelEntity()->getTable()
                ];
                
                if(!$repo_calc_orcamento->create(array_merge($merge_tb_calc, $data_request['meses_orcado']))){                    
                    $retorno = array('status'=>'error','msg'=>'Falha ao inserir o registro. Erro: 13020201726.');
                    goto saida;
                }
            } 

            $retorno = array('status'=>'success','msg'=>'Registro inserido com sucesso!.');
            goto saida;

        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao inserir o registro. Erro: 130120201728.');
        }
  

        saida:
        ($retorno['status']=='error')?DB::rollBack():DB::commit();
       
        return $retorno;
    }

    public function createParent($data_request){
        $data_request = $this->putCargoIdOnData($data_request,$data_request['orc_cargo_id']);
        
        return parent::checkHeadcount($data_request);
    }

    public function deleteAll($value){
        $repo_calc_orc = new RepoCalcOrcamento();

        DB::beginTransaction();
        try {
           $all = $this->getModelEntity()->select('id')->where($value)->delete();
           if(!$all){
                $retorno = array('status'=>'error','msg'=>'Falha ao deletar registro. Erro: 230120201410.');
                goto saida;
           }

           $retorno = array('status'=>'success','msg'=>'Registro deletado com sucesso.');

        } catch (\Exception $th) {
            DB::rollBack();
            abort(500,'Falha ao deletar registro. Erro: 230120201358.');
        }


        
        saida:
        $retorno['status']=='success'?DB::commit():DB::rollBack();
        return $retorno;
    }
}