<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\OrcamLotCargoEvento;
use App\Modules\Natureza51\Entities\OrcFerias;
use App\Modules\Natureza51\Entities\OrcHeadcountContratacoes;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;
use DB;

class RepoHeadcountResumo extends RepoOrcamento 
{
    private $tbl_calc_orc;

    public function __construct(){
        $this->tbl_calc_orc = new CalcOrcamento();
        parent::__construct(); 
    }
    public function resHeadcount(){
        $tbl_headcount = new OrcamLotCargoHeadcount();
    }   
    public function resHorasExtras($orc_id,$lotacao_id){
        // $this->getoRC
        $tbl_hra_extra = new OrcamLotCargoEvento();
        $where = [
            ['orc_id', $orc_id],
            ['lotacao_id',$lotacao_id]
        ];
        return $this->selectForAll($tbl_hra_extra,$where);
    }
    public function resFerias($orc_id,$lotacao_id){
        $tbl_ferias = new OrcFerias();
        $where = [
            ['orcamento_id', $orc_id],
            ['lotacao_id',$lotacao_id]
        ];
        return $this->selectForAll($tbl_ferias,$where);
    }
    public function resContratacoes($orc_id,$lotacao_id){
        $where = [
            ['orcamento_id', $orc_id],
            ['lotacao_id',$lotacao_id]
        ];
        $tbl_contratacoes = new OrcHeadcountContratacoes();
        return $this->selectForAll($tbl_contratacoes,$where);


    }
    public function resDemissoes($orc_id,$lotacao_id){
        $where = [
            ['orcamento_id', $orc_id],
            ['lotacao_id',$lotacao_id]
        ];

        $tbl_demissoes = new OrcHeadcountDemissoes();
        return $this->selectForAll($tbl_demissoes,$where);

    }



    public function selectForAll($table,$where){

        
        return $table->select(        
            DB::raw("format(sum({$this->tbl_calc_orc->getColunaAlias('jan_orcado')} + {$this->tbl_calc_orc->getColunaAlias('fev_orcado')} + {$this->tbl_calc_orc->getColunaAlias('mar_orcado')} + {$this->tbl_calc_orc->getColunaAlias('abr_orcado')} + {$this->tbl_calc_orc->getColunaAlias('mai_orcado')} + {$this->tbl_calc_orc->getColunaAlias('jun_orcado')} + {$this->tbl_calc_orc->getColunaAlias('jul_orcado')} + {$this->tbl_calc_orc->getColunaAlias('ago_orcado')} + {$this->tbl_calc_orc->getColunaAlias('set_orcado')} + {$this->tbl_calc_orc->getColunaAlias('out_orcado')} + {$this->tbl_calc_orc->getColunaAlias('nov_orcado')} + {$this->tbl_calc_orc->getColunaAlias('dez_orcado')}),'n','pt-br') as total_".$table->getTable())
            )
            ->leftJoin($this->tbl_calc_orc->getTable(), $table->getColunaAlias('id'), '=',                            
            DB::raw("{$this->tbl_calc_orc->getColunaAlias('origem_id')}")) 
            ->where($this->tbl_calc_orc->getColunaAlias('tbl_origem'), $table->getTable()) 
            ->where($where)->get(); 
    } 
}