<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Entities\OrcBeneficio;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
// use App\Modules\Natureza51\Entities\CalcOrcamento;


use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\OrcamLotCargoEvento;
use App\Modules\Natureza51\Entities\OrcFerias;
use App\Modules\Natureza51\Entities\OrcContratacoes;
use App\Modules\Natureza51\Entities\OrcPromocao;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;
use App\Modules\Natureza51\Entities\CalcOrcamento;
class RepoOrcBeneficio extends RepoOrcamento
{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcBeneficio';
                        
    public function createOrcBeneficio($data_request){        
        $retorno=true;
        $instance = $this;

        DB::transaction(function()use(&$retorno, $data_request, $instance){
            
            $repo_calc_orcamento = new RepoCalcOrcamento();
            
            $id_orc_demissoes = $instance->createParent($data_request);
            
            if(! $id_orc_demissoes){  
                $retorno = false;
                return false;
            }  
            
            $merge_tb_calc = [
                'origem_id' => $id_orc_demissoes->id,
                'tbl_origem' => $instance->getModelEntity()->getTable()
            ];
            
            if(! $repo_calc_orcamento->create(array_merge($merge_tb_calc, $data_request['meses_orcado']))){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }
                        
        });
        
        return $retorno;
    }
    public function createParent($data_request){
        
        $dados=$this->getModelEntity()->select()->where([
                [$this->getModelEntity()->getColunaAlias('evento_id'),'=',$data_request['evento_id']],
                [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=',$data_request['orcamento_id']],
                [$this->getModelEntity()->getColunaAlias('beneficio_id'),'=',$data_request['beneficio_id']]
        ])->get()->toArray();
        
        if(count($dados)==0){
            return parent::create($data_request);
        }else{
            $this->setError("Registro já cadastrado! erro:180220201018");
            
            abort(500, "Registro já cadastrado! erro:180220201018");
            return false;
        }
    }

    public function listar($id){
        
        $orcBeneficio = OrcBeneficio::with([
            'getEvento'=>function($query){
    
            },
            'getCalcOrcamento'=>function($query){
                
           }

        ])->where('orcamento_id',$id)->get()
        ->toArray();
        //dd($orcBeneficio);
        for ($i=0; $i < count($orcBeneficio); $i++) {   
            
            
            $orcBeneficio[$i]['description'] = $orcBeneficio[$i]['get_evento']['cdn_event'].' - '.$orcBeneficio[$i]['get_evento']['des_event'];
            $orcBeneficio[$i]['des_event'] = $orcBeneficio[$i]['get_evento']['des_event'];
            Arr::forget($orcBeneficio[$i], 'get_evento');
            $orcBeneficio[$i]['calc_orcamento_id'] = $orcBeneficio[$i]['get_calc_orcamento']['id'];
            unset($orcBeneficio[$i]['get_calc_orcamento']['id']);
            $orcBeneficio[$i]= array_merge($orcBeneficio[$i], $orcBeneficio[$i]['get_calc_orcamento']); 
            Arr::forget($orcBeneficio[$i], 'get_calc_orcamento');


            $orcBeneficio[$i]['vlr_movto']=formatarNumeroPtBr($orcBeneficio[$i]['vlr_movto']);
            $orcBeneficio[$i]['vlr_depend']=formatarNumeroPtBr($orcBeneficio[$i]['vlr_depend']);
            $orcBeneficio[$i]['jan_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['jan_orcado']);
            $orcBeneficio[$i]['fev_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['fev_orcado']);
            $orcBeneficio[$i]['mar_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['mar_orcado']);
            $orcBeneficio[$i]['abr_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['abr_orcado']);
            $orcBeneficio[$i]['mai_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['mai_orcado']);
            $orcBeneficio[$i]['jun_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['jun_orcado']);
            $orcBeneficio[$i]['jul_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['jul_orcado']);
            $orcBeneficio[$i]['ago_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['ago_orcado']);
            $orcBeneficio[$i]['set_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['set_orcado']);
            $orcBeneficio[$i]['out_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['out_orcado']);
            $orcBeneficio[$i]['nov_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['nov_orcado']);
            $orcBeneficio[$i]['dez_orcado']=formatarNumeroPtBr($orcBeneficio[$i]['dez_orcado']);      

        }

        $meses=['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado','dez_orcado'];
        //dd('Meses aqui!!!',$this->getOnly($orcBeneficio,$meses));
        return $orcBeneficio;

    } 

    public function listaEventos($orc_id){
        $orcBeneficio = OrcBeneficio::with([
            'getEvento'=>function($query){
    
            }
        ])
        ->where('orcamento_id',$orc_id)
        ->get()
        ->toArray();
      
        for ($i=0; $i < count($orcBeneficio); $i++) {             
            $orcBeneficio[$i]['des_event'] = $orcBeneficio[$i]['get_evento']['des_event'];
            $orcBeneficio[$i]['cdn_event'] = $orcBeneficio[$i]['get_evento']['cdn_event'];
            Arr::forget($orcBeneficio[$i], 'get_evento');
            $orcBeneficio[$i]['description']=$orcBeneficio[$i]['cdn_event'].' - '.$orcBeneficio[$i]['des_event'];
        }
        
        return $orcBeneficio;
    }  
    
    public function deleteOrcBeneficio($data_request){        
        $retorno=true;
        $instance = $this;

        DB::transaction(function()use(&$retorno, $data_request, $instance){
            
            $repo_calc_orcamento = new RepoCalcOrcamento();

            if(!$instance->deleteParent($data_request['id'])){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }          
            
            $calc_orcamento_id['id'] = $data_request['calc_orcamento_id'];

            if(! $repo_calc_orcamento->delete($calc_orcamento_id['id'])){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }
                        
        });
        
        return $retorno;
    }

    public function deleteParent($data_request){
        return parent::delete($data_request);
    }

    public function updateOrcBeneficio($data_request){        
        $retorno=true;
        $instance = $this;

        DB::transaction(function()use(&$retorno, $data_request, $instance){
            
            $repo_calc_orcamento = new RepoCalcOrcamento();

            $dados_beneficio=Arr::only($data_request,['id','orcamento_id','empresa_id','beneficio_id','evento_id','tipo_calc',
            'formula']);

            $vlr_movto = array("vlr_movto"=>convertDec($data_request['vlr_movto']));
            $vlr_depend = array("vlr_depend"=>convertDec($data_request['vlr_depend']));
            $dados_b2 = array_merge($dados_beneficio,$vlr_movto,$vlr_depend);

            if(!$instance->updateParent($dados_b2, $dados_b2['id'])){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }          
            
            $calc_orcamento_id['id'] = $data_request['calc_orcamento_id'];
            $dados_orc=Arr::except($data_request,['orcamento_id','empresa_id','beneficio_id','evento_id','tipo_calc',
            'formula','vlr_movto','vlr_depend']);

            $dados_orcamento = Arr::except($dados_orc,['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jun_orcado','ago_orcado','jul_orcado','set_orcado',
            'out_orcado','nov_orcado','dez_orcado']);

            $meses=Arr::only($dados_orc,['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jun_orcado','ago_orcado','set_orcado',
            'out_orcado','nov_orcado','dez_orcado']);

            $orcamento = convertDec($meses);
            $array_orcamento = array_merge($dados_orcamento,$orcamento);


            if(! $repo_calc_orcamento->update($array_orcamento, $calc_orcamento_id['id'])){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }
                        
        });
        
        return $retorno;
    }

    public function updateParent($data_request, $id){

        // $this->form_rules['evento_id'].=','.$id;
        $dados=$this->getModelEntity()->select()->where($this->getModelEntity()->getColunaAlias('id'),'=',$data_request['id'])->get()->toArray();
        if(count($dados)==1){
            return parent::update($data_request, $id);
        }
        return false;

    }
    public function getOnly($data,$fields){
        Arr::except($data,$fields );
    }
}

