<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\OrcBonus;
use App\Modules\Natureza51\Entities\Cargo;
use DB;

class RepoOrcBonus extends RepositoryNat51
{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcBonus';
    protected $form_rules=[];
    protected $rules_msg=[]; 


    public function listar($orc_id){
        
        $orc_bonus = new OrcBonus();
        $tb_cargo = new Cargo();
        $data = $orc_bonus->leftJoin($tb_cargo->getTable(),$orc_bonus->getColunaAlias('cargo_id'),$tb_cargo->getColunaAlias('id'))
        ->select(
            $orc_bonus->getColunaAlias('id'),
            $orc_bonus->getColunaAlias('porcentagem'),
            $orc_bonus->getColunaAlias('orc_id') ,
            $orc_bonus->getColunaAlias('ccusto_id'),
            DB::raw('LEFT(cod_cargo_basic, 2) as grade_salarial, ccusto_id+null as parent'),
            $orc_bonus->getColunaAlias('num_sal') ,
            $tb_cargo->getColunaAlias('cod_cargo_basic'), 
            $tb_cargo->getColunaAlias('des_cargo_basic'),
            DB::raw($tb_cargo->getColunaAlias('id').' as cargo_id'))
        ->where('orc_id',$orc_id)
        ->get()
        ->toArray();
        
        return $data;
    }

    public function insert($orc_id, $data ){
      
        $diff_inser_up = $this->existInOrcBonus($orc_id,$data);
        
        DB::beginTransaction();
       
        try{

                foreach($diff_inser_up['update'] as $k=>$data_up){
                   
                    $data_update = [
                        'porcentagem'=>$data['porcentagem'],
                        'num_sal'=>$data['num_sal']
                    ];

                    if($k > 0){
                        $this->makeModel();
                    }

                    if(!$this->update($data_update, ['id'=>$data_up])){ 
                        // $this.getErrosFlatted();                             
                        $this->setError('Falha ao fazer update do registro. Erro: 080120202008 ' .$this.getErrosFlatted());
                        DB::rollBack();
                        // dd("update --".$k, $this->getErrosFlatted());
                        return false;                        
                    }
                }
                
                foreach($diff_inser_up['insert'] as $k => $data_up){

                    $this->makeModel();
                    
                    $insert = OrcBonus::insert([
                        'ccusto_id'=>1,
                        'orc_id'=>$orc_id,
                        'porcentagem'=>$data['porcentagem'],
                        'num_sal'=>$data['num_sal'],
                        'cargo_id'=>$data_up
                    ]);                    

                    if(!$insert){                         
                        $this->setError('Falha ao fazer insert do registro. Erro: 080120202010 ' .$this.getErrosFlatted());
                        DB::rollBack();
                        return false;  
                    }
                }                

            DB::commit();
                
            } catch (Exception $ex) {
                DB::rollBack();
                abort(500,'Falha ao atualizar . Erro: 080120201624.');
        }
        
        return array('msg'=>"Cadastro Realizado com Sucesso",'status'=>"success");
    }
  
    public function getCargoByGrade($grades){
             
        $result= Cargo::where(function ($query) use($grades) {
            for ($i = 0; $i < count($grades); $i++){
                 $query=$query->orwhere('cod_cargo_basic', 'like',  $grades[$i].'%');
            }
        
        })->select(
            DB::raw('LEFT(cod_cargo_basic, 2) as grade_salarial, id+null as parent'),
            'cod_cargo_basic','des_cargo_basic','salario','id','id as cargo_id')
        ->get()
        ->toArray();
        
        return $result;
    }

    public function existInOrcBonus($orc_id,$data, $op=false){ 
        
        if(isset($data['cargo_id'])) {
             $array_cargo_id = $data['cargo_id'];
        }
        
        if(!$op){             
            
            $data_grade = $this->getCargoByGrade($data['grade_salarial']);

            $array_cargo_id = array_column($data_grade, 'id');            
        }         
        
        $orc_bonus = $this->getModelEntity();
        
        $upadate = $orc_bonus->select(
            $orc_bonus->getColunaAlias('id'),
            $orc_bonus->getColunaAlias('cargo_id')
        )
        ->where($orc_bonus->getColunaAlias('orc_id'),$orc_id)
        ->whereIn(                
                $orc_bonus->getColunaAlias('cargo_id'), $array_cargo_id
        )
        ->get();
        
        $insert = array_diff($array_cargo_id, ($to_update=$upadate->pluck('cargo_id')->toArray()));
        
        $orc_bonus_insert = array(
                "update" => $upadate->pluck('id')->toArray(),
                "insert" => $insert               
        );
        
        return $orc_bonus_insert;
    }

    public function updateBonus($orc_id,$data){
        
        $diff_inser_up = $this->existInOrcBonus($orc_id,$data, true);
        
        DB::beginTransaction();
       
        try{
            
            if(count($diff_inser_up['update'])>0){
                $data_update = [
                    'porcentagem'=>$data['porcentagem'],
                    'num_sal'=>$data['num_sal'],
                ];                   

                if(!$this->update($data_update, ['id'=>$diff_inser_up['update'][0]])){ 
                    // $this.getErrosFlatted();                             
                    $this->setError('Falha ao fazer update do registro. Erro: 080120202008 ' .$this.getErrosFlatted());
                    DB::rollBack();
                    // dd("update --".$k, $this->getErrosFlatted());
                    return false;                        
                }
                
                goto saida; 
            }
            
            $insert = OrcBonus::insert([
                'ccusto_id'=>1,
                'orc_id'=>$orc_id,
                'porcentagem'=>$data['porcentagem'],
                'num_sal'=>$data['num_sal'],
                'cargo_id'=>$data['cargo_id'][0]
            ]);                    

            if(!$insert){                         
                $this->setError('Falha ao fazer insert do registro. Erro: 080120202010 ' .$this.getErrosFlatted());
                DB::rollBack();
                return false;  
            }

            saida:
            DB::commit();
                
            } catch (Exception $ex) {
                DB::rollBack();
                abort(500,'Falha ao atualizar . Erro: 080120201624.');
        }
        
        return array('msg'=>"Cadastro Realizado com Sucesso",'status'=>"success");
    }

    public function deleteBonus($orc_id,$data){
        $instance = $this;

        $result = OrcBonus::where([
            ['id', $data['id']],
            ['cargo_id', $data['cargo_id']],
            ['orc_id', $orc_id]
        ])->first();
        
        if(is_null($result)){
            $this->setError('Este registro não existe no orçamento. Erro: 100120200934 ');            
            return false;
        }

        DB::beginTransaction();
       
        try{
            
            if(!$instance->deleteParent($data['id'])){  
                $this->setError('Falha ao deletar o registro. Erro: 100120200937 ' .$this.getErrosFlatted());
                DB::rollBack();
                return false;                                  
            }
            
            DB::commit();
                
            } catch (Exception $ex) {
                DB::rollBack();
                abort(500,'Falha ao atualizar . Erro: 080120201624.');
        }
        
        return array('msg'=>"Registro deletado com sucesso",'status'=>"success");
    }

    public function deleteParent($data_request){
        return parent::delete($data_request);
    }
   
}
