<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoCargo;
use App\Modules\Natureza51\Entities\OrcLotCargoBeneficio;
use App\Modules\Natureza51\Entities\OrcFerias;
use App\Modules\Natureza51\Entities\OrcHeadcountContratacoes;
use App\Modules\Natureza51\Entities\OrcHeadcountDemissoes;
use App\Modules\Natureza51\Entities\OrcamLotCargoEvento;
use App\Modules\Natureza51\Entities\OrcPromocao;
use App\Modules\Natureza51\Entities\OrcamLotCargoHeadcount;
use App\Modules\Natureza51\Entities\OrcSalarioFuncionario;
use App\Modules\Natureza51\Entities\OrcCargosAreaSal;
use \App\Core\Traits\ErrorTrait;
use Illuminate\Support\Arr;       
        
use DB;

class RepoOrcCargo extends RepoOrcamento
{    
    
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcCargo';
    protected $form_rules=[];
    protected $rules_msg=[]; 
 
    function __construct() {
        
        parent::__construct();
    }
    public function listAll($orc_id){
 
        DB::enableQueryLog();

        $repo_calc_orcamento= new RepoCalcOrcamento();
        $cargo_sal= $this->getModelEntity()
        ->leftJoin(
            $repo_calc_orcamento->getModelEntity()->getTable(),
            $this->getModelEntity()->getColunaAlias('id'),
            '=',
            DB::raw("{$repo_calc_orcamento->getModelEntity()->getColunaAlias('origem_id')} and 
            {$repo_calc_orcamento->getModelEntity()->getColunaAlias('tbl_origem')} = '{$this->getModelEntity()->getTable()}'
            "))
            ->with([
                'getCargo'=>function($query){    
                }])            
            ->where('orcamento_id','=', $orc_id)
           
            ->select(
                $this->getModelEntity()->getColunaAlias('id'),
                $this->getModelEntity()->getColunaAlias('orcamento_id'),
                $this->getModelEntity()->getColunaAlias('cargo_id'),
                //$this->getModelEntity()->getColunaAlias('sal_base'),
                DB::raw("format({$this->getModelEntity()->getColunaAlias('sal_base')}, 'N', 'pt-br') AS sal_base"),
                $this->getModelEntity()->getColunaAlias('sal_max'),
                $this->getModelEntity()->getColunaAlias('sal_med'),
                $this->getModelEntity()->getColunaAlias('sal_min'),
                $this->getModelEntity()->getColunaAlias('data_calc'),
                $this->getModelEntity()->getColunaAlias('grupo_salarial'),
                DB::raw($repo_calc_orcamento->getModelEntity()->getColunaAlias('id').' AS id_calc'),

                DB::raw("format({$repo_calc_orcamento->getModelEntity()->getColunaAlias('jan_orcado')}, 'N', 'pt-br') AS jan_orcado"),
                DB::raw("format({$repo_calc_orcamento->getModelEntity()->getColunaAlias('fev_orcado')}, 'N', 'pt-br') AS fev_orcado"),
                DB::raw("format({$repo_calc_orcamento->getModelEntity()->getColunaAlias('mar_orcado')}, 'N', 'pt-br') AS mar_orcado"),
                DB::raw("format({$repo_calc_orcamento->getModelEntity()->getColunaAlias('abr_orcado')}, 'N', 'pt-br') AS abr_orcado"),
                DB::raw("format({$repo_calc_orcamento->getModelEntity()->getColunaAlias('mai_orcado')}, 'N', 'pt-br') AS mai_orcado"),
                DB::raw("format({$repo_calc_orcamento->getModelEntity()->getColunaAlias('jun_orcado')}, 'N', 'pt-br') AS jun_orcado"),
                DB::raw("format({$repo_calc_orcamento->getModelEntity()->getColunaAlias('jul_orcado')}, 'N', 'pt-br') AS jul_orcado"),
                DB::raw("format({$repo_calc_orcamento->getModelEntity()->getColunaAlias('ago_orcado')}, 'N', 'pt-br') AS ago_orcado"),
                DB::raw("format({$repo_calc_orcamento->getModelEntity()->getColunaAlias('set_orcado')}, 'N', 'pt-br') AS set_orcado"),
                DB::raw("format({$repo_calc_orcamento->getModelEntity()->getColunaAlias('out_orcado')}, 'N', 'pt-br') AS out_orcado"),
                DB::raw("format({$repo_calc_orcamento->getModelEntity()->getColunaAlias('nov_orcado')}, 'N', 'pt-br') AS nov_orcado"),
                DB::raw("format({$repo_calc_orcamento->getModelEntity()->getColunaAlias('dez_orcado')}, 'N', 'pt-br') AS dez_orcado")
            )->get();
            
        if(!($orc = $cargo_sal->first())){
            $this->setError(['Orçamento não encontrado.', 'Erro: 031220191636']);
            return false;
        }

        $orc_f=$orc->getOrcamento();
        
        if(!$orc_f){
             $this->setError(['Orçamento não encontrado.', 'Erro: 031220191803']);
            return false;
        }
        $sql=DB::getQueryLog();

        $atual=$orc_f->first();
        
        if(!$atual){
             $this->setError(['Orçamento não encontrado.', 'Erro: 031220191804']);
            return false;
        }
        
        if($this->setOrcamento($atual)->has()===false){
            $this->setError(['Orçamento não encontrado.', 'Erro: 031220191635']);
            return false;
        }
        if($this->isOwn()===false){
            $this->setError(['Você não tem permissão para acessar estas informações.', 'Erro: 031220191637']);
            return false;
        }
        
        if(!$orc){
           $this->setError(['Informe um orçamento','Erro: 021220191834']);
           return false;
        }
               
        foreach ($cargo_sal as $i => $cargo) {
            if(!$cargo_sal[$i]->getCargo){
                continue;
            }
            $cargo_sal[$i]['cod_cargo_basic'] = $cargo_sal[$i]->getCargo->cod_cargo_basic;
            $cargo_sal[$i]['des_cargo_basic'] = $cargo_sal[$i]->getCargo->des_cargo_basic;

            Arr::forget($cargo_sal[$i], 'getCargo');
        }   
        
        return $cargo_sal->count()==0 ? []: $cargo_sal;
       
    }
    public function createOrc(array $dados, $call_back_success=null, $call_ball_error=null){
        
        $this->clearError(); 
       
       /**
         * ======= Verificar novamente estás validações. Não está fazendo sentido. Samuel Domingos de Lima =====
         */
        
        //dd("dados",$dados);
            $orc= $this->getModelEntity()->select()->where([
                ['orcamento_id','=', $dados['orcamento_id']],
                ['cargo_id','=',$dados['cargo_id']],
                ])->get()->toArray();
            //dd("orc",$orc);
            if(count($orc)!=0){
                $this->setError('Registro já cadastrado','Erro: 090320201331');
                return false;
            } 
            if(!$dados['orcamento_id']){
                $this->setError(['Informe um orçamento','Erro: 280120201210']);
                return false;
            }
            if(isset($dados['meses_orcado'])==false){
                $this->setError('Preencha os meses');
                return false;
            }            
             
            // if($this->setOrcamento($orc->getOrcamento()->first())->canEdit()===false){
            //     $this->setError('O estado do orçamento não permite este tipo de operação.', 'Erro: 021220191837');
            //     return false;
            // }
            

       DB::beginTransaction();
       
       try{

            
            // $dados['sal_base']=str_replace('.','',$dados['sal_base']);
            // $dados['sal_med']=str_replace('.','',$dados['sal_med']);
            // $dados['sal_min']=str_replace('.','',$dados['sal_min']);
            // $dados['sal_max']=str_replace('.','',$dados['sal_max']);

            // $dados['sal_base']=str_replace(',','.',$dados['sal_base']);
            // $dados['sal_med']=str_replace(',','.',$dados['sal_med']);
            // $dados['sal_min']=str_replace(',','.',$dados['sal_min']);
            // $dados['sal_max']=str_replace(',','.',$dados['sal_max']);
            //dd("dados",$dados);
            $salvou = $this->create($dados);

            if(!$salvou){
                return false;
            }
            //$dados_env=convertDecimalEn($dados['meses_orcado']);
            //dd("dsadosksndfv",$dados);
            $repo_calc_orc=new RepoCalcOrcamento();
            $salvou_calc= $repo_calc_orc->create(array_merge($dados['meses_orcado'],["origem_id"=>$salvou->id, "tbl_origem"=>$this->getModelEntity()->getTable()]));

            if($salvou_calc==false){
                $this->setError([$repo_calc_orc->getErrosFlatted(),'Erro: 021220191908']);
                DB::rollBack();
                return false;
            }

            DB::commit();
            
        } catch (Exception $ex) {
             DB::rollBack();
             abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 021220181942.');
       }
        return $salvou;
        
    }

    public function updateOrc($data_request){        
        $retorno=true;
        $instance = $this;
        
        DB::transaction(function()use(&$retorno, $data_request, $instance){
            
            $repo_calc_orcamento = new RepoCalcOrcamento();

            $data_request['sal_base']=str_replace('.','',$data_request['sal_base']);
            $data_request['sal_base']=str_replace(',','.',$data_request['sal_base']);

            $data_request['sal_med']=str_replace(',','.',$data_request['sal_med']);
            $data_request['sal_base']=str_replace('.','',$data_request['sal_med']);

            $data_request['sal_min']=str_replace(',','.',$data_request['sal_min']);
            $data_request['sal_base']=str_replace('.','',$data_request['sal_min']);

            $data_request['sal_max']=str_replace(',','.',$data_request['sal_max']);
            $data_request['sal_base']=str_replace('.','',$data_request['sal_max']);
            
            $sem_meses=Arr::only($data_request,['id','id_calc','cargo_id','cod_cargo_basic','des_cargo_basic','orcamento_id','sal_base','sal_max','sal_med','sal_min','data_calc']);
            if($sem_meses['sal_base']==""){
                $sem_meses['sal_base']="0";
            }
            if($sem_meses['sal_max']==""){
                $sem_meses['sal_max']="0";
            }
            if($sem_meses['sal_med']==""){
                $sem_meses['sal_med']="0";
            }
            if($sem_meses['sal_min']==""){
                $sem_meses['sal_min']="0";
            }

            
            if(!$instance->updateParent($sem_meses, $sem_meses['id'])){ 
                                   
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            } 

            $meses = $this->dataFilterMesesCalcOrcamento($data_request); 
            $meses = convertDecimalEn($meses);
            
            $calc_orcamento_id= $this->getModelEntity()
            ->join(
            $repo_calc_orcamento->getModelEntity()->getTable(),

            $this->getModelEntity()->getColunaAlias('id'),'=',

            DB::raw("{$repo_calc_orcamento->getModelEntity()->getColunaAlias('origem_id')} and 
            {$repo_calc_orcamento->getModelEntity()->getColunaAlias('tbl_origem')} = '{$this->getModelEntity()->getTable()}'
            "))      

            ->where([
                ['origem_id', $data_request['id']],
                ['tbl_origem', $this->getModelEntity()->getTable()]

            ])->first();
            
            if(!$calc_orcamento_id){
                $salvou_calc = $repo_calc_orcamento->create(array_merge($meses,["origem_id"=> $data_request['id'], "tbl_origem"=>$this->getModelEntity()->getTable()]));

                if($salvou_calc==false){
                    $this->setError([$repo_calc_orcamento->getErrosFlatted(),'Erro: 070120200959']);
                    $retorno = true;
                    abort(500, $retorno['msg']);
                    return false;
                }
                return $retorno;
            }

            if(! $repo_calc_orcamento->update($meses, $calc_orcamento_id['id'])){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }
                        
        });
        
        return $retorno;
    }

    public function updateParent($data_request, $id){
        return parent::update($data_request, $id);
    }

    public function listarCargo($orc_id){
        $repo_cargo = new RepoCargo();
        $repo_cargo = $repo_cargo->getModelEntity();
        $repo_orc_cargo = $this->getModelEntity();

        $cargo_sal= $repo_orc_cargo->join($repo_cargo->getTable(),
        $repo_orc_cargo->getColunaAlias('cargo_id'),
        $repo_cargo->getColunaAlias('id'))
        ->select($repo_cargo->getColunaAlias('des_cargo_basic'),
        $repo_cargo->getColunaAlias('sal_base'),
        $repo_cargo->getColunaAlias('cod_cargo_basic'),
        $repo_orc_cargo->getColunaAlias('id'),
        $repo_orc_cargo->getColunaAlias('cargo_id'))
        ->where('orcamento_id','=', $orc_id)->get()->toArray();
        // dd("cargo backend", $cargo_sal);
        
        // if(!($orc = $cargo_sal->first())){
        //     $this->setError(['Orçamento não encontrado.', 'Erro: 031220191636']);
        //     return false;
        // }

        for($i=0;$i<count($cargo_sal);$i++){
            $dados[$i]=array_merge($cargo_sal[$i],array("description"=>$cargo_sal[$i]['cod_cargo_basic'].' - '.$cargo_sal[$i]['des_cargo_basic']));
        }
        
        //array_merge($cargo_sal,'description'=>$cargo_sal['cod_cargo_basic']);
        return count($dados)==0 ? false: $dados;
    }

    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=[
            'id','cargo_id','cod_cargo_basic','des_cargo_basic',
            'orcamento_id','sal_base','sal_max','sal_med','sal_min','data_calc' 
        ];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

    public function deleteOrcCargo($data_request){        
        $retorno=true;
        $instance = $this;
        if($this->cargoExistenteOrc($data_request['cargo_id'], $data_request['orcamento_id'])>0){
            $this->setError('O Cargo está sendo utilizado como parametro em outras tabelas deste orçamento.', 'Erro: 070120201714');        
         return false;
        }
        DB::transaction(function()use(&$retorno, $data_request, $instance){
            
            $repo_calc_orcamento = new RepoCalcOrcamento();
            if(!$instance->deleteParent($data_request['id'])){    
                $retorno = true;
                
                abort(500, $retorno['msg']);
                return false;
            }                 

            if(! $repo_calc_orcamento->delete($data_request['id_calc'])){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            } 
                        
        });
        
        return $retorno;
    }

    public function deleteParent($data_request){
        $cargo = $this->find($data_request);
        return $cargo->delete();
    }

    public function cargoExistenteOrc($cargo, $orc_id){
       
        $orcCargoBeneficio = new OrcLotCargoBeneficio();
        $orcFerias = new OrcFerias();
        $orcHeadcountContratacoes = new OrcHeadcountContratacoes();
        $orcHeadcountDemissoes = new OrcHeadcountDemissoes();
        $orcamLotCargoEvento = new OrcamLotCargoEvento();
        $orcamLotCargoHeadcount = new OrcamLotCargoHeadcount();
        $orcSalarioFuncionario = new OrcSalarioFuncionario();
        $orcCargosAreaSal = new OrcCargosAreaSal();
        $orcPromocao = new OrcPromocao();
        $orcCargoPromocao = 'op';
        $tb_alias = $orcPromocao->getTable();       
        $tb_alias = $tb_alias . " AS {$orcCargoPromocao}";

        $orc_cargo = $this->getModelEntity()        
        ->leftJoin(
            $orcCargoBeneficio->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcCargoBeneficio->getColunaAlias('orcamento_id')} and 
            {$orcCargoBeneficio->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcFerias->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcFerias->getColunaAlias('orcamento_id')} and 
            {$orcFerias->getColunaAlias('cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcHeadcountContratacoes->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcHeadcountContratacoes->getColunaAlias('orcamento_id')} and             
            {$orcHeadcountContratacoes->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcHeadcountDemissoes->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcHeadcountDemissoes->getColunaAlias('orcamento_id')} and             
            {$orcHeadcountDemissoes->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcamLotCargoEvento->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcamLotCargoEvento->getColunaAlias('orc_id')} and             
            {$orcamLotCargoEvento->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcamLotCargoHeadcount->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcamLotCargoHeadcount->getColunaAlias('orc_id')} and             
            {$orcamLotCargoHeadcount->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcPromocao->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcPromocao->getColunaAlias('orc_id')} and             
            {$orcPromocao->getColunaAlias('cargo_promovido_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )->leftJoin(
            $tb_alias,
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcCargoPromocao}.orc_id and           
            {$orcCargoPromocao}.cargo_promovido_id = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )
        ->leftJoin(
            $orcSalarioFuncionario->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcSalarioFuncionario->getColunaAlias('orc_id')} and             
            {$orcSalarioFuncionario->getColunaAlias('orc_cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )    
        ->leftJoin(
            $orcCargosAreaSal->getTable(),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            '=',
            DB::raw("{$orcCargosAreaSal->getColunaAlias('orcamento_id')} and             
            {$orcCargosAreaSal->getColunaAlias('cargo_id')} = 
            {$this->getModelEntity()->getColunaAlias('id')}
            ")
        )        
        ->select(
            DB::raw("
            count(
                COALESCE(
                    {$orcamLotCargoHeadcount->getColunaAlias('id')},
                    {$orcCargoBeneficio->getColunaAlias('id')},
                    {$orcFerias->getColunaAlias('id')},
                    {$orcHeadcountContratacoes->getColunaAlias('id')},
                    {$orcHeadcountDemissoes->getColunaAlias('id')},
                    {$orcamLotCargoEvento->getColunaAlias('id')},                    
                    {$orcPromocao->getColunaAlias('id')},
                    {$orcCargoPromocao}.id,
                    {$orcSalarioFuncionario->getColunaAlias('id')},
                    {$orcCargosAreaSal->getColunaAlias('id')}
                    )) as id_orc
            ")
        )->where([
            [$this->getModelEntity()->getColunaAlias('orcamento_id'), $orc_id],
            [$this->getModelEntity()->getColunaAlias('cargo_id'), $cargo]
        ])
        ->first();
        
        return !$orc_cargo ? 0 : $orc_cargo->id_orc;

    }
} 
    

    


