<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use Illuminate\Support\Arr;
use App\Modules\Natureza51\Entities\OrcFerias;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\Turma;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\Lotacao;
use Illuminate\Support\Facades\DB;

class RepoOrcContratacoes extends RepoOrcamento
{
    
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcContratacoes';
    protected $form_rules=[
        'orcamento_id'      =>'required|exists:tbl_orcamento,id',
        'lotacao_id'        =>'required|exists:tbl_lotacao,id',
        'orc_cargo_id'      =>'required|exists:tbl_orc_cargo,id',
        'orc_turma_id'          =>'required|exists:tbl_turma,id',
        'ccusto_id'         =>'required|exists:tbl_ccusto,id',
    ]; 
    protected $rules_msg=[
        'orcamento_id.required'     =>'Por gentileza, selecione um orçamento',
        'orcamento_id.exists'       =>'Por gentileza, selecione um orçamento',
        'lotacao_id.required'       =>'Por gentiliza, selecione uma lotação',
        'lotacao_id.exists'         =>'Por gentiliza, selecione uma lotação',
        'orc_cargo_id.required'     =>'O campo Cargo é obrigatório',
        'orc_cargo_id.exists'       =>'O campo Cargo é obrigatório',
        'ccusto_id.required'        =>'Por gentiliza selecione um centro de custo',
        'ccusto_id.exists'          =>'Por gentiliza selecione um centro de custo',
        'orc_turma_id.required'         =>'O campo Turma é obrigatório',
        'orc_turma_id.exists'           =>'O campo Turma é obrigatório',
    ]; 
     

    public function createContratacoes($data_request){
        $instance = $this;

        $hasErro = false;

        DB::transaction(function()use(&$hasErro, &$retorno, $data_request, $instance){
            
            $data_request = array_merge($data_request, $data_request['meses']);

            // $data_request['orc_cargo_id'] = OrcCargo::where([
            //     ['cargo_id', $data_request['cargo_id']],
            //     ['orcamento_id', $data_request['orcamento_id']]
            // ])->first()->id;
            
            if($instance->validaInsert($data_request, $retorno, $hasErro)){
                $repo_calc_orcamento = new RepoCalcOrcamento();

                $meses = $instance->dataFilterMesesCalcOrcamento($data_request);
                $data = $instance->dataFilterContratacoes($data_request);
                $data = $this->putCargoIdOnData($data,$data['orc_cargo_id']);
                $id_orc_contratacoes = $instance->checkHeadcount($data);
                if(! $id_orc_contratacoes){
                    $retorno['msg']=$instance->getErrosFlatted();
                    $retorno['submsg']='Falha ao inserir o registro. Erro: 031220192047';
                    $hasErro = true;
                    abort(500, $retorno['msg']);
                    return false;
                }   
                
                
                $merge_tb_calc = [
                    'origem_id' => $id_orc_contratacoes->id,
                    'tbl_origem' => $instance->getModelEntity()->getTable()
                ];
                // dd(array_merge($merge_tb_calc, $meses));
                if(! $repo_calc_orcamento->create(array_merge($merge_tb_calc, $meses))){
                    $retorno['submsg']='Falha ao inserir o registro. Erro: 031220192046';
                    $retorno['msg']=$repo_calc_orcamento->getErrosFlatted();
                    $hasErro = true;
                    abort(500, $retorno['msg']);
                    return false;
                }
            }

        });

        if($hasErro){
            goto saida;
        }

        $retorno["title"]="Parábens!";
        $retorno["status"]="success";
        $retorno["msg"]="Cadastro realizado com sucesso!";
        
        saida:
        return $retorno;
    }
    public function updateContratacoes($form_data){
        $repo_calc_orcamento=new RepoCalcOrcamento();
        $calc_orc_id=$form_data['id'];
        $meses_calc_orc = $this->dataUpdateContratacoes($form_data); 

        if(!$calc_orc_id){
            $retorno['msg'] = 'Registro não encontrado!';
            $retorno['submsg']='Falha ao fazer update do registro. Erro: 051220191958';
            goto saida;  
        }
        if(!$repo_calc_orcamento->update($meses_calc_orc, $calc_orc_id)){  
            $retorno['msg'] = $this->getErrosFlatted();
            $retorno['submsg']='Falha ao fazer update do registro. Erro: 211120191924';
            goto saida;               
        }       
        
        $retorno = array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
        saida:
        return $retorno;
        
        
    }


    public function validaInsert($data_request, &$retorno, &$hasErro){
        $existe = $this->getModelEntity()::where([
            ['orc_cargo_id', $data_request['orc_cargo_id']],
            ['orcamento_id', $data_request['orcamento_id']],
            ['lotacao_id', $data_request['lotacao_id']],
            ['orc_turma_id', $data_request['orc_turma_id']],
            ['ccusto_id', $data_request['ccusto_id']],
        ])->count();

        if($existe != 0){                
            $retorno['msg']='Esse registro já existe!';
            $retorno['submsg']='Falha ao inserir o registro. Erro: 041220191357';
            $hasErro = true;
            return false;
        }

        return true;
    }

    public function dataUpdateContratacoes($data){
        $array_orcamento=['cod_ccusto','cod_cargo_basic', 'des_cargo_basic', 'atual', 'turno', 'turma', 'id' ,'tb'];
        $meses=['jan', 'fev', 'mar', 'abr', 'mai', 'jun', 'jul', 'ago', 'set', 'out', 'nov', 'dez'];
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
        $mes_atual="";
        $meses_headcount=[];
        
        foreach($filtered as $chave=>$valor){            
            $mes_atual=$chave."_orcado";                 
            $meses_headcount[$mes_atual]=$valor;   
        }

        return $meses_headcount;
    }

    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['meses', 'funcionario_id', 'orc_id', 'lotacao_id','cargo_id','orc_turma_id', 'lotacao_responsavel','orcamento_id','type', 'orc_cargo_id', 'ccusto_id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }
    public function dataFilterContratacoes($data){
        $array_orcamento=['meses','tbl_origem','cargo_id','nome_funcionario','des_cargo_basic_ancestral','des_cargo_basic_corrente','origem_id','id'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

}
