<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Atividades;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcLotacao;
use Illuminate\Support\Facades\DB;
use Monolog\Handler\IFTTTHandler;

class RepoOrcCronograma extends RepoOrcamento
{
    
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcCronograma';
    protected $form_rules=[
        'orcamento_id'  =>'required|exists:tbl_orcamento,id',
        'activity_id'   =>'required|exists:tbl_activities,id',
        'start_date'    =>'required',
        'end_date'      =>'required' 
        // 'creator_id'      =>'required|exists:tbl_orc_cargo,id',
    ]; 
    protected $rules_msg=[
        'orcamento_id.required' =>'Selecione um orçamento para continuar a operação.',
        'orcamento_id.exists'   =>'Selecione um orçamento para continuar a operação.',
        'activity_id.required'  =>'Selecione uma atividade para continuar a operação.',
        'activity_id.exists'    =>'Selecione uma atividade para continuar a operação.',
        'start_date.required'   =>'Preencha o campo data início para continuar a operação',
        'end_date.required'     =>'Preencha o campo data fim para continuar a operação'
    ];   

    public function __construct()
    {   
        parent::__construct();
    }

    public function listar($orc_id){
        $atividade = new Atividades();
        $all = $this->getModelEntity()->leftJoin($atividade->getTable(),$atividade->getColunaAlias('id'),
        $this->getModelEntity()->getColunaAlias('activity_id'))
        ->select(
            $this->getModelEntity()->getColunaAlias('id'),
            $this->getModelEntity()->getColunaAlias('activity_id'),
            $this->getModelEntity()->getColunaAlias('orc_lotacao_id'),
            $this->getModelEntity()->getColunaAlias('status'),
            $this->getModelEntity()->getColunaAlias('start_date'),
            $this->getModelEntity()->getColunaAlias('end_date'),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            $atividade->getColunaAlias('title'),
            $atividade->getColunaAlias('description')
        )
        ->where('orcamento_id',$orc_id)->get()->toArray(); 
        foreach ($all as $key => $value) {
            $value['activity_id'] =intval($value['activity_id']);
        } 

        return $all;

    }

    public function verifyBudget(){
        $crono_name_space = $this->getModelNameSpace();
        $repo_lotacao = new RepoOrcLotacao();
        $repo_orc = $this->getOrcInstanceNew();
        $whereIn = [$this->getStatusLiberado(),$this->getStatusFinalizado()];
        $all_orc = $repo_orc->getModelEntity()
        ->where('is_suspended',0)
        ->whereIn('status_orc',$whereIn)->get()->toArray();

        // $all = $this->findBy('status_orc',$this->getStatusLiberado());
        DB::beginTransaction();
        
        try {
            
            /**Percorrendo os orçamentos */
            foreach ($all_orc as $orc) {
                $dt_atual = strtotime(Date('Y-m-d'));
                $orc_id = $orc['id'];
                $lotacoes = $repo_lotacao->getModelEntity()->where([
                    ['orcamento_id',$orc_id],
                    // ['status',$this->getStatusPendente()]
                ])->get()->toArray(); 

                $cronogramas = $this->getModelEntity()->where([
                    ['orcamento_id',$orc_id],       
                    // ['status',$this->getStatusPendente()]
                ])->get()->toArray();
            
                /**Percorrendo as atividades do Cronograma */
                foreach ($cronogramas as $cronograma) {
                    $crono_id = $cronograma['id'];
                    $crono_status = $cronograma['status'];
                    $end_date = strtotime($cronograma['end_date']);
                    $start_date = strtotime($cronograma['start_date']);
                    $validation = $dt_atual < $start_date;
                    /**Percorrendo as atividades da lotação*/ 
                    foreach ($lotacoes as $lotacao) {
                        $lot_name_space =$repo_lotacao->getModelNameSpace();
                        $lot_id = $lotacao['id'];
                        $lot_status = $lotacao['status'];
            
                         /**Verifica se a atividade está vencida */
                        if($end_date == $dt_atual){
                            /** SE A LOTAÇÃO FOR PENDENTE OU EM ANDAMENTO ENVIA PELO SISTEMA */
                            if($lot_status == $this->getStatusPendente() || $lot_status == $this->getStatusEmAndamento()){
                                $sendLot = $this->sendSystemStatus($lot_id,$lot_name_space);
                                if($sendLot['status'] != 'success'){ 
                                    return false;
                                }
                                // $sendCrono = $this->completedStatus($crono_id,$crono_name_space);
                                // if($sendCrono['status'] != 'success'){
                                //     return false;
                                // }
                            }
                               
                        }
                        
                        /**Verifica se a atividade já iníciou */
                        if($start_date == $dt_atual){
                          
                            if($lot_status == $this->getStatusPendente() || $lot_status == $this->getStatusEmAndamento()){
                               
                                $sendLot = $this->inProgressStatus($lot_id,$lot_name_space);

                                if($sendLot['status'] != 'success'){ 
                                    return false;
                                }
                                // $sendCrono = $this->inProgressStatus($crono_id,$crono_name_space);
                                // if($sendCrono['status'] != 'success'){
                                //     return false;
                                // }
                            }
                            /**SE A LOTAÇÃO FOR FINALIZADA / PRONTA PARA FORECAST */
                            if($lot_status == $this->getStatusFinalizado()){
                                $sendLot = $this->inExecutionStatus($lot_id,$lot_name_space);
                                if($sendLot['status'] != 'success'){ 
                                    return false;
                                }
                            }
                        }  
                    }
                }  
            }
            saida:
            DB::commit();

        } catch (\Exception $e) {
            abort(500,'Tente novamente mais tarde. Erro: 040220201010. '.$e);
        }
        return 'ok';
            // try {
            //     foreach ($all_orc as $key => $value) {
            //         $dt_atual = strtotime(Date('Y-m-d'));
            //         $orc_id = $value['id'];
            //         $repo_lotacao->findBy('orcamento_id',$orc_id);
                    
            //         $cronogramas = $this->getModelEntity()->where([
            //              ['orcamento_id',$orc_id],
            //             ['status',1]
            //         ])->get()->toArray();
                    
        
            //         foreach ($cronogramas as $cronograma) {
            //             if($cronograma['end_date']/*== Date('Y-m-d')*/){
                          
                               
            //                 $cronograma['status'] = $this->getStatusFinalizado();   
            //                 dd($cronograma);                                      
            //                 if(!$this->updated($cronograma,$cronograma['id'])){
            //                     abort(500,'Tente novamente mais tarde. Erro: 030220202021.');
            //                 }
        
            //             }
        
            //             // if(strtotime($cronograma['start_date']) >= $dt_atual ){
        
            //             // }
            //             // dd('samuel',$cronograma['end_date']);
        
            //         }
        
            //         // if($this->end_date == Date('Y-m-d')){
                    
            //         // }    
            //     }
            //     DB::commit();
            // } catch (\Exception $th) {
            //     DB::rollBack();
            //     abort(500,'Tente novamente. Erro: 030220202117.');
            // }


    }

    public function updated($array,$id){
        // dd('aaaaaasamue',$array);
        if(!$this->update($array,$id)){
            return false;
        }

        return true;
    }

    public function insertCronograma($form_data){
       
    //  $count_lot = count($form_data['op_values']);
     DB::beginTransaction();

     try {
      
       foreach ($form_data['op_values'] as $value) {
           $form_data['orc_lotacao_id'] = $value;

           $select = $this->getModelEntity()->where([
               ['orcamento_id',$form_data['orcamento_id']],
               ['orc_lotacao_id',$value],
               ['activity_id',$form_data['activity_id']]
           ])->get()->toArray();
          

        //  dd($select);

           if(!empty($select)){
               $this->setError('Registro já inseridos. Erro: 020320201424.');
               return false;
           }
        
           $create =$this->create($form_data);

           if(!$create){
            $this->setError('Falha ao inserir o registro. Erro: 020320201412.');
             return false;
           }

       }

       DB::commit();
     } catch (\Exception $e) {
         DB::rollBack();
         abort(500,'Erro ao inserir o registro. Erro: 020320201146. '.$e);
     }

     return true;


    }

    public function updateCronograma($form_data){
         
        $edit = $this->update($form_data,$form_data['id']);

        if(!$edit){
           $this->setError('Erro ao atualizar o registro. Erro: 020320201548');
            return false;
        }
        return true;
    }


    public function deleteCronograma($id){
        // dd($id['id']);
        $delete = $this->delete($id['id']);

        if(!$delete){
            $this->setError('Erro ao deletar o registro. Erro: 020320201607');
             return false;
         }
         return true;
    }
    
}