<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Despesas;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\OrcDespesas;
use App\Modules\Natureza51\Entities\OrcLotacao;
use Illuminate\Support\Arr;
use Exception;
use Illuminate\Support\Facades\DB;

class RepoOrcDespesas extends RepositoryNat51{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcDespesas';
    protected $form_rules=[];
    protected $rules_msg=[];

    public function listar($orc_id){
        $calc_orcamento=new CalcOrcamento();
        $orc_despesa=new OrcDespesas();
        $tbl_orc_lotacao=new OrcLotacao();
        $tbl_lotacao=new Lotacao();

        $a=$this->getModelEntity()->join($calc_orcamento->getTable(), $this->getModelEntity()->getColunaAlias('id'), '=', 
                                DB::raw("{$calc_orcamento->getColunaAlias('origem_id')} and 
                                {$calc_orcamento->getColunaAlias('tbl_origem')} = '{$this->getModelEntity()->getTable()}'"))
                                
                                ->leftJoin($tbl_orc_lotacao->getTable(),$this->getModelEntity()->getColunaAlias('lotacao_id'),'=',$tbl_orc_lotacao->getColunaAlias('id'))

                                ->leftJoin($tbl_lotacao->getTable(),$tbl_orc_lotacao->getColunaAlias('lotacao_id'),'=',$tbl_lotacao->getColunaAlias('id'))

                                ->select(
                                    DB::raw($calc_orcamento->getColunaAlias('id')),
                                   
                                    $calc_orcamento->getColunaAlias('origem_id'),
                                    $orc_despesa->getColunaAlias('orc_id'), 
                                    $orc_despesa->getColunaAlias('lotacao_id'),
                                    $orc_despesa->getColunaAlias('despesa_id'),
                                    $orc_despesa->getColunaAlias('centro_custo_id'),
                                    $orc_despesa->getColunaAlias('valor_referencia'),
                                    $calc_orcamento->getColunaAlias('tbl_origem'),
                                    $tbl_lotacao->getColunaAlias('des_unid_lotac'),
                                    $calc_orcamento->getColunaAlias('jan_orcado'),
                                    $calc_orcamento->getColunaAlias('fev_orcado'),
                                    $calc_orcamento->getColunaAlias('mar_orcado'),
                                    $calc_orcamento->getColunaAlias('abr_orcado'),
                                    $calc_orcamento->getColunaAlias('mai_orcado'),
                                    $calc_orcamento->getColunaAlias('jun_orcado'),
                                    $calc_orcamento->getColunaAlias('jul_orcado'),
                                    $calc_orcamento->getColunaAlias('ago_orcado'),
                                    $calc_orcamento->getColunaAlias('set_orcado'),
                                    $calc_orcamento->getColunaAlias('out_orcado'),
                                    $calc_orcamento->getColunaAlias('nov_orcado'),
                                    $calc_orcamento->getColunaAlias('dez_orcado'),
                                    $this->getModelEntity()->getColunaAlias('id'),
                                    
                                )
                                ->where('orc_id','=',$orc_id)->with('getDespesas', 'getLotacao')
                                ->get()->toArray();

        
        for($i=0;$i<count($a);$i++){
            $a[$i]['descricao']=$a[$i]['get_despesas']['descricao'];
            //$a[$i]['des_unid_lotac']=$a[$i]['get_lotacao']['des_unid_lotac'];
            //$a[$i]['description']=$a[$i]['lotacao_id'].' - '.$a[$i]['des_unid_lotac'];
            $a[$i]['valor_referencia']=formatarNumeroPtBr($a[$i]["valor_referencia"]);
            $a[$i]['jan_orcado']=formatarNumeroPtBr($a[$i]["jan_orcado"]);
            $a[$i]['fev_orcado']=formatarNumeroPtBr($a[$i]["fev_orcado"]);
            $a[$i]['mar_orcado']=formatarNumeroPtBr($a[$i]["mar_orcado"]);
            $a[$i]['abr_orcado']=formatarNumeroPtBr($a[$i]["abr_orcado"]);
            $a[$i]['mai_orcado']=formatarNumeroPtBr($a[$i]["mai_orcado"]);
            $a[$i]['jun_orcado']=formatarNumeroPtBr($a[$i]["jun_orcado"]);
            $a[$i]['jul_orcado']=formatarNumeroPtBr($a[$i]["jul_orcado"]);
            $a[$i]['ago_orcado']=formatarNumeroPtBr($a[$i]["ago_orcado"]);
            $a[$i]['set_orcado']=formatarNumeroPtBr($a[$i]["set_orcado"]);
            $a[$i]['out_orcado']=formatarNumeroPtBr($a[$i]["out_orcado"]);
            $a[$i]['nov_orcado']=formatarNumeroPtBr($a[$i]["nov_orcado"]);
            $a[$i]['dez_orcado']=formatarNumeroPtBr($a[$i]["dez_orcado"]);
            
            unset($a[$i]['get_despesas']);
            unset($a[$i]['get_lotacao']);
            

        } 

        return $a;
    }
    public function insertWithMeses($data){
        $orcamento=array(

            'tbl_origem'=>"tbl_orc_despesas",
            'jan_orcado'=>$data['jan_orcado'], 'fev_orcado'=>$data['fev_orcado'],
            'mar_orcado'=>$data['mar_orcado'], 'abr_orcado'=>$data['abr_orcado'], 
            'mai_orcado'=>$data['mai_orcado'], 'jun_orcado'=>$data['jun_orcado'], 
            'jul_orcado'=>$data['jul_orcado'], 'ago_orcado'=>$data['ago_orcado'],
            'set_orcado'=>$data['set_orcado'], 'out_orcado'=>$data['out_orcado'], 
            'nov_orcado'=>$data['nov_orcado'], 'dez_orcado'=>$data['dez_orcado'],
        );
        
        $calc_orcamento = new RepoCalcOrcamento();
        $despesa_array = array(
            'orc_id'=>$data['orc_id'],
            'despesa_id'=>$data['despesa_id'],
            'lotacao_id'=>$data['lotacao_id'],
            'centro_custo_id'=>$data['centro_custo_id'],
            'valor_referencia'=>$data['valor_referencia']
        );
        DB::beginTransaction();

            try {
                $despesa = parent::create($despesa_array);
                if(!$despesa){
                    $this->setError("erro!");
                    return false;
                }
                $orcamento['origem_id']=$despesa->id;
                
                $inseriu=$calc_orcamento->create($orcamento);

                if(!$inseriu){
                    $this->setError("erro no inserir");
                    return false;
                }

                DB::commit();
                goto saida;

            }catch (Exception $th) {
                DB::rollBack();
                abort(500,'Erro ao tentar inserir registro 100120201749'.$th);
            }

        saida:
        $retorno['status']="success";
        $retorno['msg']='Sucesso';
        $retorno['submsg']='Inserido com sucesso';

        return $retorno;
    }
    public function deleteDespesa($value){
        $repo_calc=new RepoCalcOrcamento();
        $id=$value['id'];
        
        DB::beginTransaction();
        try {
            $result=$repo_calc->getModelEntity()->where($repo_calc->getModelEntity()->getColunaAlias('origem_id'),'=',$id)->delete();
           
            if(!$result){
                $this->setError("Erro ao excluir registro. erro:110220201630");
                return false;
            }
            
            $del_despesas=$this->delete($value['origem_id']);
            
            if(!$del_despesas){
                return false;
            }
            DB::commit();
            goto saida;

        } catch (Exception $th) {
            DB::rollBack();
            abort(500,"Erro ao excluir registro. erro:11022020".$th);
        }

        saida:
        $retorno['status']="success";
        $retorno['msg']='Sucesso';
        $retorno['submsg']='Registro deletado com sucesso!';
        return $retorno;
    }

    public function updateDespCalc($data,$attribute){
        
        $calc_orcamento=new RepoCalcOrcamento();
        $despesa_orc=Arr::only($data,['origem_id','valor_referencia']);
        $calc_orc=Arr::except($data,['descricao','valor_referencia','_token']);
        
        $vlr_referencia=convertDecimalEn([$despesa_orc['valor_referencia']]);
        $origem_id=intval($despesa_orc['origem_id']);
        
        $env_desp_orc=array(
                    'origem_id'=>$origem_id,
                    'valor_referencia'=>$vlr_referencia
        );
        //dd($env_desp_orc);
        if($env_desp_orc['valor_referencia']<=0){
            $this->setError("Erro ao atualizar registro. erro:120220201505");
            return false;
        }
        
        
        // if(!$calc_orc['jan_orcado']<0){
        //     dd("dsdcsdcsdcsdcsdcsdcsdc");
        // }

        DB::beginTransaction();
        $id_despesa_orc=$env_desp_orc['origem_id'];
        // dd('sasasa', $despesa_orc['valor_referencia'], convertDecimalEn([$despesa_orc['valor_referencia']]));
        
        $valor= array('valor_referencia'=>$env_desp_orc['valor_referencia'][0]);

        try{
            //dd("chegou aqui",$valor,$valor,$id_despesa_orc);
            $result=$this->update($valor,$id_despesa_orc);
            
            if(!$result){
        
                $this->setError("Erro ao atualizar registro. erro:120220201035");
                return false;
            }  
            
            $meses=Arr::except($calc_orc,['id','origem_id','des_unid_lotac']);
            $id_calc_orc=$calc_orc['id'];

            $select_calc_orc=$calc_orcamento->getModelEntity()->select('id')->where([
                [$calc_orcamento->getModelEntity()->getColunaAlias('origem_id'),'=',$id_calc_orc],
                [$calc_orcamento->getModelEntity()->getColunaAlias('tbl_origem'),'=','tbl_orc_despesas']
            ])->get()->toArray();

            $id_calc_orc_select=$select_calc_orc[0]['id'];
            
            $meses_conv=convertDecimalEn($meses);
        
            //dd($meses_conv);
            $result_calc=$calc_orcamento->update($meses_conv,$id_calc_orc_select); 

            if(!$result_calc){
                $this->setError("Erro ao atualizar registro. erro:120220201041");
                return false;
            }
            
            DB::commit();
            goto saida;
        }
        catch(Exception $th){
            DB::rollBack();
            abort(500,"Erro ao atualizar registro. erro:120220201042".$th);
        }

        saida:
        $retorno['status']="success";
        $retorno['msg']='Sucesso';
        $retorno['submsg']='Registro atualizado com sucesso!';
        return $retorno;

    }

}