<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Entities\OrcFerias;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\Turma;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\Lotacao;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;
class RepoOrcDiarioBordo extends RepoOrcamento
{
    
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcDiarioBordo';
    protected $form_rules=[
        'orcamento_id'     =>'required|exists:tbl_orcamento,id',
        'lotacao_id'       =>'required|exists:tbl_lotacao,id',
        'usuario_id'       =>'required',
        'registro_id'      =>'required',
        'tbl_origem'       =>'required',
        'coluna_origem'    =>'required',
        'titulo'           =>'required',
        'descricao'        =>'required',
        
    ]; 
    protected $rules_msg=[
        'orcamento_id.required'     =>'Selecione um orçamento para continuar a operação!',
        'orcamento_id.exists'       =>'Orçamento inexistente, tente novamente.',
        'lotacao_id.required'       =>'Selecione uma lotação para continuar a operação',
        'lotacao_id.exists'         =>'Lotação inexistentes, tente novamente.',
        'usuario_id.required'       =>'Especifique o usuário ou faça o login novamente para continuar a operação.',
        'registro_id.required'      =>'Especifique o registro para continuar a operação.',
        'tbl_origem.required'       =>'Especifique a tabela de origem para continuar a operação.',
        'coluna_origem.required'    =>'Especifique a coluna origem para continuar a operação.',
        'titulo.required'           =>'O campo titulo é obrigatório.',
        'descricao.required'        =>'O campo descricao é obrigatório.'      
    ]; 
 

    public function listByRules($data){
        $dados = Arr::except($data,['_token','titulo','descricao']);
        // dd($dados);
        return $this->getModelEntity()->where($dados)->get();
    }
     
}