<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcCargo;
use App\Modules\Natureza51\Repositories\RepoCargo;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Arr;
class RepoOrcDissidio extends RepoOrcamento
{
    
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcDissidio';
    protected $form_rules=[
        'orcamento_id'     =>'required|exists:tbl_orcamento,id',
        'orc_cargo_id'       =>'required|exists:tbl_orc_cargo,id'
    ]; 
    protected $rules_msg=[
        'orcamento_id.required'  =>'Selecione um orçamento para continuar a operação!',
        'orcamento_id.exists'    =>'Orçamento inexistente, tente novamente.',
        'orc_cargo_id.required'  =>'Selecione um cargo para continuar a operação',
        'orc_cargo_id.exists'    =>'Cargo inexistentes, tente novamente.'
    ]; 

    public function listar($orc_id){
        $repo_orc_cargo = new RepoOrcCargo();
        $repo_cargo=new RepoCargo();
        $repo_calc_orc = new RepoCalcOrcamento();
        
        $calc_orc_entity = $repo_calc_orc->getModelEntity();
        $orc_cargo_entity = $repo_orc_cargo->getModelEntity();
        $cargo_entity = $repo_cargo->getModelEntity();

        $list = $this->getModelEntity()
        ->leftJoin($orc_cargo_entity->getTable(),$orc_cargo_entity->getColunaAlias('id'),$this->getModelEntity()->getColunaAlias('orc_cargo_id'))
        ->leftJoin($cargo_entity->getTable(),
        $cargo_entity->getColunaAlias('id'),$orc_cargo_entity->getColunaAlias('cargo_id'))
        ->leftJoin(
            $calc_orc_entity->getTable(),
            $this->getModelEntity()->getColunaAlias('id'),'=',
            DB::raw("{$calc_orc_entity->getColunaAlias('origem_id')} and {$calc_orc_entity->getColunaAlias('tbl_origem')} = '{$this->getModelEntity()->getTable()}'"))
        ->select(
            $this->getModelEntity()->getColunaAlias('id'),
            $this->getModelEntity()->getColunaAlias('orc_cargo_id'),
            $this->getModelEntity()->getColunaAlias('orcamento_id'),
            $orc_cargo_entity->getColunaAlias('cargo_id'),
            $cargo_entity->getColunaAlias('des_cargo_basic'),
            $cargo_entity->getColunaAlias('cod_cargo_basic'),
            DB::raw("LEFT({$cargo_entity->getColunaAlias('cod_cargo_basic')}, 2) as grade_salarial"),
            DB::raw($calc_orc_entity->getColunaAlias('id').' as id_calc_orc'),
            DB::raw("format({$orc_cargo_entity->getColunaAlias('jan_orcado')}, 'N0', 'pt-br') AS jan_orcado"),
            DB::raw("format({$orc_cargo_entity->getColunaAlias('fev_orcado')}, 'N0', 'pt-br') AS fev_orcado"),
            DB::raw("format({$orc_cargo_entity->getColunaAlias('mar_orcado')}, 'N0', 'pt-br') AS mar_orcado"),
            DB::raw("format({$orc_cargo_entity->getColunaAlias('abr_orcado')}, 'N0', 'pt-br') AS abr_orcado"),
            DB::raw("format({$orc_cargo_entity->getColunaAlias('mai_orcado')}, 'N0', 'pt-br') AS mai_orcado"),
            DB::raw("format({$orc_cargo_entity->getColunaAlias('jun_orcado')}, 'N0', 'pt-br') AS jun_orcado"),
            DB::raw("format({$orc_cargo_entity->getColunaAlias('jul_orcado')}, 'N0', 'pt-br') AS jul_orcado"),
            DB::raw("format({$orc_cargo_entity->getColunaAlias('ago_orcado')}, 'N0', 'pt-br') AS ago_orcado"), 
            DB::raw("format({$orc_cargo_entity->getColunaAlias('set_orcado')}, 'N0', 'pt-br') AS set_orcado"),
            DB::raw("format({$orc_cargo_entity->getColunaAlias('out_orcado')}, 'N0', 'pt-br') AS out_orcado"),
            DB::raw("format({$orc_cargo_entity->getColunaAlias('nov_orcado')}, 'N0', 'pt-br') AS nov_orcado"),
            DB::raw("format({$orc_cargo_entity->getColunaAlias('dez_orcado')}, 'N0', 'pt-br') AS dez_orcado")
        )
        ->where($this->getModelEntity()->getColunaAlias('orcamento_id'),$orc_id)
        ->get()
        ->toArray();

        return $list;


    }
    public function inserir($grades,$orc_id,$meses){
         
        $repo_orc_cargo = new RepoOrcCargo();
        $repo_cargo = new RepoCargo();
        
        $orc_cargo_entity = $repo_orc_cargo->getModelEntity();
        $cargo_entity = $repo_cargo->getModelEntity();
        
        DB::beginTransaction();
        try {
            
           foreach ($grades as $grade) {
                $cargos_result = $orc_cargo_entity->leftJoin($cargo_entity->getTable(),$orc_cargo_entity->getColunaAlias('cargo_id'),$cargo_entity->getColunaAlias('id'))
                ->select($orc_cargo_entity->getColunaAlias('id'),$cargo_entity->getColunaAlias('cod_cargo_basic'),$orc_cargo_entity->getColunaAlias('cargo_id')
                )
                ->where($cargo_entity->getColunaAlias('cod_cargo_basic'), 'like',$grade.'%')
                ->where($orc_cargo_entity->getColunaAlias('orcamento_id'),$orc_id)->get()->toArray();
            
                foreach ($cargos_result as $cargo) {
                    $insert = array('orcamento_id'=>$orc_id,'orc_cargo_id'=>$cargo['id']);
                    $exists = $this->getModelEntity()->where([
                        ['orcamento_id',$orc_id],
                        ['orc_cargo_id',$cargo['id']]
                    ])->get()->toArray();
                        
                    if(count($exists)>0){
                        $retorno = array('status'=>'error','msg'=>'Falha ao inserir o registro. Dados já cadastrados. Erro: 070220200954.');
                        continue;
                    }               
                    
                    $dissidio = parent::create($insert);

                    if(!$dissidio){
                        $retorno = array('status'=>'error','msg'=>$dissidio->getErrosFlatted());
                        goto saida;
                    }
                }
            }

            
            $res_calc_orc = $this->createCalcOrc($orc_id, $meses);

            if($res_calc_orc['status'] != 'success'){
                abort(500,'Falha ao inserir o registro. Erro: 050320201500');
            }

            $retorno = array('status'=>'success','msg'=>'Registro inserido com sucesso!');
            DB::commit();  
            
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao inserir o registro. Erro: 060220202041');
        }
        saida:
        return $retorno;
    }
    public function editar($all){
        $meses = $this->filterMesesCalcOrcamento($all);
        $repo_calc_orc = new RepoCalcOrcamento();
        DB::beginTransaction();
        try {
            
            $update_calc_orc = $repo_calc_orc->update($meses,$meses['id_calc_orc']);
            if(!$update_calc_orc){
                $retorno = array('status'=>'error','msg'=>$repo_calc_orc->getErrosFlatted());
                goto saida;
            }

            $retorno = array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao atualizar o registro. Erro: 070220201450.');
        }
        saida:
        return $retorno;

    }
    public function deletar($all){
 
        $meses = $this->filterMesesCalcOrcamento($all);
        $repo_calc_orc = new RepoCalcOrcamento();
        DB::beginTransaction();
        try {
            $delete_dissidio = $this->delete($all['id']);
            if(!$delete_dissidio){
                $retorno = array('status'=>'error','msg'=>'$repo_calc_orc->getErrosFlatted()');
                goto saida;
            }

            $delete_calc_orc = $repo_calc_orc->delete($meses['id_calc_orc']);
            if(!$delete_calc_orc){
                $retorno = array('status'=>'error','msg'=>'$repo_calc_orc->getErrosFlatted()');
                goto saida;
            }

            $retorno = array('status'=>'success','msg'=>'Registro deletado com sucesso!');
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao atualizar o registro. Erro: 070220201538.');
        }
        saida:
        return $retorno;

    }
    public function filterMesesCalcOrcamento($data){
        $array_orcamento=['orcamento_id', 'orc_cargo_id', 'cod_cargo_basic', 'des_cargo_basic','cargo_id','turma_id', 'grade_salarial','id'];
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
        return $filtered;
    }

    public function createCalcOrc($orc_id, $meses){
        $repo_orc_cargo = new OrcCargo();        
        $repo_calc_orc = new CalcOrcamento();        
        $orc_dissidio = $this->getModelEntity();

        $ids_orc_dissidio = $orc_dissidio->join(
                                        $repo_orc_cargo->getTable(), $repo_orc_cargo->getColunaAlias('orcamento_id'), '=',                            
                                        DB::raw("{$orc_id} and {$orc_dissidio->getColunaAlias('orc_cargo_id')} = 
                                                 {$repo_orc_cargo->getColunaAlias('id')}")
                                        )->leftJoin(
                                            $repo_calc_orc->getTable(), $orc_dissidio->getColunaAlias('id'), '=',                            
                                        DB::raw("{$repo_calc_orc->getColunaAlias('origem_id')} and 
                                                 {$repo_calc_orc->getColunaAlias('tbl_origem')} = '{$orc_dissidio->getTable()}'")
                                    )
                ->select($orc_dissidio->getColunaAlias('id'))
                ->where($orc_dissidio->getColunaAlias('orcamento_id'),$orc_id)
                ->get()
                ->toArray();
        
        
        DB::beginTransaction();
        try {
            
                foreach($ids_orc_dissidio as $id_orc_dissidio){
                    $inf = ['origem_id'=>$id_orc_dissidio['id'],'tbl_origem'=>$this->getModelEntity()->getTable()];
                    
                    $merge_meses = array_merge($meses,$inf);
                    
                    $res_calc_orc = $repo_calc_orc->create($merge_meses);
                
                    if(!$res_calc_orc){
                        $retorno = array('status'=>'error','msg'=>'Falha ao inserir o registro. Erro: 050320201456.');
                        goto saida;
                    }
                }
        
            $retorno = array('status'=>'success','msg'=>'Registro atualizado com sucesso!');
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao atualizar o registro. Erro: 050320201455.');
        }
        saida:
        return $retorno;       
    }
 
     
}