<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoCargo;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class RepoOrcEventos extends RepoOrcamento
{
    
    //protected $model_name_space_local='App\Modules\Natureza51\Entities\OrcCargosAreaSal';
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcEventos';
    protected $form_rules=[];
    protected $rules_msg=[]; 
 
    function __construct() {
        parent::__construct();
    }

    public function listarAll($orc_id){

        $repo_calc = new RepoCalcOrcamento();


        $tbl_orc_evento = $this->getModelEntity();
        $tbl_calc_orc = $repo_calc->getModelEntity();

        $select = $tbl_orc_evento->leftJoin($tbl_calc_orc->getTable(),$tbl_orc_evento->getColunaAlias('id'),'=',DB::raw("{$tbl_calc_orc->getColunaAlias('origem_id')} and {$tbl_calc_orc->getColunaAlias('tbl_origem')} = '{$tbl_orc_evento->getTable()}'")
        )
        ->select(
            $tbl_orc_evento->getColunaAlias('id'),
            $tbl_orc_evento->getColunaAlias('orcamento_id'),
            // $tbl_orc_evento->getColunaAlias('empresa_id'),
            $tbl_orc_evento->getColunaAlias('evento_id'),
            $tbl_orc_evento->getColunaAlias('cdn_event'),
            $tbl_orc_evento->getColunaAlias('des_event'),
            $tbl_orc_evento->getColunaAlias('inc_liquido'),
            $tbl_orc_evento->getColunaAlias('impr_envel'),
            $tbl_orc_evento->getColunaAlias('multiplica'),
            DB::raw($tbl_calc_orc->getColunaAlias('id').' id_calc'),
            $tbl_calc_orc->getColunaAlias('jan_orcado'),
            $tbl_calc_orc->getColunaAlias('fev_orcado'),
            $tbl_calc_orc->getColunaAlias('mar_orcado'),
            $tbl_calc_orc->getColunaAlias('abr_orcado'),
            $tbl_calc_orc->getColunaAlias('mai_orcado'),
            $tbl_calc_orc->getColunaAlias('jun_orcado'),
            $tbl_calc_orc->getColunaAlias('jul_orcado'),
            $tbl_calc_orc->getColunaAlias('ago_orcado'),
            $tbl_calc_orc->getColunaAlias('set_orcado'),
            $tbl_calc_orc->getColunaAlias('out_orcado'),
            $tbl_calc_orc->getColunaAlias('nov_orcado'),
            $tbl_calc_orc->getColunaAlias('dez_orcado')
        )
        ->where($tbl_orc_evento->getColunaAlias('orcamento_id'),$orc_id)
        ->get()
        ->toArray();

        return $select;

    }

    public function updateAll($data){
        
        $meses = $this->dataFilterMesesCalcOrcamento($data);
        $data_evento = $this->dataFilterEventos($data);
        $repo_calc = new RepoCalcOrcamento();
        $calc_orc = new CalcOrcamento();
        $data_evento['multiplica'] = (1 + ($data['multiplica'] / 100));
        DB::beginTransaction();

        try {
            
            $update = $this->update($data_evento,['id'=>$data['id']]);

            if(!$update){
                $this->setError('Erro ao atualizar o registro. Erro: 260220202029.');
                return false;
            }
            
            $data_update['tbl_origem']=$this->getModelEntity()->getTable();

            $insert_calc = $repo_calc->update($meses, 
                                ['origem_id'=>$data['id'],'tbl_origem'=>$data_update['tbl_origem']]);

            if(!$insert_calc){
                $this->setError('Erro ao inserir o registro. Erro: 260220202110.');
                return false;
            }


            DB::commit();

        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Erro ao atualizar o registro. Erro: 260220202030.');
        }


        return true;

    }

    public function deleteAll($data){

        $repo_calc = new CalcOrcamento();

        $tbl_entitie = $this->getModelEntity()->getTable();
             
        $id_calc_orc =$repo_calc->where(
            'origem_id',$data['id']
        )->where('tbl_origem', $tbl_entitie)
        ->select('id')
        ->first();
        
        DB::beginTransaction();

        try {
            $del = $this->delete($data['id']);
            
            if(!$del){
                $this->setError('Erro ao deletar o registro. Erro: 260220202037.');
                return false;
            } 
            
            if(!is_null($id_calc_orc)){
                $del_calc_orc = $this->deleteCalcOrc($id_calc_orc);

                if(!$del_calc_orc){
                    $this->setError('Erro ao deletar o registro. Erro: 050320201929.');
                    return false;
                }
            }  

            DB::commit();
            
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Erro ao deletar o registro. Erro: 260220202032.');
        }


        return true;

    }

    public function insertAll($data){       
        
        $data['multiplica'] = (1 + ($data['multiplica'] / 100));
        
        $meses = $this->dataFilterMesesCalcOrcamento($data);
        // unset($data['meses']);
        $repo_calc = new RepoCalcOrcamento();


        $dt =$this->getModelEntity()->where([
            ['evento_id',$data['evento_id']],
            ['orcamento_id',$data['orcamento_id']]
            ])->get()->toArray(); 

           
        if(!empty($dt)){
            $this->setError('Evento já cadastrado. Erro: 260220202117');
            return false;
        }


        DB::beginTransaction();

        try {
            $insert = $this->create($data);
            if(!$insert){
                $this->setError('Erro ao inserir o registro. Erro: 260220202100.');
                return false;
            }
            $meses['origem_id']=$insert->id;
            $meses['tbl_origem']=$this->getModelEntity()->getTable();
            $insert_calc = $repo_calc->create($meses);

            if(!$insert_calc){
                $this->setError('Erro ao inserir o registro. Erro: 260220202110.');
                return false;
            }

            DB::commit();

        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Erro ao inserir o registro. Erro: 260220202105.'. $e);
        }
        return true;
    }



    public function dataFilterMesesCalcOrcamento($data){
        $array_orcamento=['id', 'evento_id', 'cdn_event','des_event','multiplica', 'cargo_corrente_id','nome_funcionario','orcamento_id','inc_liquido','evento_id','impr_envel'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

    public function dataFilterEventos($data){
        $array_orcamento=['jan_orcado', 'fev_orcado', 'mar_orcado','abr_orcado','mai_orcado', 
                        'jun_orcado','jul_orcado','ago_orcado','set_orcado','out_orcado','nov_orcado', 
                        'dez_orcado', 'id', 'multiplica'];
        
        $filtered = Arr::except($data, array_merge($array_orcamento, ['_token'] ));  
               
        return $filtered;
    }

    public function deleteCalcOrc($id_calc_orc){        
        $repo_calc = new RepoCalcOrcamento();
        
        DB::beginTransaction();

        try {                        
                        
            $del_calc_orc = $repo_calc->delete($id_calc_orc['id']);
            
            if(!$del_calc_orc){
                $this->setError('Erro ao deletar o registro. Erro: 050320201929.');
                return false;
            }

            DB::commit();
            
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Erro ao deletar o registro. Erro: 260220202032.');
        }

        return true;
    }
   
    
}
