<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Repositories\RepoCalcOrcamento;

use App\Modules\Natureza51\Entities\OrcFerias;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\Turma;
use App\Modules\Natureza51\Entities\OrcTurma;
use App\Modules\Natureza51\Entities\Turno;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\OrcLotacao;
use Illuminate\Support\Facades\DB;

class RepoOrcFerias extends RepoOrcamento
{
    
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcFerias';
    protected $form_rules=[
        'orcamento_id'=>'required',
        'lotacao_id'=>'required',
        'cargo_id'=>'required',
        'lotacao_responsavel'=>'required',
        'orc_turma_id'=>'required',
        // 'type'=>'required|string|max:1|min:1'
    ]; 
    protected $rules_msg=[
        'orcamento_id.required'=>'Por gentileza, selecione um orçamento',
        'lotacao_id.required'=>'Por gentiliza, selecione uma lotação',
        'cargo_id.required'=>'O campo Cargo é obrigatório',
        'lotacao_responsavel.required'=>'Por gentiliza selecione uma lotaçao responsável',
        'required'=>'O campo Turma é obrigatório',
        // 'type.required'=>'O campo Tipo é obrigatório'
    ]; 
      
    public function listarByTurma($orc_id, $lotacao_id, $tipo_table){

        $tbl_calc_orc = new CalcOrcamento(); //table for month;
        $tbl_lotacao = new OrcLotacao(); // table for lotação
        $tbl_turma = new OrcTurma();
        $tbl_cargo = new Cargo();
        $tbl_orc_ferias = new OrcFerias();
        // DB::enableQueryLog();
        $tb_turma = new OrcTurma();
        $tb_turno = new Turno();

        $data = $tbl_orc_ferias->join(
            $tbl_lotacao->getTable(),$tbl_orc_ferias->getColunaAlias('lotacao_id'),'=',$tbl_lotacao->getColunaAlias('id')
            )
            ->leftJoin(
                $tbl_calc_orc->getTable(),
                $tbl_orc_ferias->getColunaAlias('id'),'=', 
                DB::raw("{$tbl_calc_orc->getColunaAlias('origem_id')} and 
                                {$tbl_calc_orc->getColunaAlias('tbl_origem')} = '{$tbl_orc_ferias->getTable()}'")
            )
            ->leftJoin(
                $tbl_turma->getTable(),
                $tbl_orc_ferias->getColunaAlias('orc_turma_id'),'=',$tbl_turma->getColunaAlias('id')
            )

            ->leftJoin(
                $tb_turno->getTable(),
                $tbl_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('id'))
            ->select(
                $tbl_orc_ferias->getColunaAlias('id'),
                $tbl_orc_ferias->getColunaAlias('lotacao_id'),
                // $tb_turma->getColunaAlias('des_turma_trab'), 
                $tb_turno->getColunaAlias('des_turno_trab'),
                // $tbl_lotacao->getColunaAlias('des_unid_lotac'),
                $tbl_orc_ferias->getColunaAlias('orc_turma_id'),
                $tbl_orc_ferias->getColunaAlias('type'),
                $tbl_orc_ferias->getColunaAlias('orcamento_id'),
                $tbl_turma->getColunaAlias('des_turma_trab'),
                $tbl_orc_ferias->getColunaAlias('cargo_id'),
                DB::raw('cargo_id+null as parent'),
                $tbl_orc_ferias->getColunaAlias('lotacao_responsavel'),
                $tbl_calc_orc->getColunaAlias('jan_orcado'),
                $tbl_calc_orc->getColunaAlias('fev_orcado'),
                $tbl_calc_orc->getColunaAlias('mar_orcado'),
                $tbl_calc_orc->getColunaAlias('abr_orcado'),
                $tbl_calc_orc->getColunaAlias('mai_orcado'),
                $tbl_calc_orc->getColunaAlias('jun_orcado'),
                $tbl_calc_orc->getColunaAlias('jul_orcado'),
                $tbl_calc_orc->getColunaAlias('ago_orcado'), 
                $tbl_calc_orc->getColunaAlias('set_orcado'),
                $tbl_calc_orc->getColunaAlias('out_orcado'),
                $tbl_calc_orc->getColunaAlias('nov_orcado'),
                $tbl_calc_orc->getColunaAlias('dez_orcado')
            )
            ->where([
                        [ $tbl_orc_ferias->getColunaAlias('orcamento_id'), '=', $orc_id],
                        ['type','=',0],
                        [$tbl_orc_ferias->getColunaAlias('lotacao_id'), '=', $lotacao_id],
                        [$tbl_orc_ferias->getColunaAlias('tipo_table'),$tipo_table]
                ])
                ->get()
                ->toArray();

                // $sql=DB::getQueryLog();
        
        // for($i=0;$i<count($data);$i++){
        //     $data[$i]=array_merge($data[$i],array("description"=>$data[$i]['cdn_turma_trab'].' - '.$data[$i]['des_turma_trab']));
        // }
        
        return ($data);  
    }

    public function listarByFuncionario($orc_id, $lotacao_id, $tipo_table){

        $tbl_calc_orc = new CalcOrcamento(); //table for month;
        $tbl_lotacao = new OrcLotacao(); // table for lotação
        $tbl_turma = new OrcTurma();
        $tbl_cargo = new Cargo();
        $tbl_orc_ferias = new OrcFerias();
        // DB::enableQueryLog();
        $tb_turma = new OrcTurma();
        $tb_turno = new Turno();

        $data = $tbl_orc_ferias->join(
            $tbl_lotacao->getTable(),$tbl_orc_ferias->getColunaAlias('lotacao_id'),'=',$tbl_lotacao->getColunaAlias('id')
            )
            ->leftJoin(
                $tbl_calc_orc->getTable(),
                $tbl_orc_ferias->getColunaAlias('id'),'=', 
                DB::raw("{$tbl_calc_orc->getColunaAlias('origem_id')} and 
                                {$tbl_calc_orc->getColunaAlias('tbl_origem')} = '{$tbl_orc_ferias->getTable()}'")
            )
            ->leftJoin(
                $tbl_turma->getTable(),
                $tbl_orc_ferias->getColunaAlias('orc_turma_id'),'=',$tbl_turma->getColunaAlias('turma_id')
            )

            ->leftJoin(
                $tb_turno->getTable(),
                $tbl_turma->getColunaAlias('turno_id'), $tb_turno->getColunaAlias('turno_id'))
            ->select(
                $tbl_orc_ferias->getColunaAlias('id'),
                $tbl_orc_ferias->getColunaAlias('lotacao_id'),
                // $tb_turma->getColunaAlias('des_turma_trab'), 
                $tb_turno->getColunaAlias('des_turno_trab'),
                // $tbl_lotacao->getColunaAlias('des_unid_lotac'),
                $tbl_orc_ferias->getColunaAlias('orc_turma_id'),
                $tbl_orc_ferias->getColunaAlias('type'),
                $tbl_orc_ferias->getColunaAlias('orcamento_id'),
                $tbl_turma->getColunaAlias('des_turma_trab'),
                $tbl_orc_ferias->getColunaAlias('cargo_id'),
                DB::raw('cargo_id+null as parent'),
                $tbl_orc_ferias->getColunaAlias('lotacao_responsavel'),
                $tbl_calc_orc->getColunaAlias('jan_orcado'),
                $tbl_calc_orc->getColunaAlias('fev_orcado'),
                $tbl_calc_orc->getColunaAlias('mar_orcado'),
                $tbl_calc_orc->getColunaAlias('abr_orcado'),
                $tbl_calc_orc->getColunaAlias('mai_orcado'),
                $tbl_calc_orc->getColunaAlias('jun_orcado'),
                $tbl_calc_orc->getColunaAlias('jul_orcado'),
                $tbl_calc_orc->getColunaAlias('ago_orcado'), 
                $tbl_calc_orc->getColunaAlias('set_orcado'),
                $tbl_calc_orc->getColunaAlias('out_orcado'),
                $tbl_calc_orc->getColunaAlias('nov_orcado'),
                $tbl_calc_orc->getColunaAlias('dez_orcado')
            )
            ->where([
                    [ $tbl_orc_ferias->getColunaAlias('orcamento_id'), '=', $orc_id],
                    ['type','=',1],
                    [$tbl_orc_ferias->getColunaAlias('lotacao_id'), '=', $lotacao_id],
                    [$tbl_orc_ferias->getColunaAlias('tipo_table'),$tipo_table]
                ])
                ->get()
                ->toArray();

            return ($data); 
    }
  
    public function insertFerias($data,$meses){
        $repo_calc_orcamento = new RepoCalcOrcamento();
        
        /**
         * Colocar na Entitie o Campo tipo_table para diferenciar forecast de orçado
         * Quando Ajustar os métodos voltar aqui e descomentar o tipo_table 06/01/2020
         */

           
        $clausule = array(
            'orcamento_id'=>$data['orcamento_id'],
            'ccusto_id'=>$data['ccusto_id'],
            'lotacao_id'=>$data['lotacao_id'],
            'cargo_id'=>$data['cargo_id'],
            'orc_turma_id'=>$data['orc_turma_id'],
            // 'tipo_table'=>$data['tipo_table']
        ); 

        

        if(isset($data['func_id'])){
            // dd('aaaaa',$data['func_id']);
            $clausule['func_id'] = $data['func_id'];
            // dd($clausule);
        }

        // dd($clausule);
       
        if($this->hasDataOnDB($clausule)){
            $retorno["status"]="error";
            $retorno['msg']='Falha ao inserir o registro. Dados já cadastrados!';
            $retorno['submsg']='Falha ao inserir o registro. Erro: 181220191457';
            goto saida;
        } 

        // dd($data,'',$meses);

    

        DB::beginTransaction();
        try { 
            
            $id_orc_ferias = $this->checkHeadcount($data);
            if(!$id_orc_ferias){
                $retorno["status"]="error";
                $retorno['msg']=$this->getErrosFlatted();
                $retorno['submsg']='Falha ao inserir o registro. Erro: 181220191458.';
                goto saida;
            }    
            $merge_tb_calc = [
                'origem_id' =>$id_orc_ferias->id,
                'tbl_origem' => $this->getModelEntity()->getTable()
            ];
            $insert = array_merge($merge_tb_calc, $meses);
            // dd($insert);
            
            if(!$repo_calc_orcamento->create($insert)){
                $retorno['msg']='Falha ao inserir o registro. Erro: 181220191459.';
                $retorno['submsg']=$repo_calc_orcamento->getErrosFlatted();
                goto saida;
            }
            $retorno["status"]="success";
            $retorno["msg"]="Cadastro realizado com sucesso!";

        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao inserir registro no orçamento. Erro: 181220191500.');   
        }

        saida:
        // dd($retorno);
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();    
        return $retorno; 
    }

    public function deleteFerias($form_data){
        
        $repo_calc_orcamento = new RepoCalcOrcamento();
        $id = $form_data['id'];
        DB::beginTransaction();
        try {
            if(!$repo_calc_orcamento->getModelInstance()->where(['origem_id'=>$id,'tbl_origem'=>$this->getModelEntity()->getTable()])->delete()){                  
                $retorno["status"]="error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer delete do registro Calc Orcamento. Erro: 271120191600';
                goto saida;
            }     
            
            if(!$this->delete($id)){                  
                $retorno["status"]="error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer delete do registro. Erro: 271120191600';
                goto saida;
            }

            $retorno["status"]="success";
            $retorno["msg"]="Registro deletado com sucesso!";


        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao deletar registro no orçamento. Erro: 021220181942.'.$e);   
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();    
        return $retorno; 

    }
    public function editarFerias($id,$data,$meses){
        $repo_calc_orcamento = new RepoCalcOrcamento();
        // dd($data);
        try {
            if(!$repo_calc_orcamento->update($meses,['origem_id'=>$id,'tbl_origem'=>'tbl_orc_ferias'])){                  
                $retorno["status"]="error";
                $retorno['msg'] = $repo_calc_orcamento->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer update do registro. Erro: 271120191600';
                goto saida;               
            } 

            if(!$this->update($data, ['id'=>$id])){                  
                $retorno["status"]="error";
                $retorno['msg'] = $this->getErrosFlatted();
                $retorno['submsg']='Falha ao fazer update do registro. Erro: 271120191600';
                goto saida;               
            }
        
            $retorno["status"]="success";
            $retorno["msg"]="Registro atualizado com sucesso!";
        
        } catch (\Exception $e) {
            DB::rollBack();
            abort(500,'Falha ao deletar registro no orçamento. Erro: 021220181942.'.$e);   
        }
        saida:
        ($retorno['status'] == 'error')? DB::rollBack() : DB::commit();    
        return $retorno; 
      

    }
}
