<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\Beneficio;
use App\Modules\Natureza51\Entities\CalcIndice;
use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Entities\Cargo;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Entities\ContaContabil;
use App\Modules\Natureza51\Entities\Eventos;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\OrcBeneficio;
use App\Modules\Natureza51\Entities\OrcCargo;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Entities\OrcLotCargoBeneficio;
use App\Modules\Natureza51\Entities\Usuario;
use App\Modules\Natureza51\Http\Controllers\OrcLotacaoController;
use Exception;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class RepoOrcLotCargoBeneficio extends RepoOrcamento
{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcLotCargoBeneficio';
                            
    public function createOrclotCargoBeneficio($data_request, $id){        
       
        // $tbl_calc_orc = new CalcOrcamento();
        // $tbl_calc_ind = new CalcIndice();
        $tbl_orc_cargo = new OrcCargo();

        // $tbl_lotacao = new OrcLotacao();
        // $estrutura = new OrcLotacaoController();
        // $dados = $estrutura->makeEstrutura($data_request['orcamento_id']);
        // $lotacoes = (array_column($dados, 'lotacao_id'));
        
        // $select = $tbl_lotacao->select()->where([
        //     ['orcamento_id',$data_request['orcamento_id']],
        //     ['id',$data_request['orc_lotacao_id']]
        
        // ])
        // ->whereIn('lotacao_id',$lotacoes)
        // ->get()->toArray();

        
        // if(count($select) == 0){
        //     $this->setError("Impossível acessar a lotação selecionada. <br>Erro: 200520201555");
        //     return false;
        // }
            
        // $query = $tbl_orc_cargo->select('id')->where([
        //     [$tbl_orc_cargo->getColunaAlias('cargo_id'),'=',$data_request['orc_cargo_id']],
        //     [$tbl_orc_cargo->getColunaAlias('orcamento_id'),'=',$data_request['orcamento_id']],
        //     [$tbl_orc_cargo->getColunaAlias('tipo_table'), '=', $data_request['tipo_table']]
        // ]);

        // $cargo_orc = [];
        // if($data_request['tipo_table'] == 'F'){
        //     $cargo_orc = $query->where($tbl_orc_cargo->getColunaAlias('periodo'), $data_request['periodo'])->get()->toArray();
        // }
        // else{
        //     $cargo_orc = $query->whereNull($tbl_orc_cargo->getColunaAlias('periodo'))->get()->toArray();
        // }
        
        // $data_request['orc_cargo_id'] = $cargo_orc[0]['id'];


        $query = $this->getModelEntity()->select()->where([
            [$this->getModelEntity()->getColunaAlias('orc_beneficio_id'),'=',$data_request['orc_beneficio_id']],
            [$this->getModelEntity()->getColunaAlias('ccusto_id'),'=',$data_request['ccusto_id']],
            [$this->getModelEntity()->getColunaAlias('orc_lotacao_id'),'=',$data_request['orc_lotacao_id']],
            [$this->getModelEntity()->getColunaAlias('cta_ctb_id'),'=',$data_request['cta_ctb_id']],
            [$this->getModelEntity()->getColunaAlias('orc_cargo_id'),'=',$data_request['orc_cargo_id']],
            [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=',$data_request['orcamento_id']],
            [$this->getModelEntity()->getColunaAlias('tipo_table'),'=',$data_request['tipo_table']],
        ]);
        
        $beneficio_cargo = [];
        if($data_request['tipo_table'] == 'F'){
            $beneficio_cargo = $query->where($this->getModelEntity()->getColunaAlias('periodo'), $data_request['periodo'])->get()->toArray();
        }
        else{
            $beneficio_cargo = $query->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->get()->toArray();
        }

        //dd($beneficio_cargo, $data_request);
        if(count($beneficio_cargo) > 0){
            
            /*if($data_request['tipo_meses']==2)
            {
                $select_calc_orc=$tbl_calc_orc->select()->where([
                    [$tbl_calc_orc->getColunaAlias('origem_id'),'=',$beneficio_cargo[0]['id']],
                    [$tbl_calc_orc->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
                ])->get()->toArray();
                //dd($beneficio,$select_calc_orc);
                if(count($select_calc_orc)>0)
                {
                    $this->setError("Registro já existente em valor absoluto. Erro: 070420201507");
                    return false;
                }
                else
                {
                    if(!$this->insereCalcOrc($beneficio_cargo[0]['id'],$data_request)){
                        $this->setError('Erro ao inserir registro. Erro: 070420201507');
                        return false;
                    }
                }
            }*/
            /*else if($data_request['tipo_meses']==1)
            { 
                $select_calc_ind = $tbl_calc_ind->select()->where([
                    [$tbl_calc_ind->getColunaAlias('origem_id'),'=',$beneficio_cargo[0]['id']],
                    [$tbl_calc_ind->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
                ])->get()->toArray();
                
                if(count($select_calc_ind)>0)
                {
                    $this->setError("Registro já existente em índice.  Erro: 070420201511");
                    return false;
                }
                else
                {
                    if(!$this->insereIndice($beneficio_cargo[0]['id'],$data_request)){
                        $this->setError('Erro ao inserir registro.  Erro: 070420201512');
                        return false;
                    }
                }
            }*/
            $this->setError("Registro já existente.Erro: 050620200903");
            return false;
        }
        else{
            /*if($data_request['tipo_meses']==1){
                if(!$this->createOrclotCargoBeneficioInidice($data_request,$id)){
                    $this->setError('Não foi possível inserir os índices. Erro:070420201514');
                    return false;
                }
                return true;
            }*/
            //else{
                if(!$this->insereCalcBeneficio($data_request)){
                    $this->setError('Não foi possível inserir o registro. Err:070420201515');
                    return false;
                }
                return true;
            //}
        }
        
        saida:
        $retorno['status']="success";
        $retorno['msg']='Sucesso';
        $retorno['submsg']='Inserido com sucesso';

        return $retorno;
    }

    public function insereCalcBeneficio($data_request){
        $retorno=true;
        $instance = $this;
        
        DB::transaction(function()use(&$retorno, $data_request, $instance){

            // $tbl_orc_cargo=new OrcCargo();

            // $cargo = $tbl_orc_cargo->select($tbl_orc_cargo->getColunaAlias('id'))->where([
            //     [$tbl_orc_cargo->getColunaAlias('orcamento_id'),'=',$data_request['orcamento_id']],
            //     [$tbl_orc_cargo->getColunaAlias('cargo_id'),'=',$data_request['orc_cargo_id']]
            // ])->get()->toArray();
            
            $repo_calc_orcamento = new RepoCalcOrcamento();
            
            // $data_request['orc_cargo_id'] = $cargo[0]['id'];
            
            $id_orc_lot_cargo_ben = $instance->createParent($data_request);
            
            if(! $id_orc_lot_cargo_ben){  
                $retorno = false;
                return false;
            }  
            
            $merge_tb_calc = [
                'origem_id' => $id_orc_lot_cargo_ben->id,
                'tbl_origem' => $instance->getModelEntity()->getTable()
            ];
            
            if(! $repo_calc_orcamento->create(array_merge($merge_tb_calc, $data_request['meses_orcado']))){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }
            if(!$this->insereIndice($merge_tb_calc['origem_id'], $data_request)){
                $this->setError("Falha ao inserir índice.<br>Erro: 050620200931");
                return false;
            }            
        });
        
        return $retorno;
    }
    public function insereIndice($id,$dados){
        
        $tbl_calc_indice=new CalcIndice();
        $data = $dados;
        $dados = $dados['meses_orcado'];

        $indice = 1;

        $select = $tbl_calc_indice->select()
        ->where([
            [$tbl_calc_indice->getColunaAlias('origem_id'), '=', $data['orc_beneficio_id']],
            [$tbl_calc_indice->getColunaAlias('tbl_origem'), '=', 'tbl_orc_beneficio'],
        ])->get()->toArray();
        
        if(count($select) > 0){
            $env_meses = Arr::except($select[0],['created_at','user_id','updated_at','empresa_id','updated_by','created_by','id','origem_id','tbl_origem']);
            
            $dados_indice = array_merge(array(
                'origem_id'=>$id,
                'tbl_origem'=>$this->getModelEntity()->getTable()
            ),$env_meses);
        }
        else{
            $dados_indice=array(
                'origem_id'=>$id,
                'tbl_origem'=>$this->getModelEntity()->getTable(),
                'jan_indice'=>$indice,
                'fev_indice'=>$indice,
                'marc_indice'=>$indice,
                'abril_indice'=>$indice,
                'maio_indice'=>$indice,
                'jun_indice'=>$indice,
                'jul_indice'=>$indice,
                'agost_indice'=>$indice,
                'set_indice'=>$indice,
                'out_indice'=>$indice,
                'nov_indice'=>$indice,
                'dez_indice'=>$indice
            );
        }
        //$dados_indice=convertDecimalEn($dados_indice);
        
        if(!$tbl_calc_indice->create($dados_indice)){
            $this->setError('Erro ao inserir índices. Erro:070420201512');
            return false;
        }
        return true;
    }

    public function insereCalcOrc($id,$data){
        $calc_orcamento = new CalcOrcamento();
        $data=$data['meses_orcado'];// aqui tinha um convert
        $orcamento=array(
            'origem_id'=>$id,
            'tbl_origem'=>$this->getModelEntity()->getTable()
        );
        $orcamento = array_merge($orcamento,$data);
        //dd("aqui",$calc_orcamento->create($orcamento));
        if(!$calc_orcamento->create($orcamento))
        {
            $this->setError('Erro ao inserir valores absolutos.');
            return false;
        }
        return true;
    }

    public function createOrclotCargoBeneficioInidice(array $dados,$id){

        $this->clearError();

        $tb_calc_indice=new CalcIndice();
        $tb_orc_cargo=new OrcCargo();
        $orc_cargo_id=$tb_orc_cargo->select($tb_orc_cargo->getColunaAlias('id'))->where([
            [$tb_orc_cargo->getColunaAlias('cargo_id'),$dados['orc_cargo_id']],
            [$tb_orc_cargo->getColunaAlias('orcamento_id'),$id]
        ])->get()->toArray();
        
        $dados['orc_cargo_id']=$orc_cargo_id[0]['id'];
        

        $dados_env=Arr::except($dados,['meses_orcado','tipo_meses']);
        $orcamento_id=array('orcamento_id'=>$id);
        $dados_env=array_merge($dados_env,$orcamento_id);
        //dd("asdasdasfrge",$dados_env);
        DB::beginTransaction();
        try{
            $salvou = $this->create($dados_env);
            
            if(!$salvou){
                return false;
            }
            //dd($salvou);
            $dados_indice=array(
            'origem_id'=>$salvou->id,
            'tbl_origem'=>$this->getModelEntity()->getTable(),
            'jan_indice'=>$dados['meses_orcado']['jan_orcado'],
            'fev_indice'=>$dados['meses_orcado']['fev_orcado'],
            'marc_indice'=>$dados['meses_orcado']['mar_orcado'],
            'abril_indice'=>$dados['meses_orcado']['abr_orcado'],
            'maio_indice'=>$dados['meses_orcado']['mai_orcado'],
            'jun_indice'=>$dados['meses_orcado']['jun_orcado'],
            'jul_indice'=>$dados['meses_orcado']['jul_orcado'],
            'agost_indice'=>$dados['meses_orcado']['ago_orcado'],
            'set_indice'=>$dados['meses_orcado']['set_orcado'],
            'out_indice'=>$dados['meses_orcado']['out_orcado'],
            'nov_indice'=>$dados['meses_orcado']['nov_orcado'],
            'dez_indice'=>$dados['meses_orcado']['dez_orcado'],
        );
            
            $salvar_indice=$tb_calc_indice->create($dados_indice);
            
            if(!$salvar_indice){
                $this->setError('Falha ao inserir indices. Erro: 010420201109');
                DB::rollBack();
                return false;
            }
            
            DB::commit();
            
        } catch (Exception $ex) {
             DB::rollBack();
             abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 010420201109.');
       }
       return true;
    }

    public function createParent($data_request){
        
        $query = $this->getModelEntity()->select()->where([
            [$this->getModelEntity()->getColunaAlias('ccusto_id'),'=',$data_request['ccusto_id']],
            [$this->getModelEntity()->getColunaAlias('orc_lotacao_id'),'=',$data_request['orc_lotacao_id']],
            [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=',$data_request['orcamento_id']],
            [$this->getModelEntity()->getColunaAlias('orc_beneficio_id'),'=',$data_request['orc_beneficio_id']],
            [$this->getModelEntity()->getColunaAlias('cta_ctb_id'),'=',$data_request['cta_ctb_id']],
            [$this->getModelEntity()->getColunaAlias('orc_cargo_id'),'=',$data_request['orc_cargo_id']],
            [$this->getModelEntity()->getColunaAlias('tipo_table'),'=',$data_request['tipo_table']]
        ]);
        
        $dados = [];
        if(array_key_exists('tipo_table', $data_request) && $data_request['tipo_table'] == 'F'){
            $dados = $query->where($this->getModelEntity()->getColunaAlias('periodo'), $data_request['periodo'])->get()->toArray();
        }
        else{
            $dados = $query->whereNull($this->getModelEntity()->getColunaAlias('periodo'))->get()->toArray();
        }

        
        $data_request = Arr::except($data_request, ['meses_orcado']);
            //dd("dados",$data_request);
        if(count($dados)==0){
            return parent::create($data_request);
        }else{
            $this->setError("Registro já cadastrado! erro:180220201018");
            
            abort(500, "Registro já cadastrado! erro:180220201018");
            return false;
        }
    }

    public function listarCargoBeneficioIndice($orc_id, $periodo = null, $tipo_table = 'O'){
        $tbl_cargo_beneficio = $this->getModelEntity();
        $tbl_calc_ind = new CalcIndice();
        $tbl_orc_cargo = new OrcCargo();
        $tbl_cargo = new Cargo();
        $tbl_orc_beneficio = new OrcBeneficio();
        $tbl_evento = new Eventos();
        $tbl_orc_lotacao = new OrcLotacao();
        $tbl_lotacao = new Lotacao();
        $tbl_beneficio = new Beneficio();
        $tbl_ccusto = new CentroCusto();
        $tbl_cta_ctb = new ContaContabil();
        $tbl_usuario = new Usuario();
        
        // $estrutura = new OrcLotacaoController();
        // $dados = $estrutura->makeEstrutura($orc_id);
        // $lotacoes = (array_column($dados, 'lotacao_id'));

        $query = $tbl_cargo_beneficio
        ->leftJoin($tbl_calc_ind->getTable(), $tbl_cargo_beneficio->getColunaAlias('id'), $tbl_calc_ind->getColunaAlias('origem_id'))
        ->leftJoin($tbl_orc_cargo->getTable(), $tbl_cargo_beneficio->getColunaAlias('orc_cargo_id'), $tbl_orc_cargo->getColunaAlias('id'))
        ->leftJoin($tbl_cargo->getTable(), $tbl_orc_cargo->getColunaAlias('cargo_id'), $tbl_cargo->getColunaAlias('id'))

        ->leftJoin($tbl_orc_beneficio->getTable(), $tbl_cargo_beneficio->getColunaAlias('orc_beneficio_id'), $tbl_orc_beneficio->getColunaAlias('id'))
        ->leftJoin($tbl_beneficio->getTable(), $tbl_orc_beneficio->getColunaAlias('beneficio_id'), $tbl_beneficio->getColunaAlias('id'))

        ->leftJoin($tbl_cta_ctb->getTable(), $tbl_beneficio->getColunaAlias('cta_ct_id'), $tbl_cta_ctb->getColunaAlias('id'))

        ->leftJoin($tbl_evento->getTable(), $tbl_orc_beneficio->getColunaAlias('evento_id'), $tbl_evento->getColunaAlias('id'))

        ->leftJoin($tbl_ccusto->getTable(), $tbl_cargo_beneficio->getColunaAlias('ccusto_id'), $tbl_ccusto->getColunaAlias('id'))

        ->leftJoin($tbl_orc_lotacao->getTable(), $tbl_cargo_beneficio->getColunaAlias('orc_lotacao_id'), $tbl_orc_lotacao->getColunaAlias('id'))
        ->leftJoin($tbl_lotacao->getTable(), $tbl_orc_lotacao->getColunaAlias('lotacao_id'), $tbl_lotacao->getColunaAlias('id'))

        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $tbl_calc_ind->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )

        ->select(
            $tbl_cargo_beneficio->getColunaAlias('id'),
            DB::raw("{$tbl_calc_ind->getColunaAlias('id')} as calc_indice_id"),
            $tbl_cargo_beneficio->getColunaAlias('orcamento_id'),
            $tbl_cargo_beneficio->getColunaAlias('orc_lotacao_id'),
            $tbl_cargo_beneficio->getColunaAlias('orc_cargo_id'),
            $tbl_cargo_beneficio->getColunaAlias('orc_beneficio_id'),

            //$tbl_beneficio->getColunaAlias('tipo_calc'),
            $tbl_cargo_beneficio->getColunaAlias('vlr_movto'),
            //$tbl_beneficio->getColunaAlias('vlr_depend'),
            $tbl_beneficio->getColunaAlias('formula'),
            $tbl_calc_ind->getColunaAlias('origem_id'),
            $tbl_cta_ctb->getColunaAlias('cod_cta_ctbl'),
            $tbl_cta_ctb->getColunaAlias('desc_cta_ctbl'),
            $tbl_calc_ind->getColunaAlias('tbl_origem'),
            $tbl_lotacao->getColunaAlias('des_unid_lotac'),
            DB::raw("{$tbl_evento->getColunaAlias('id')} as event_id"),
            $tbl_evento->getColunaAlias('cdn_event'),
            $tbl_evento->getColunaAlias('des_event'),
            $tbl_cargo_beneficio->getColunaAlias('cargo_id'),
            $tbl_cargo_beneficio->getColunaAlias('vlr_maximo'),
            $tbl_cargo_beneficio->getColunaAlias('tipo_calc'),

            DB::raw("CASE {$tbl_cargo_beneficio->getColunaAlias('tipo_calc')} 
                WHEN 1 THEN '1 - Por hora'
                WHEN 2 THEN '2 - Proporcional'
                WHEN 3 THEN '3 - Fixo'
                WHEN 4 THEN '4 - Dias trabalhados'
                END as des_tipo_calc"),

            $tbl_cargo->getColunaAlias('cod_cargo_basic'),
            $tbl_cargo->getColunaAlias('des_cargo_basic'),
            DB::raw("CONCAT( {$tbl_cargo->getColunaAlias('cod_cargo_basic')}, '-', {$tbl_cargo->getColunaAlias('des_cargo_basic')}) as description_cargo"),
            DB::raw("CONCAT( {$tbl_evento->getColunaAlias('cdn_event')}, '-', {$tbl_evento->getColunaAlias('des_event')}) as description_beneficio"),
            DB::raw("CONCAT( {$tbl_ccusto->getColunaAlias('cod_ccusto')}, ' - ', {$tbl_lotacao->getColunaAlias('unid_lotac')}, '-', {$tbl_lotacao->getColunaAlias('des_unid_lotac')}) as description_lotacao"),
            $tbl_ccusto->getColunaAlias('ccusto_id'),
            $tbl_ccusto->getColunaAlias('cod_ccusto'),
            $tbl_ccusto->getColunaAlias('des_ccusto'),

            $tbl_calc_ind->getColunaAlias('jan_indice'),
            $tbl_calc_ind->getColunaAlias('fev_indice'),
            $tbl_calc_ind->getColunaAlias('marc_indice'),
            $tbl_calc_ind->getColunaAlias('abril_indice'),
            $tbl_calc_ind->getColunaAlias('maio_indice'),
            $tbl_calc_ind->getColunaAlias('jun_indice'),
            $tbl_calc_ind->getColunaAlias('jul_indice'),
            $tbl_calc_ind->getColunaAlias('agost_indice'),
            $tbl_calc_ind->getColunaAlias('set_indice'),
            $tbl_calc_ind->getColunaAlias('out_indice'),
            $tbl_calc_ind->getColunaAlias('nov_indice'),
            $tbl_calc_ind->getColunaAlias('dez_indice'),
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),
            
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
            DB::raw("CASE WHEN {$tbl_calc_ind->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tbl_calc_ind->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em")
        )
        ->where([
            [$tbl_cargo_beneficio->getColunaAlias('orcamento_id'),'=',$orc_id],
            [$tbl_calc_ind->getColunaAlias('tbl_origem'),'=',$tbl_cargo_beneficio->getTable()],
            [$tbl_cargo_beneficio->getColunaAlias('tipo_table'), '=', $tipo_table]
        ]);
        //->whereIn($tbl_lotacao->getColunaAlias('id'),$lotacoes)

        $dados = [];
        if($tipo_table == 'F'){
            $dados = $query->where($tbl_cargo_beneficio->getColunaAlias('periodo'), $periodo)->get()->toArray();
        }
        else{
            $dados = $query->whereNull($tbl_cargo_beneficio->getColunaAlias('periodo'))->get()->toArray();
        }

        for($i = 0; $i < count($dados); $i++){
            $dados[$i]['description_cta_ctb'] = $dados[$i]['cod_cta_ctbl'].' - '.$dados[$i]['desc_cta_ctbl'];
            $dados[$i]['identificador']="1";
        }

        return $dados;
    }

    public function listar($data, $periodo = null, $tipo_table = 'O'){
        $orc_id = $data['orcamento_id'];

        $tbl_cargo_beneficio = $this->getModelEntity();
        $tbl_calc_orc = new CalcOrcamento();
        $tbl_orc_cargo = new OrcCargo();
        $tbl_cargo = new Cargo();
        $tbl_orc_beneficio = new OrcBeneficio();
        $tbl_evento = new Eventos();
        $tbl_orc_lotacao = new OrcLotacao();
        $tbl_lotacao = new Lotacao();
        $tbl_beneficio = new Beneficio();
        $tbl_ccusto = new CentroCusto();
        $tbl_cta_ctb = new ContaContabil();
        $tbl_usuario = new Usuario();
        
        // $estrutura = new OrcLotacaoController();
        // $dados = $estrutura->makeEstrutura($orc_id);
        // $lotacoes = (array_column($dados, 'lotacao_id'));

        $query = $tbl_cargo_beneficio
        ->leftJoin($tbl_calc_orc->getTable(), $tbl_cargo_beneficio->getColunaAlias('id'), $tbl_calc_orc->getColunaAlias('origem_id'))
        ->leftJoin($tbl_orc_cargo->getTable(), $tbl_cargo_beneficio->getColunaAlias('orc_cargo_id'), $tbl_orc_cargo->getColunaAlias('id'))
        ->leftJoin($tbl_cargo->getTable(), $tbl_orc_cargo->getColunaAlias('cargo_id'), $tbl_cargo->getColunaAlias('id'))

        ->leftJoin($tbl_orc_beneficio->getTable(), $tbl_cargo_beneficio->getColunaAlias('orc_beneficio_id'), $tbl_orc_beneficio->getColunaAlias('id'))
        ->leftJoin($tbl_beneficio->getTable(), $tbl_orc_beneficio->getColunaAlias('beneficio_id'), $tbl_beneficio->getColunaAlias('id'))

        ->leftJoin($tbl_cta_ctb->getTable(), $tbl_beneficio->getColunaAlias('cta_ct_id'), $tbl_cta_ctb->getColunaAlias('id'))

        ->leftJoin($tbl_evento->getTable(), $tbl_orc_beneficio->getColunaAlias('evento_id'), $tbl_evento->getColunaAlias('id'))

        ->leftJoin($tbl_ccusto->getTable(), $tbl_cargo_beneficio->getColunaAlias('ccusto_id'), $tbl_ccusto->getColunaAlias('id'))

        ->leftJoin($tbl_orc_lotacao->getTable(), $tbl_cargo_beneficio->getColunaAlias('orc_lotacao_id'), $tbl_orc_lotacao->getColunaAlias('id'))
        ->leftJoin($tbl_lotacao->getTable(), $tbl_orc_lotacao->getColunaAlias('lotacao_id'), $tbl_lotacao->getColunaAlias('id'))

        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario1"),
            DB::raw("usuario1.id"),
            DB::raw("{$this->getModelEntity()->getColunaAlias('created_by')}")
        )
        ->leftJoin(
            DB::raw("{$tbl_usuario->getTable()} as usuario2"),
            $tbl_calc_orc->getColunaAlias('updated_by'),
            DB::raw("usuario2.id")
        )

        ->select(
            DB::raw("{$tbl_cargo_beneficio->getColunaAlias('id')} as origem_id"),
            DB::raw("{$tbl_calc_orc->getColunaAlias('id')} as calc_id"),
            $tbl_cargo_beneficio->getColunaAlias('orcamento_id'),
            DB::raw("{$tbl_cargo_beneficio->getColunaAlias('orc_lotacao_id')} as id"),
            $tbl_cargo_beneficio->getColunaAlias('orc_lotacao_id'),
            $tbl_cargo_beneficio->getColunaAlias('orc_cargo_id'),
            $tbl_cargo_beneficio->getColunaAlias('orc_beneficio_id'),

            //$tbl_beneficio->getColunaAlias('tipo_calc'),
            $tbl_cargo_beneficio->getColunaAlias('vlr_movto'),
            //$tbl_beneficio->getColunaAlias('vlr_depend'),
            $tbl_beneficio->getColunaAlias('formula'),
            $tbl_calc_orc->getColunaAlias('origem_id'),
            $tbl_cta_ctb->getColunaAlias('cod_cta_ctbl'),
            $tbl_cta_ctb->getColunaAlias('desc_cta_ctbl'),
            $tbl_calc_orc->getColunaAlias('tbl_origem'),
            $tbl_lotacao->getColunaAlias('des_unid_lotac'),
            DB::raw("{$tbl_evento->getColunaAlias('id')} as event_id"),
            $tbl_evento->getColunaAlias('cdn_event'),
            $tbl_evento->getColunaAlias('des_event'),
            // $tbl_cargo_beneficio->getColunaAlias('cargo_id'),
            DB::raw("{$tbl_cargo->getColunaAlias('id')} as cargo_id"),
            $tbl_cargo_beneficio->getColunaAlias('vlr_maximo'),
            $tbl_cargo_beneficio->getColunaAlias('tipo_calc'),

            DB::raw("CASE {$tbl_cargo_beneficio->getColunaAlias('tipo_calc')} 
                WHEN 1 THEN '1 - Por hora'
                WHEN 2 THEN '2 - Proporcional'
                WHEN 3 THEN '3 - Fixo'
                WHEN 4 THEN '4 - Dias trabalhados'
                END as des_tipo_calc"),

            $tbl_cargo->getColunaAlias('cod_cargo_basic'),
            $tbl_cargo->getColunaAlias('des_cargo_basic'),
            DB::raw("CONCAT( {$tbl_cargo->getColunaAlias('cod_cargo_basic')}, '-', {$tbl_cargo->getColunaAlias('des_cargo_basic')}) as description_cargo"),
            DB::raw("CONCAT( {$tbl_evento->getColunaAlias('cdn_event')}, '-', {$tbl_evento->getColunaAlias('des_event')}) as description_beneficio"),
            DB::raw("CONCAT( {$tbl_cta_ctb->getColunaAlias('cod_cta_ctbl')}, '-', {$tbl_cta_ctb->getColunaAlias('desc_cta_ctbl')}) as description_cta_ctb"),
            DB::raw("CONCAT( {$tbl_ccusto->getColunaAlias('cod_ccusto')}, ' - ', {$tbl_lotacao->getColunaAlias('unid_lotac')}, '-', {$tbl_lotacao->getColunaAlias('des_unid_lotac')}) as description_lotacao"),
            $tbl_ccusto->getColunaAlias('ccusto_id'),
            $tbl_ccusto->getColunaAlias('cod_ccusto'),
            $tbl_ccusto->getColunaAlias('des_ccusto'),

            
            $tbl_calc_orc->getColunaAlias('jan_orcado'),
            $tbl_calc_orc->getColunaAlias('fev_orcado'),
            $tbl_calc_orc->getColunaAlias('mar_orcado'),
            $tbl_calc_orc->getColunaAlias('abr_orcado'),
            $tbl_calc_orc->getColunaAlias('mai_orcado'),
            $tbl_calc_orc->getColunaAlias('jun_orcado'),
            $tbl_calc_orc->getColunaAlias('jul_orcado'),
            $tbl_calc_orc->getColunaAlias('ago_orcado'),
            $tbl_calc_orc->getColunaAlias('set_orcado'),
            $tbl_calc_orc->getColunaAlias('out_orcado'),
            $tbl_calc_orc->getColunaAlias('nov_orcado'),
            $tbl_calc_orc->getColunaAlias('dez_orcado'),
            DB::raw("CASE WHEN usuario1.nome IS NOT NULL THEN usuario1.nome ELSE '-' END as criado_por"),
            DB::raw("CASE WHEN {$this->getModelEntity()->getColunaAlias('created_at')} IS NOT NULL THEN format({$this->getModelEntity()->getColunaAlias('created_at')}, 'dd/MM/yyyy') ELSE '-' END as criado_em"),
            
            DB::raw("CASE WHEN usuario2.nome IS NOT NULL THEN usuario2.nome ELSE '-' END as atualizado_por"),
            DB::raw("CASE WHEN {$tbl_calc_orc->getColunaAlias('updated_at')} IS NOT NULL THEN format({$tbl_calc_orc->getColunaAlias('updated_at')}, 'dd/MM/yyyy') ELSE '-' END as atualizado_em")
        )
        ->where([
            [$tbl_cargo_beneficio->getColunaAlias('orcamento_id'),'=',$orc_id],
            [$tbl_calc_orc->getColunaAlias('tbl_origem'),'=',$tbl_cargo_beneficio->getTable()],
            [$tbl_cargo_beneficio->getColunaAlias('tipo_table'), '=', $tipo_table]
        ]);
        //->whereIn($tbl_lotacao->getColunaAlias('id'),$lotacoes)
        $dados = [];
        if($tipo_table == 'F'){
            $dados = $query->where($tbl_cargo_beneficio->getColunaAlias('periodo'), $periodo)->get()->toArray();
        }
        else{
            $dados = $query->whereNull($tbl_cargo_beneficio->getColunaAlias('periodo'))->get()->toArray();
        }
        

        for($i = 0; $i < count($dados); $i++){
            //$dados[$i]['description_cta_ctb'] = $dados[$i]['cod_cta_ctbl'].' - '.$dados[$i]['desc_cta_ctbl'];
            $dados[$i]['identificador'] = "2";
        }

        return $dados;

        /*for ($i=0; $i < count($orc_lot_cargo_beneficio); $i++) {

            if($orc_lot_cargo_beneficio[$i]['tipo_calc'] == 1){
                $orc_lot_cargo_beneficio[$i]['des_tipo_calc'] = '1 - Por hora';
            }

            else if($orc_lot_cargo_beneficio[$i]['tipo_calc'] == 2){
                $orc_lot_cargo_beneficio[$i]['des_tipo_calc'] = '2 - Proporcional';
            }
            else if($orc_lot_cargo_beneficio[$i]['tipo_calc'] == 3){
                $orc_lot_cargo_beneficio[$i]['des_tipo_calc'] = '3 - Fixo';
            }
            else{
                $orc_lot_cargo_beneficio[$i]['des_tipo_calc'] = '4 - Dias trabalhados';
            }
            $orc_lot_cargo_beneficio[$i]['des_unid_lotac'] = $orc_lot_cargo_beneficio[$i]['get_lotacao']['get_lotacao']['des_unid_lotac'];
            $orc_lot_cargo_beneficio[$i]['description_lotacao'] = $orc_lot_cargo_beneficio[$i]['get_centro_custo']['cod_ccusto'].' - '.$orc_lot_cargo_beneficio[$i]['get_lotacao']['get_lotacao']['unid_lotac'].' - '.$orc_lot_cargo_beneficio[$i]['des_unid_lotac'];
            Arr::forget($orc_lot_cargo_beneficio[$i], 'get_lotacao');          
            Arr::forget($orc_lot_cargo_beneficio[$i], 'get_lotacao');
            $orc_lot_cargo_beneficio[$i]['event_id'] = $orc_lot_cargo_beneficio[$i]['get_orc_beneficio']['get_evento']['id'];
            $orc_lot_cargo_beneficio[$i]['cdn_event'] = $orc_lot_cargo_beneficio[$i]['get_orc_beneficio']['get_evento']['cdn_event'];         
            $orc_lot_cargo_beneficio[$i]['des_event'] = $orc_lot_cargo_beneficio[$i]['get_orc_beneficio']['get_evento']['des_event'];

            $orc_lot_cargo_beneficio[$i]['cod_cta_ctbl'] = $orc_lot_cargo_beneficio[$i]['get_orc_beneficio']['get_cta_ctb']['cod_cta_ctbl'];
            $orc_lot_cargo_beneficio[$i]['desc_cta_ctbl'] = $orc_lot_cargo_beneficio[$i]['get_orc_beneficio']['get_cta_ctb']['desc_cta_ctbl'];
            $orc_lot_cargo_beneficio[$i]['description_cta_ctb'] = $orc_lot_cargo_beneficio[$i]['cod_cta_ctbl'].' - '.$orc_lot_cargo_beneficio[$i]['desc_cta_ctbl'];
            
            
            $orc_lot_cargo_beneficio[$i]['description_beneficio'] = $orc_lot_cargo_beneficio[$i]['cdn_event'].' - '.$orc_lot_cargo_beneficio[$i]['des_event'];

            Arr::forget($orc_lot_cargo_beneficio[$i], 'get_evento', 'get_cta_ctb');          
            Arr::forget($orc_lot_cargo_beneficio[$i], 'get_orc_beneficio');

            // $orc_lot_cargo_beneficio[$i]['calc_id'] = $orc_lot_cargo_beneficio[$i]['get_calc_orcamento'][0]['id'];
            // Arr::forget($orc_lot_cargo_beneficio[$i], 'get_calc_orcamento');

            $orc_lot_cargo_beneficio[$i]['cargo_id'] = $orc_lot_cargo_beneficio[$i]['get_orc_cargo']['get_cargo']['id'];
            $orc_lot_cargo_beneficio[$i]['cod_cargo_basic'] = $orc_lot_cargo_beneficio[$i]['get_orc_cargo']['get_cargo']['cod_cargo_basic'];         
            $orc_lot_cargo_beneficio[$i]['des_cargo_basic'] = $orc_lot_cargo_beneficio[$i]['get_orc_cargo']['get_cargo']['des_cargo_basic'];
            $orc_lot_cargo_beneficio[$i]['description_cargo'] = $orc_lot_cargo_beneficio[$i]['cod_cargo_basic'].' - '.$orc_lot_cargo_beneficio[$i]['des_cargo_basic'];
            Arr::forget($orc_lot_cargo_beneficio[$i], 'get_cargo');
            Arr::forget($orc_lot_cargo_beneficio[$i], 'get_orc_cargo');

            $orc_lot_cargo_beneficio[$i]['cod_ccusto'] = $orc_lot_cargo_beneficio[$i]['get_centro_custo']['cod_ccusto'];         
            $orc_lot_cargo_beneficio[$i]['des_ccusto'] = $orc_lot_cargo_beneficio[$i]['get_centro_custo']['des_ccusto'];
            Arr::forget($orc_lot_cargo_beneficio[$i], 'get_centro_custo');
            
            // $orc_lot_cargo_beneficio[$i]['calc_orcamento_id'] = $orc_lot_cargo_beneficio[$i]['get_calc_orcamento']['id'];
            // unset($orc_lot_cargo_beneficio[$i]['get_calc_orcamento']['id']);
            // $orc_lot_cargo_beneficio[$i]= array_merge($orc_lot_cargo_beneficio[$i], $orc_lot_cargo_beneficio[$i]['get_calc_orcamento']);            
            // Arr::forget($orc_lot_cargo_beneficio[$i], 'get_calc_orcamento');  

            $orc_lot_cargo_beneficio[$i]['vlr_movto']=formatarNumeroPtBr($orc_lot_cargo_beneficio[$i]['vlr_movto'], 6);
            $orc_lot_cargo_beneficio[$i]['vlr_maximo']=formatarNumeroPtBr($orc_lot_cargo_beneficio[$i]['vlr_maximo'], 6);
            //$orc_lot_cargo_beneficio[$i]['vlr_depend']=formatarNumeroPtBr($orc_lot_cargo_beneficio[$i]['vlr_depend']);
            $orc_lot_cargo_beneficio[$i]['jan_orcado']=formatarNumeroPtBr($orc_lot_cargo_beneficio[$i]['jan_orcado'], 6);
            $orc_lot_cargo_beneficio[$i]['fev_orcado']=formatarNumeroPtBr($orc_lot_cargo_beneficio[$i]['fev_orcado'], 6);
            $orc_lot_cargo_beneficio[$i]['mar_orcado']=formatarNumeroPtBr($orc_lot_cargo_beneficio[$i]['mar_orcado'], 6);
            $orc_lot_cargo_beneficio[$i]['abr_orcado']=formatarNumeroPtBr($orc_lot_cargo_beneficio[$i]['abr_orcado'], 6);
            $orc_lot_cargo_beneficio[$i]['mai_orcado']=formatarNumeroPtBr($orc_lot_cargo_beneficio[$i]['mai_orcado'], 6);
            $orc_lot_cargo_beneficio[$i]['jun_orcado']=formatarNumeroPtBr($orc_lot_cargo_beneficio[$i]['jun_orcado'], 6);
            $orc_lot_cargo_beneficio[$i]['jul_orcado']=formatarNumeroPtBr($orc_lot_cargo_beneficio[$i]['jul_orcado'], 6);
            $orc_lot_cargo_beneficio[$i]['ago_orcado']=formatarNumeroPtBr($orc_lot_cargo_beneficio[$i]['ago_orcado'], 6);
            $orc_lot_cargo_beneficio[$i]['set_orcado']=formatarNumeroPtBr($orc_lot_cargo_beneficio[$i]['set_orcado'], 6);
            $orc_lot_cargo_beneficio[$i]['out_orcado']=formatarNumeroPtBr($orc_lot_cargo_beneficio[$i]['out_orcado'], 6);
            $orc_lot_cargo_beneficio[$i]['nov_orcado']=formatarNumeroPtBr($orc_lot_cargo_beneficio[$i]['nov_orcado'], 6);
            $orc_lot_cargo_beneficio[$i]['dez_orcado']=formatarNumeroPtBr($orc_lot_cargo_beneficio[$i]['dez_orcado'], 6); 
        
            $orc_lot_cargo_beneficio[$i]['identificador'] = "2";
            
                      
        }
        //dd($orc_lot_cargo_beneficio);
        return $orc_lot_cargo_beneficio;*/
    }  

    public function listaEventos(){
        $orcBeneficio = OrcBeneficio::with([
            'getEvento'=>function($query){
    
            }
        ])->get()
        ->toArray();
      
       
        for ($i=0; $i < count($orcBeneficio); $i++) {             
            $orcBeneficio[$i]['des_event'] = $orcBeneficio[$i]['get_evento']['des_event'];
            Arr::forget($orcBeneficio[$i], 'get_evento');
        }

        return $orcBeneficio;
    }  
    
    public function deleteOrclotCargoBeneficio($data_request){        
        
        // $tbl_lotacao = new OrcLotacao();
        // $estrutura = new OrcLotacaoController();
        
        // if(!$this->getRespEstrutura($data_request['orcamento_id'],$data_request['orc_lotacao_id'])){
        //     $this->setError("Impossível acessar a lotação selecionada. <br>Erro: 200520201654");
        //     return false;
        // }

        $retorno=true;
        $instance = $this;
        //dd($data_request);
        DB::transaction(function()use(&$retorno, $data_request, $instance){
            $calc_indice = new CalcIndice();
            $repo_calc_ind = new RepoCalcIndice();
            $repo_calc_orcamento = new RepoCalcOrcamento();

            if(!$instance->deleteParent($data_request['origem_id'])){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }          
            
            $select_calc = $repo_calc_orcamento->getModelEntity()->select()->where([
                [$repo_calc_orcamento->getModelEntity()->getColunaAlias('origem_id'),'=',$data_request['origem_id']],
                [$repo_calc_orcamento->getModelEntity()->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
            ])->get()->toArray();

            $calc_orcamento_id['id'] = $select_calc[0]['id'];
            
            if(! $repo_calc_orcamento->delete($calc_orcamento_id['id'])){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }

            $select_indice = $calc_indice->select()->where([
                [$calc_indice->getColunaAlias('origem_id'),'=',$data_request['origem_id']],
                [$calc_indice->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
            ])->get()->toArray();
            
            if(count($select_indice)>0)
            {
                $delete_indices = $repo_calc_ind->getModelEntity()->where([
                    [$repo_calc_ind->getModelEntity()->getColunaAlias('origem_id'),'=',$data_request['origem_id']],
                    [$repo_calc_ind->getModelEntity()->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]])
                ->delete();

                if(!$delete_indices){
                    $retorno = true;
                    abort(500, $retorno['msg']);
                    return false;
                }
            }

            
                        
        });
        
        return $retorno;
    }

    public function deleteParent($data_request){
        return parent::delete($data_request);
    }

    public function updateOrcLotCargoBeneficio($data_request){        

        // if(!$this->getRespEstrutura($data_request['orcamento_id'],$data_request['orc_lotacao_id'])){
        //     $this->setError("Impossível acessar a lotação selecionada. <br>Erro: 200520201633");
        //     return false;
        // }

        $retorno=true;
        $instance = $this;

        
        DB::transaction(function()use(&$retorno, $data_request, $instance){
            
            $repo_calc_orcamento = new RepoCalcOrcamento();
            
            $lot_cargo = Arr::only($data_request,['id','orcamento_id','orc_lotacao_id','orc_cargo_id',
            'orc_beneficio_id','ccusto_id','tipo_calc','formula','origem_id']);

            
            if($data_request['vlr_depend']==null){
                $data_request['vlr_depend']=0;
            }
            if($data_request['vlr_movto']==null){
                $data_request['vlr_movto']=0;
            }

            $vlr_movto=array('vlr_movto'=>convertDec($data_request['vlr_movto']));
            $vlr_depend=array('vlr_depend'=>convertDec($data_request['vlr_depend']));
            //dd("dfs",$vlr_movto,$vlr_depend, empty(trim($vlr_depend['vlr_depend'])));
            
            $array_lot_cargo=array_merge($lot_cargo,$vlr_movto,$vlr_depend);
            //dd("cfv",$array_lot_cargo);
            if(!$instance->updateParent($array_lot_cargo, $array_lot_cargo['origem_id'])){       
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }
            
            //$calc_orcamento_id['id'] = $data_request['id'];
            //dd("id",$calc_orcamento_id);
            $dados_orc=Arr::except($data_request,['orcamento_id','empresa_id','beneficio_id','evento_id','tipo_calc',
            'formula','vlr_movto','vlr_depend']);

            /*$dados_orcamento = Arr::except($dados_orc,['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jun_orcado','ago_orcado','jul_orcado','set_orcado',
            'out_orcado','nov_orcado','dez_orcado']);*/

            $meses=Arr::only($dados_orc,['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jul_orcado','ago_orcado','set_orcado',
            'out_orcado','nov_orcado','dez_orcado']);

            $orcamento = convertDecimalEn($meses);
            // $array_orcamento = array_merge($dados_orcamento,$orcamento);
            
            $calc_orcamento_id['id'] = $data_request['id'];
           
            // $repo_calc_orcamento->getModelEntity()->where([
            //     [$repo_calc_orcamento->getModelEntity()->getColunaAlias('origem_id'), $array_lot_cargo['origem_id']],
            //     [$repo_calc_orcamento->getModelEntity()->getColunaAlias('tbl_origem'), $repo_calc_orcamento->getModelEntity()->getTable()],
            // ])->update();

            $select_calc_id = $repo_calc_orcamento->getModelEntity()->select()->where([
                [$repo_calc_orcamento->getModelEntity()->getColunaAlias('origem_id'), '=', $data_request['origem_id']],
                [$repo_calc_orcamento->getModelEntity()->getColunaAlias('tbl_origem'), '=', $this->getModelEntity()->getTable()]
            ])->get()->toArray();

            
            if(! $repo_calc_orcamento->update($orcamento, $select_calc_id[0]['id'])){     
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }
        });
        return $retorno;
    }

    public function updateIndice($form_data){

        // if(!$this->getRespEstrutura($form_data['orcamento_id'],$form_data['orc_lotacao_id'])){
        //     $this->setError("Impossível acessar a lotação selecionada. <br>Erro: 200520201633");
        //     return false;
        // }
        $tbl_calc_indice = new RepoCalcIndice();
        $meses = Arr::only($form_data,['jan_indice','fev_indice','marc_indice','abril_indice','maio_indice','jun_indice','jul_indice','agost_indice','set_indice','out_indice','nov_indice','dez_indice']);
        $meses = convertDecimalEn($meses);
        
        $id = $form_data['calc_indice_id'];
        
        $update = $tbl_calc_indice->update($meses,$id);
        
        if(!$update){
            $this->setError('Erro ao atualizar registro. Erro:060420200941');
            
            return false;
        }
        return true;
    }

    public function updateParent($data_request, $id){
        $dados=$this->getModelEntity()->select()->where($this->getModelEntity()->getColunaAlias('id'),'=',$id)->get()->toArray();
        
        if(count($dados)==1){
            return parent::update($data_request, $id);
        }
        return false;
       
    }

    public function deleteIndice($form_data){
        $repo_calc_ind = new RepoCalcIndice();
        $calc_orcamento = new CalcOrcamento();

        // $tbl_lotacao = new OrcLotacao();
        // $estrutura = new OrcLotacaoController();
        
        // $dados = $estrutura->makeEstrutura($form_data['orcamento_id']);
        // $lotacoes = (array_column($dados, 'lotacao_id'));
        
        // $select = $tbl_lotacao->select()->where([
        //     ['orcamento_id',$form_data['orcamento_id']],
        //     ['id',$form_data['orc_lotacao_id']]
        
        // ])
        // ->whereIn('lotacao_id',$lotacoes)
        // ->get()->toArray();

        
        // if(count($select) == 0){
        //     $this->setError("Impossível acessar a lotação selecionada. <br>Erro: 200520201558");
        //     return false;
        // }
        
        $select = $calc_orcamento->select()->where([
            [$calc_orcamento->getColunaAlias('origem_id'),'=',$form_data['id']],
            [$calc_orcamento->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
        ])->get()->toArray();
        
        if(count($select)>0){
            $indices_excluir = $repo_calc_ind->getModelEntity()->where([
                [$repo_calc_ind->getModelEntity()->getColunaAlias('origem_id'),'=',$form_data['id']],
                [$repo_calc_ind->getModelEntity()->getColunaAlias('tbl_origem'),'=',$this->getModelEntity()->getTable()]
            ])->delete();

            if(!$indices_excluir){
                $this->setError("Erro ao excluir registro. erro:090420200935");
                return false;
            }
        }
        else{

            DB::beginTransaction();
            try {
                if(!$this->delete($form_data['id'])){
                    return false;
                }    
                
                if(!$repo_calc_ind->delete($form_data['calc_indice_id'])){
                    return false;
                }    
                
                DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500,'Falha ao cadastrar cargo no orçamento. Erro: 060420200950.'.$e);
                return false;
            }
        }
        return true;
    }
}

