<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Entities\CalcOrcamento;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use App\Modules\Natureza51\Entities\OrcLotFuncionatioBeneficio;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class RepoOrcLotFuncionarioBeneficio extends RepoOrcamento
{
    protected $model_name_space='App\Modules\Natureza51\Entities\OrcLotFuncionatioBeneficio';
//     protected $form_rules=[
//         ''=>'required|unique:tbl_evetbl_orc_beneficio_funcionariontos,cdn_event'
//    ];
//    protected $rules_msg=[
//         'cdn_event.required'=>'O campo Cód. Evento é obrigatório',
//         'cdn_event.unique'=>'Cód. Evento já cadastrado'
//    ]; 
                            
    public function createOrcLotFuncionarioBeneficio($data_request){        
        $retorno=true;
        $instance = $this;

        DB::transaction(function()use(&$retorno, $data_request, $instance){
            
            $repo_calc_orcamento = new RepoCalcOrcamento();
            
            $id_orc_lot_funcionario_ben = $instance->createParent($data_request);
            
            if(! $id_orc_lot_funcionario_ben){  
                $retorno = false;
                return false;
            }  
            
            $merge_tb_calc = [
                'origem_id' => $id_orc_lot_funcionario_ben->id,
                'tbl_origem' => $instance->getModelEntity()->getTable()
            ];
            
            if(! $repo_calc_orcamento->create(array_merge($merge_tb_calc, $data_request['meses_orcado']))){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }
                        
        });
        //dd("fbmgkl",$data_request);
        return $retorno;
    }

    public function createParent($data_request){
        $dados=$this->getModelEntity()->select()->where([
            [$this->getModelEntity()->getColunaAlias('orcamento_id'),'=',$data_request['orcamento_id']],
            [$this->getModelEntity()->getColunaAlias('funcionario_id'),'=',$data_request['funcionario_id']],
            [$this->getModelEntity()->getColunaAlias('orc_lotacao_id'),'=',$data_request['orc_lotacao_id']],
            [$this->getModelEntity()->getColunaAlias('ccusto_id'),'=',$data_request['ccusto_id']],
            [$this->getModelEntity()->getColunaAlias('orc_beneficio_id'),'=',$data_request['orc_beneficio_id']],
        ])->get()->toArray();
        
        if(count($dados)==0){
            return parent::create($data_request);
        }else{
            $this->setError("Registro já cadastrado! erro:180220201018");
            
            abort(500, "Registro já cadastrado! erro:180220201018");
            return false;
        }
    }

    public function listar($data_request){

        $tbl_calc_orc=new CalcOrcamento();

        $orc_lot_funcionario_beneficio = OrcLotFuncionatioBeneficio::
        join($tbl_calc_orc->getTable(),$this->getModelEntity()->getColunaAlias('id'),
        DB::raw($tbl_calc_orc->getColunaAlias('origem_id').' and '.$tbl_calc_orc->getColunaAlias('tbl_origem').' = '."'tbl_orc_beneficio_funcionario'"))
        ->with([
            'getOrcBeneficio'=>function($query){
                return $query->with([
                    'getEvento'=>function($query){
                        return $query;
                    }]);
            },
            'getFuncionario'=>function($query){
                return $query;
            },
            'getCalcOrcamento'=>function($query){
                return $query;
            },
            'getCentroCusto'=>function($query){
                return $query;
            },
            'getOrcLotacao'=>function($query){
                return $query->with([
                    'getLotacao'=>function($query){
                        return $query;
                    }
                ]);
            }
        ])->where([
            'orcamento_id'=> $data_request['orcamento_id']
        ])
        ->get()
        ->toArray();
        // dd($orc_lot_funcionario_beneficio);
        for ($i=0; $i < count($orc_lot_funcionario_beneficio); $i++) {  
            
            $orc_lot_funcionario_beneficio[$i]['des_unid_lotac'] = $orc_lot_funcionario_beneficio[$i]['get_orc_lotacao']['get_lotacao']['des_unid_lotac'];
            $orc_lot_funcionario_beneficio[$i]['description'] = $orc_lot_funcionario_beneficio[$i]['orc_lotacao_id'].' - '.$orc_lot_funcionario_beneficio[$i]['get_orc_lotacao']['get_lotacao']['des_unid_lotac'];
            Arr::forget($orc_lot_funcionario_beneficio[$i], 'get_lotacao');          
            Arr::forget($orc_lot_funcionario_beneficio[$i], 'get_orc_lotacao');

            $orc_lot_funcionario_beneficio[$i]['event_id'] = $orc_lot_funcionario_beneficio[$i]['get_orc_beneficio']['get_evento']['id'];
            $orc_lot_funcionario_beneficio[$i]['cdn_event'] = $orc_lot_funcionario_beneficio[$i]['get_orc_beneficio']['get_evento']['cdn_event'];         
            $orc_lot_funcionario_beneficio[$i]['des_event'] = $orc_lot_funcionario_beneficio[$i]['get_orc_beneficio']['get_evento']['des_event'];  
            Arr::forget($orc_lot_funcionario_beneficio[$i], 'get_evento');          
            Arr::forget($orc_lot_funcionario_beneficio[$i], 'get_orc_beneficio');
            
            $orc_lot_funcionario_beneficio[$i]['cdn_funcionario'] = $orc_lot_funcionario_beneficio[$i]['get_funcionario']['cdn_funcionario'];         
            $orc_lot_funcionario_beneficio[$i]['nome_funcionario'] = $orc_lot_funcionario_beneficio[$i]['get_funcionario']['nome_funcionario'];
            $orc_lot_funcionario_beneficio[$i]['num_reg_func'] = $orc_lot_funcionario_beneficio[$i]['get_funcionario']['num_reg_func'];
            Arr::forget($orc_lot_funcionario_beneficio[$i], 'get_funcionario');

            $orc_lot_funcionario_beneficio[$i]['cod_ccusto'] = $orc_lot_funcionario_beneficio[$i]['get_centro_custo']['cod_ccusto'];         
            $orc_lot_funcionario_beneficio[$i]['des_ccusto'] = $orc_lot_funcionario_beneficio[$i]['get_centro_custo']['des_ccusto'];
            Arr::forget($orc_lot_funcionario_beneficio[$i], 'get_centro_custo');

            // $orc_lot_funcionario_beneficio[$i]['calc_orcamento_id'] = $orc_lot_funcionario_beneficio[$i]['get_calc_orcamento']['id'];
            // unset($orc_lot_funcionario_beneficio[$i]['get_calc_orcamento']['id']);
            // $orc_lot_funcionario_beneficio[$i]= array_merge($orc_lot_funcionario_beneficio[$i], $orc_lot_funcionario_beneficio[$i]['get_calc_orcamento']);            
            // Arr::forget($orc_lot_funcionario_beneficio[$i], 'get_calc_orcamento');  

            $orc_lot_funcionario_beneficio[$i]['vlr_movto']=formatarNumeroPtBr($orc_lot_funcionario_beneficio[$i]['vlr_movto']);
            $orc_lot_funcionario_beneficio[$i]['vlr_depend']=formatarNumeroPtBr($orc_lot_funcionario_beneficio[$i]['vlr_depend']);
            $orc_lot_funcionario_beneficio[$i]['jan_orcado']=formatarNumeroPtBr($orc_lot_funcionario_beneficio[$i]['jan_orcado']);
            $orc_lot_funcionario_beneficio[$i]['fev_orcado']=formatarNumeroPtBr($orc_lot_funcionario_beneficio[$i]['fev_orcado']);
            $orc_lot_funcionario_beneficio[$i]['mar_orcado']=formatarNumeroPtBr($orc_lot_funcionario_beneficio[$i]['mar_orcado']);
            $orc_lot_funcionario_beneficio[$i]['abr_orcado']=formatarNumeroPtBr($orc_lot_funcionario_beneficio[$i]['abr_orcado']);
            $orc_lot_funcionario_beneficio[$i]['mai_orcado']=formatarNumeroPtBr($orc_lot_funcionario_beneficio[$i]['mai_orcado']);
            $orc_lot_funcionario_beneficio[$i]['jun_orcado']=formatarNumeroPtBr($orc_lot_funcionario_beneficio[$i]['jun_orcado']);
            $orc_lot_funcionario_beneficio[$i]['jul_orcado']=formatarNumeroPtBr($orc_lot_funcionario_beneficio[$i]['jul_orcado']);
            $orc_lot_funcionario_beneficio[$i]['ago_orcado']=formatarNumeroPtBr($orc_lot_funcionario_beneficio[$i]['ago_orcado']);
            $orc_lot_funcionario_beneficio[$i]['set_orcado']=formatarNumeroPtBr($orc_lot_funcionario_beneficio[$i]['set_orcado']);
            $orc_lot_funcionario_beneficio[$i]['out_orcado']=formatarNumeroPtBr($orc_lot_funcionario_beneficio[$i]['out_orcado']);
            $orc_lot_funcionario_beneficio[$i]['nov_orcado']=formatarNumeroPtBr($orc_lot_funcionario_beneficio[$i]['nov_orcado']);
            $orc_lot_funcionario_beneficio[$i]['dez_orcado']=formatarNumeroPtBr($orc_lot_funcionario_beneficio[$i]['dez_orcado']); 
                      
        }
        //dd($orc_lot_funcionario_beneficio);
        return $orc_lot_funcionario_beneficio;
    }  

    public function listaEventos(){
        $orcBeneficio = OrcBeneficio::with([
            'getEvento'=>function($query){
    
            }
        ])->get()
        ->toArray();
      
       
        for ($i=0; $i < count($orcBeneficio); $i++) {             
            $orcBeneficio[$i]['des_event'] = $orcBeneficio[$i]['get_evento']['des_event'];
            Arr::forget($orcBeneficio[$i], 'get_evento');

        }

        return $orcBeneficio;
    }  
    
    public function deleteOrcLotFuncionarioBeneficio($data_request){        
        $retorno=true;
        $instance = $this;
        
        DB::transaction(function()use(&$retorno, $data_request, $instance){
            
            $repo_calc_orcamento = new RepoCalcOrcamento();

            if(!$instance->getModelEntity()->where($instance->getModelEntity()->getColunaAlias('id'),'=',$data_request['origem_id'])->delete()){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }          

            if(!$repo_calc_orcamento->getModelEntity()->where($repo_calc_orcamento->getModelEntity()->getColunaAlias('id'),'=',$data_request['id'])->delete()){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }
                        
        });
        
        return $retorno;
    }

    public function deleteParent($data_request){
        return parent::delete($data_request);
    }

    public function updateOrcLotFuncionarioBeneficio($data_request){        
        $retorno=true;
        $instance = $this;
        
        DB::transaction(function()use(&$retorno, $data_request, $instance){
            
            $repo_calc_orcamento = new RepoCalcOrcamento();

            $orc_lot_func = Arr::only($data_request,['id','orcamento_id', 'funcionario_id', 'orc_lotacao_id', 'ccusto_id',
            'orc_beneficio_id', 'tipo_calc', 'formula','origem_id']);

            if($data_request['vlr_depend']==null){
                $data_request['vlr_depend']=0;
            }
            if($data_request['vlr_movto']==null){
                $data_request['vlr_movto']=0;
            }

            // $vlr_movto=array('vlr_movto'=>convertDec($data_request['vlr_movto']));
            // $vlr_depend=array('vlr_depend'=>convertDec($data_request['vlr_depend']));

            $vlr_movto = array("vlr_movto"=>convertDec($data_request['vlr_movto']));
            $vlr_depend = array("vlr_depend"=>convertDec($data_request['vlr_depend']));
    
            $array_lot_cargo=array_merge($orc_lot_func,$vlr_movto,$vlr_depend);
            
            if(!$instance->updateParent($array_lot_cargo, $array_lot_cargo['origem_id'])){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }          
            
            $calc_orcamento_id['id'] = $data_request['id'];
            $dados_orc=Arr::except($data_request,['orcamento_id','empresa_id','beneficio_id','evento_id','tipo_calc',
            'formula','vlr_movto','vlr_depend']);

            $dados_orcamento = Arr::except($dados_orc,['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jun_orcado','ago_orcado','jul_orcado','set_orcado',
            'out_orcado','nov_orcado','dez_orcado']);

            $meses=Arr::only($dados_orc,['jan_orcado','fev_orcado','mar_orcado','abr_orcado','mai_orcado','jun_orcado','jun_orcado','ago_orcado','set_orcado',
            'out_orcado','nov_orcado','dez_orcado']);

            $orcamento = convertDec($meses);
            $array_orcamento = array_merge($dados_orcamento,$orcamento);
            //dd("dcs",$data_request);
            $calc_orcamento_id['id'] = $data_request['id'];

            if(! $repo_calc_orcamento->update($array_orcamento, $calc_orcamento_id['id'])){                    
                $retorno = true;
                abort(500, $retorno['msg']);
                return false;
            }
                        
        });
        
        return $retorno;
    }

    public function updateParent($data_request, $id){
        $dados=$this->getModelEntity()->select()->where($this->getModelEntity()->getColunaAlias('id'),'=',$id)->get()->toArray();
        if(count($dados)==1){
            return parent::update($data_request, $id);
        }
        return false;

    }
}

