<?php

namespace App\Modules\Natureza51\Repositories;

use App\Modules\Natureza51\Repositories\RepositoryNat51;
use App\Modules\Natureza51\Entities\OrcLotacao;
use App\Modules\Natureza51\Entities\Funcionario;
use App\Modules\Natureza51\Entities\Lotacao;
use App\Modules\Natureza51\Entities\CentroCusto;
use App\Modules\Natureza51\Repositories\RepoOrcamento;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class RepoOrcLotacao extends RepoOrcamento
{

    protected $model_name_space='App\Modules\Natureza51\Entities\OrcLotacao';
    protected $form_rules=[];

   protected $rules_msg=[]; 
   
   public function listar($orc_id){  
    
    $lotacoes = OrcLotacao::with([
        'getLotacao'=>function($query){            
            return $query;
        },
        'getCentroCusto'=>function($query){
            return $query;
        }
    ])->where('orcamento_id','=',intval($orc_id))
    ->get();    
    $array_lotacao = [];
    for ($i=0; $i < count($lotacoes); $i++) { 
        if($lotacoes[$i]->getLotacao->ativo != 1){
            continue;
        }
        $lotacoes[$i]['quadro_atual'] = $lotacoes[$i]->getLotacao->quadro_atual;
        $lotacoes[$i]['ativo'] = $lotacoes[$i]->getLotacao->ativo;
        $lotacoes[$i]['unid_lotac'] = $lotacoes[$i]->getLotacao->unid_lotac;
        // $lotacoes[$i]['des_unid_lotac'] = $lotacoes[$i]->getLotacao->des_unid_lotac;
        // $lotacoes[$i]['cod_ccusto'] = $lotacoes[$i]->getCentroCusto->cod_ccusto;
        $lotacoes[$i]['des_ccusto'] = $lotacoes[$i]->getCentroCusto->des_ccusto;
        $lotacoes[$i]['description'] = $lotacoes[$i]->getCentroCusto->cod_ccusto.' - '.$lotacoes[$i]->getLotacao->unid_lotac.' '. $lotacoes[$i]->getLotacao->des_unid_lotac;

        switch ($lotacoes[$i]['status']) {
            case '1':
                $lotacoes[$i]['status_label'] = 'Pendente';
            break;
            case '2':
                $lotacoes[$i]['status_label'] = 'Em Andamento';
            break;
            case '3':
                $lotacoes[$i]['status_label'] = 'Enviado';
            break;  
            case '4':
                $lotacoes[$i]['status_label'] = 'Reaberto';
            break;
            case '5':
                $lotacoes[$i]['status_label'] = 'Em Conferência';
            break;  
            case '6':
                $lotacoes[$i]['status_label'] = 'Liberado';
            break;
            case '7':
                $lotacoes[$i]['status_label'] = 'Finalizado';
            break;
            case '8':
                $lotacoes[$i]['status_label'] = 'Aprovado';
            break;
            case '9':
                $lotacoes[$i]['status_label'] = 'Em Execução';
            break;
            case '10':
                $lotacoes[$i]['status_label'] = 'Enviado Sistema';
            break;
            default:
                $lotacoes[$i]['status_label'] = $lotacoes[$i]['status']; 
            break;
        }

        Arr::forget($lotacoes[$i], 'getLotacao');
        Arr::forget($lotacoes[$i], 'getCentroCusto');

        array_push($array_lotacao,$lotacoes[$i]);
    }
    
    
        return $array_lotacao;
    } 

    public function listarLotAtiva($orc_id){
        $lotacao = new Lotacao();
        $funcionario = new Funcionario();
        $ccusto = new CentroCusto();

        $resp = $lotacao->join($funcionario->getTable(),
        $funcionario->getColunaAlias('lotacao_id'),'=',
        DB::raw($lotacao->getColunaAlias('id') .' and '. $funcionario->getColunaAlias('dat_demis_func') .' is null ' )
        )->join($ccusto->getTable(),
        $ccusto->getColunaAlias('id'),'=', 
        DB::raw($funcionario->getColunaAlias('ccusto_id') .' and '. $ccusto->getColunaAlias('ativo') .' = 1' )
        )
        ->join($this->getModelEntity()->getTable(),
        $this->getModelEntity()->getColunaAlias('lotacao_id'),'=',
        DB::raw($lotacao->getColunaAlias('id') .' and '. $this->getModelEntity()->getColunaAlias('cc_custo_id') .' = ' . $ccusto->getColunaAlias('id'))
        )
        ->select(
            DB::raw("DISTINCT {$lotacao->getColunaAlias('unid_lotac')}"),
            $this->getModelEntity()->getColunaAlias('id'), 
            $lotacao->getColunaAlias('des_unid_lotac'),
            DB::raw("CONCAT({$ccusto->getColunaAlias('cod_ccusto')}, ' - ', {$lotacao->getColunaAlias('unid_lotac')}, ' - ' , {$lotacao->getColunaAlias('des_unid_lotac')}) description "),
            $this->getModelEntity()->getColunaAlias('orcamento_id'), 
            $this->getModelEntity()->getColunaAlias('responder_orc'), 
            $this->getModelEntity()->getColunaAlias('cc_custo_id'), 
            $ccusto->getColunaAlias('des_ccusto'), 
            $this->getModelEntity()->getColunaAlias('status'),   
            DB::raw("CASE 
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 1 THEN 'Pendente'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 2 THEN 'Em Andamento'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 3 THEN 'Enviado'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 4 THEN 'Reaberto'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 5 THEN 'Em Conferência'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 6 THEN 'Liberado'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 7 THEN 'Finalizado'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 8 THEN 'Aprovado'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 9 THEN 'Em Execução'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 10 THEN 'Enviado Sistema'
                            WHEN {$this->getModelEntity()->getColunaAlias('status')} = 11 THEN 'Rejeitado'
                        END as status_label"),
            $this->getModelEntity()->getColunaAlias('user_id'),
            $this->getModelEntity()->getColunaAlias('empresa_id'),
            $this->getModelEntity()->getColunaAlias('created_at'), 
            $this->getModelEntity()->getColunaAlias('updated_at')
        )
        ->where($this->getModelEntity()->getColunaAlias('orcamento_id'), $orc_id)
        ->orderby($lotacao->getColunaAlias('des_unid_lotac'))
        ->get();
           
        return $resp;

    }
  
    public function sendRh($id){
       $lot = $this->getModelEntity()->where('id',$id)->first();
       if($lot->status == $this->getStatusPendente() || $lot->status == $this->getStatusEnviado() || $lot->status == $this->getStatusEmConferencia() || $lot->status == $this->getStatusLiberado()){
            return array("status"=>"error","msg"=>'Operação indisponível. Tente novamente mais tarde.<br/> Erro: 150120200952.');
       };

       $retorno = $this->sendStatus($id,$this->getModelNameSpace()); 
       return $retorno;
   
    }

   
    public function setStatus($id){
        
        $retorno['msg']='Envio Realizado com Sucesso';
        $retorno['status']='success';
            
            $lot = $this->getModelEntity()->find($id);

            if(!$lot){
                $retorno['msg']='Lotação escolhida inexistente!';
                $retorno['status']='warning';
                goto saida;
            }
        $lot->status = 3;
        if(!$lot->save()){
                $retorno['msg']='Erro ao Enviar o Headcount';
                $retorno['status']='error';
        }
            
        saida:
        return $retorno;
    }
}
